/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr;

import javax.jcr.NoSuchWorkspaceException;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.TestUtils;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate.NodeStateSolrServersObserver;
import org.apache.jackrabbit.oak.plugins.index.solr.index.SolrIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.util.SolrIndexInitializer;
import org.apache.jackrabbit.oak.plugins.nodetype.write.InitialContent;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.memory.MemoryStore;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.OpenSecurityProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.solr.client.solrj.SolrServer;
import org.junit.After;
import org.junit.Before;

public abstract class SolrBaseTest {
    protected NodeStore store;
    protected TestUtils provider;
    protected SolrServer server;
    protected OakSolrConfiguration configuration;
    protected EditorHook hook;
    private ContentRepository repository;

    @Before
    public void setUp() throws Exception {
        this.store = SegmentNodeStore.builder((SegmentStore)new MemoryStore()).build();
        this.provider = new TestUtils();
        this.server = this.provider.getSolrServer();
        this.configuration = this.provider.getConfiguration();
        this.hook = new EditorHook((EditorProvider)new IndexUpdateProvider((IndexEditorProvider)new SolrIndexEditorProvider((SolrServerProvider)this.provider, (OakSolrConfigurationProvider)this.provider)));
        Oak oak = new Oak().with((RepositoryInitializer)new InitialContent()).with((SecurityProvider)new OpenSecurityProvider()).with((RepositoryInitializer)new SolrIndexInitializer(false)).with((QueryIndexProvider)new SolrQueryIndexProvider((SolrServerProvider)this.provider, (OakSolrConfigurationProvider)this.provider)).with((Observer)new NodeStateSolrServersObserver()).with((IndexEditorProvider)new SolrIndexEditorProvider((SolrServerProvider)this.provider, (OakSolrConfigurationProvider)this.provider));
        this.repository = oak.createContentRepository();
    }

    @After
    public void tearDown() throws Exception {
        if (this.server != null && this.server.ping() != null) {
            this.server.deleteByQuery("*:*");
            this.server.commit();
            this.server = null;
        }
    }

    protected Root createRoot() throws LoginException, NoSuchWorkspaceException {
        return this.repository.login(null, null).getLatestRoot();
    }
}

