/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.util.Arrays;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.solr.common.SolrDocumentList;

class LMSEstimator {
    private static final double DEFAULT_ALPHA = 0.03;
    private static final int DEFAULT_THRESHOLD = 5;
    private double[] weights;
    private final double alpha;
    private final long threshold;

    LMSEstimator(double alpha, double[] weights, long threshold) {
        this.alpha = alpha;
        this.weights = weights;
        this.threshold = threshold;
    }

    LMSEstimator(double[] weights) {
        this(0.03, weights, 5L);
    }

    LMSEstimator() {
        this(0.03, new double[5], 5L);
    }

    synchronized void update(Filter filter, SolrDocumentList docs) {
        double[] updatedWeights = new double[this.weights.length];
        long estimate = this.estimate(filter);
        long numFound = docs.getNumFound();
        long residual = numFound - estimate;
        double delta = Math.pow(residual, 2.0);
        if (Math.abs(delta) > (double)this.threshold) {
            for (int i = 0; i < updatedWeights.length; ++i) {
                updatedWeights[i] = this.weights[i] + this.alpha * (double)residual * (double)this.getInput(filter, i);
            }
            this.weights = Arrays.copyOf(updatedWeights, 5);
        }
    }

    long estimate(Filter filter) {
        long estimatedEntryCount = 0L;
        for (int i = 0; i < 5; ++i) {
            estimatedEntryCount = (long)((double)estimatedEntryCount + this.weights[i] * (double)this.getInput(filter, i));
        }
        return Math.max(0L, estimatedEntryCount);
    }

    private long getInput(Filter filter, int i) {
        assert (i < 5);
        if (i == 0) {
            return filter.getPropertyRestrictions() != null ? (long)filter.getPropertyRestrictions().size() : 0L;
        }
        if (i == 1) {
            return filter.containsNativeConstraint() ? 1L : 0L;
        }
        if (i == 2) {
            return filter.getPathRestriction() != null ? (long)filter.getPathRestriction().ordinal() : 0L;
        }
        if (i == 3) {
            return filter.getPathRestriction() != null ? (long)filter.getPathRestriction().toString().split("/").length : 0L;
        }
        if (i == 4) {
            return filter.getFullTextConstraint() != null ? (long)filter.getFullTextConstraint().getPrecedence() : 0L;
        }
        return 0L;
    }
}

