/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr;

import java.io.File;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.DefaultSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.EmbeddedSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.EmbeddedSolrServerProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.solr.client.solrj.SolrServer;
import org.junit.Assert;

public class TestUtils
implements SolrServerProvider,
OakSolrConfigurationProvider {
    static final String SOLR_HOME_PATH = "/solr";
    private final SolrServer solrServer = TestUtils.createSolrServer();
    private final OakSolrConfiguration configuration = TestUtils.getTestConfiguration();

    public static SolrServer createSolrServer() {
        EmbeddedSolrServerConfiguration configuration = new EmbeddedSolrServerConfiguration(TestUtils.class.getResource(SOLR_HOME_PATH).getFile(), "oak");
        EmbeddedSolrServerProvider provider = new EmbeddedSolrServerProvider(configuration);
        try {
            return provider.getSolrServer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void cleanDataDir() {
        String path = TestUtils.class.getResource("/solr/oak/data").getFile();
        File file = new File(path);
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
    }

    public static OakSolrConfiguration getTestConfiguration() {
        return new DefaultSolrConfiguration(){

            @Nonnull
            public OakSolrConfiguration.CommitPolicy getCommitPolicy() {
                return OakSolrConfiguration.CommitPolicy.HARD;
            }

            public boolean useForPropertyRestrictions() {
                return true;
            }

            public boolean useForPrimaryTypes() {
                return true;
            }

            public boolean useForPathRestrictions() {
                return true;
            }
        };
    }

    @CheckForNull
    public SolrServer getSolrServer() {
        return this.solrServer;
    }

    @CheckForNull
    public SolrServer getIndexingSolrServer() throws Exception {
        return this.solrServer;
    }

    @CheckForNull
    public SolrServer getSearchingSolrServer() throws Exception {
        return this.solrServer;
    }

    @Nonnull
    public OakSolrConfiguration getConfiguration() {
        return this.configuration;
    }

    public void close() throws IOException {
    }
}

