/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.solr.TestUtils;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.DefaultSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndex;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class SolrQueryIndexTest {
    private NodeState nodeState;

    @Before
    public void setUp() throws Exception {
        NodeState root = EmptyNodeState.EMPTY_NODE;
        NodeBuilder builder = root.builder();
        builder.child("oak:index").child("solr").setProperty("jcr:primaryType", (Object)"oak:QueryIndexDefinition").setProperty("type", (Object)"solr").child("server").setProperty("solrServerType", (Object)"embedded");
        this.nodeState = builder.getNodeState();
    }

    @Test
    public void testNoIndexPlanWithNoRestrictions() throws Exception {
        SelectorImpl selector = (SelectorImpl)Mockito.mock(SelectorImpl.class);
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, null, null);
        FilterImpl filter = new FilterImpl(selector, "", new QueryEngineSettings());
        LinkedList sortOrder = new LinkedList();
        List plans = solrQueryIndex.getPlans((Filter)filter, sortOrder, this.nodeState);
        Assert.assertEquals((long)0L, (long)plans.size());
    }

    @Test
    public void testNoPlanWithPathRestrictions() throws Exception {
        SelectorImpl selector = new SelectorImpl(this.nodeState, "a");
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, null, null);
        FilterImpl filter = new FilterImpl(selector, "select * from [nt:base] as a where isdescendantnode(a, '/test')", new QueryEngineSettings());
        filter.restrictPath("/test", Filter.PathRestriction.ALL_CHILDREN);
        LinkedList sortOrder = new LinkedList();
        List plans = solrQueryIndex.getPlans((Filter)filter, sortOrder, this.nodeState);
        Assert.assertEquals((long)0L, (long)plans.size());
    }

    @Test
    public void testNoPlanWithOnlyPathRestrictionsEnabled() throws Exception {
        NodeBuilder builder = this.nodeState.builder();
        builder.child("oak:index").child("solr").setProperty("pathRestrictions", (Object)true);
        this.nodeState = builder.getNodeState();
        SelectorImpl selector = new SelectorImpl(this.nodeState, "a");
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, null, null);
        FilterImpl filter = new FilterImpl(selector, "select * from [nt:base] as a where isdescendantnode(a, '/test')", new QueryEngineSettings());
        filter.restrictPath("/test", Filter.PathRestriction.ALL_CHILDREN);
        LinkedList sortOrder = new LinkedList();
        List plans = solrQueryIndex.getPlans((Filter)filter, sortOrder, this.nodeState);
        Assert.assertEquals((long)0L, (long)plans.size());
    }

    @Test
    public void testPlanWithPropertyAndPathRestrictionsEnabled() throws Exception {
        NodeBuilder builder = this.nodeState.builder();
        builder.child("oak:index").child("solr").setProperty("pathRestrictions", (Object)true).setProperty("propertyRestrictions", (Object)true);
        this.nodeState = builder.getNodeState();
        SelectorImpl selector = new SelectorImpl(this.nodeState, "a");
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, null, null);
        FilterImpl filter = new FilterImpl(selector, "select * from [nt:base] as a where isdescendantnode(a, '/test')", new QueryEngineSettings());
        filter.restrictPath("/test", Filter.PathRestriction.ALL_CHILDREN);
        filter.restrictProperty("foo", Operator.EQUAL, PropertyValues.newString((String)"bar"));
        LinkedList sortOrder = new LinkedList();
        List plans = solrQueryIndex.getPlans((Filter)filter, sortOrder, this.nodeState);
        Assert.assertEquals((long)1L, (long)plans.size());
    }

    @Test
    public void testNoPlanWithPropertyRestrictions() throws Exception {
        SelectorImpl selector = new SelectorImpl(this.nodeState, "a");
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, null, null);
        FilterImpl filter = new FilterImpl(selector, "select * from [nt:base] as a where name = 'hello')", new QueryEngineSettings());
        filter.restrictProperty("name", Operator.EQUAL, PropertyValues.newString((String)"hello"));
        LinkedList sortOrder = new LinkedList();
        List plans = solrQueryIndex.getPlans((Filter)filter, sortOrder, this.nodeState);
        Assert.assertEquals((long)0L, (long)plans.size());
    }

    @Test
    public void testPlanWithPropertyRestrictionsEnabled() throws Exception {
        NodeBuilder builder = this.nodeState.builder();
        builder.child("oak:index").child("solr").setProperty("propertyRestrictions", (Object)true);
        this.nodeState = builder.getNodeState();
        SelectorImpl selector = new SelectorImpl(this.nodeState, "a");
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, null, null);
        FilterImpl filter = new FilterImpl(selector, "select * from [nt:base] as a where name = 'hello')", new QueryEngineSettings());
        filter.restrictProperty("name", Operator.EQUAL, PropertyValues.newString((String)"hello"));
        LinkedList sortOrder = new LinkedList();
        List plans = solrQueryIndex.getPlans((Filter)filter, sortOrder, this.nodeState);
        Assert.assertEquals((long)1L, (long)plans.size());
    }

    @Test
    public void testNoPlanWithPrimaryTypeRestrictions() throws Exception {
        SelectorImpl selector = new SelectorImpl(this.nodeState, "a");
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, null, null);
        FilterImpl filter = new FilterImpl(selector, "select * from [nt:base] as a where jcr:primaryType = 'nt:unstructured')", new QueryEngineSettings());
        filter.restrictProperty("jcr:primaryType", Operator.EQUAL, PropertyValues.newString((String)"nt:unstructured"));
        LinkedList sortOrder = new LinkedList();
        List plans = solrQueryIndex.getPlans((Filter)filter, sortOrder, this.nodeState);
        Assert.assertEquals((long)0L, (long)plans.size());
    }

    @Test
    public void testNoPlanWithOnlyPrimaryTypeRestrictionsEnabled() throws Exception {
        NodeBuilder builder = this.nodeState.builder();
        builder.child("oak:index").child("solr").setProperty("primaryTypes", (Object)true);
        this.nodeState = builder.getNodeState();
        SelectorImpl selector = new SelectorImpl(this.nodeState, "a");
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, null, null);
        FilterImpl filter = new FilterImpl(selector, "select * from [nt:base] as a where jcr:primaryType = 'nt:unstructured')", new QueryEngineSettings());
        filter.restrictProperty("jcr:primaryType", Operator.EQUAL, PropertyValues.newString((String)"nt:unstructured"));
        LinkedList sortOrder = new LinkedList();
        List plans = solrQueryIndex.getPlans((Filter)filter, sortOrder, this.nodeState);
        Assert.assertEquals((long)0L, (long)plans.size());
    }

    @Test
    public void testPlanWithPropertyAndPrimaryTypeRestrictionsEnabled() throws Exception {
        NodeBuilder builder = this.nodeState.builder();
        builder.child("oak:index").child("solr").setProperty("propertyRestrictions", (Object)true).setProperty("primaryTypes", (Object)true);
        this.nodeState = builder.getNodeState();
        SelectorImpl selector = new SelectorImpl(this.nodeState, "a");
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, null, null);
        FilterImpl filter = new FilterImpl(selector, "select * from [nt:base] as a where jcr:primaryType = 'nt:unstructured')", new QueryEngineSettings());
        filter.restrictProperty("jcr:primaryType", Operator.EQUAL, PropertyValues.newString((String)"nt:unstructured"));
        filter.restrictProperty("name", Operator.EQUAL, PropertyValues.newString((String)"hello"));
        LinkedList sortOrder = new LinkedList();
        List plans = solrQueryIndex.getPlans((Filter)filter, sortOrder, this.nodeState);
        Assert.assertEquals((long)1L, (long)plans.size());
    }

    @Test
    public void testNoPlanWithPropertyRestrictionsEnabledButPropertyIgnored() throws Exception {
        NodeBuilder builder = this.nodeState.builder();
        builder.child("oak:index").child("solr").setProperty("ignoredProperties", Collections.singleton("name"), Type.STRINGS).setProperty("propertyRestrictions", (Object)true);
        this.nodeState = builder.getNodeState();
        SelectorImpl selector = new SelectorImpl(this.nodeState, "a");
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, null, null);
        FilterImpl filter = new FilterImpl(selector, "select * from [nt:base] as a where name = 'hello')", new QueryEngineSettings());
        filter.restrictProperty("name", Operator.EQUAL, PropertyValues.newString((String)"hello"));
        LinkedList sortOrder = new LinkedList();
        List plans = solrQueryIndex.getPlans((Filter)filter, sortOrder, this.nodeState);
        Assert.assertEquals((long)0L, (long)plans.size());
    }

    @Test
    public void testNoPlanWithPropertyRestrictionsEnabledButNotUsedProperty() throws Exception {
        NodeBuilder builder = this.nodeState.builder();
        builder.child("oak:index").child("solr").setProperty("usedProperties", Collections.singleton("foo"), Type.STRINGS).setProperty("propertyRestrictions", (Object)true);
        this.nodeState = builder.getNodeState();
        SelectorImpl selector = new SelectorImpl(this.nodeState, "a");
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, null, null);
        FilterImpl filter = new FilterImpl(selector, "select * from [nt:base] as a where name = 'hello')", new QueryEngineSettings());
        filter.restrictProperty("name", Operator.EQUAL, PropertyValues.newString((String)"hello"));
        LinkedList sortOrder = new LinkedList();
        List plans = solrQueryIndex.getPlans((Filter)filter, sortOrder, this.nodeState);
        Assert.assertEquals((long)0L, (long)plans.size());
    }

    @Test
    public void testPlanWithPropertyRestrictionsEnabledAndUsedProperty() throws Exception {
        NodeBuilder builder = this.nodeState.builder();
        builder.child("oak:index").child("solr").setProperty("usedProperties", Collections.singleton("name"), Type.STRINGS).setProperty("propertyRestrictions", (Object)true);
        this.nodeState = builder.getNodeState();
        SelectorImpl selector = new SelectorImpl(this.nodeState, "a");
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, null, null);
        FilterImpl filter = new FilterImpl(selector, "select * from [nt:base] as a where name = 'hello')", new QueryEngineSettings());
        filter.restrictProperty("name", Operator.EQUAL, PropertyValues.newString((String)"hello"));
        LinkedList sortOrder = new LinkedList();
        List plans = solrQueryIndex.getPlans((Filter)filter, sortOrder, this.nodeState);
        Assert.assertEquals((long)1L, (long)plans.size());
    }

    @Test
    public void testNoPlanWithPropertyNotListedInUsedProperties() throws Exception {
        NodeBuilder builder = this.nodeState.builder();
        builder.child("oak:index").child("solr").setProperty("usedProperties", Collections.singleton("name"), Type.STRINGS).setProperty("propertyRestrictions", (Object)true);
        this.nodeState = builder.getNodeState();
        SelectorImpl selector = new SelectorImpl(this.nodeState, "a");
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, null, null);
        FilterImpl filter = new FilterImpl(selector, "select * from [nt:base] as a where foo = 'bar')", new QueryEngineSettings());
        filter.restrictProperty("foo", Operator.EQUAL, PropertyValues.newString((String)"bar"));
        LinkedList sortOrder = new LinkedList();
        List plans = solrQueryIndex.getPlans((Filter)filter, sortOrder, this.nodeState);
        Assert.assertEquals((long)0L, (long)plans.size());
    }

    @Test
    public void testUnion() throws Exception {
        SelectorImpl selector = (SelectorImpl)Mockito.mock(SelectorImpl.class);
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, null, null);
        String sqlQuery = "select [jcr:path], [jcr:score], [rep:excerpt] from [nt:hierarchyNode] as a where isdescendantnode(a, '/content') and contains([jcr:content/*], 'founded') union select [jcr:path], [jcr:score], [rep:excerpt] from [nt:hierarchyNode] as a where isdescendantnode(a, '/content') and contains([jcr:content/jcr:title], 'founded') union select [jcr:path], [jcr:score], [rep:excerpt] from [nt:hierarchyNode] as a where isdescendantnode(a, '/content') and contains([jcr:content/jcr:description], 'founded') order by [jcr:score] desc";
        FilterImpl filter = new FilterImpl(selector, sqlQuery, new QueryEngineSettings());
        LinkedList sortOrder = new LinkedList();
        List plans = solrQueryIndex.getPlans((Filter)filter, sortOrder, this.nodeState);
        Assert.assertEquals((long)0L, (long)plans.size());
    }

    @Ignore
    @Test
    public void testSize() throws Exception {
        NodeState root = (NodeState)Mockito.mock(NodeState.class);
        Mockito.when((Object)root.getNames((String)Matchers.any(String.class))).thenReturn(Collections.emptySet());
        SelectorImpl selector = new SelectorImpl(root, "a");
        String sqlQuery = "select [jcr:path], [jcr:score] from [nt:base] as a where contains([jcr:content/*], 'founded')";
        SolrServer solrServer = TestUtils.createSolrServer();
        SolrServerProvider solrServerProvider = (SolrServerProvider)Mockito.mock(SolrServerProvider.class);
        OakSolrConfigurationProvider configurationProvider = (OakSolrConfigurationProvider)Mockito.mock(OakSolrConfigurationProvider.class);
        DefaultSolrConfiguration configuration = new DefaultSolrConfiguration(){

            public boolean useForPropertyRestrictions() {
                return true;
            }
        };
        Mockito.when((Object)configurationProvider.getConfiguration()).thenReturn((Object)configuration);
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, configurationProvider, solrServerProvider);
        FilterImpl filter = new FilterImpl(selector, sqlQuery, new QueryEngineSettings());
        Cursor cursor = solrQueryIndex.query((Filter)filter, root);
        Assert.assertNotNull((Object)cursor);
        long sizeExact = cursor.getSize(Result.SizePrecision.EXACT, 100000L);
        long sizeApprox = cursor.getSize(Result.SizePrecision.APPROXIMATION, 100000L);
        long sizeFastApprox = cursor.getSize(Result.SizePrecision.FAST_APPROXIMATION, 100000L);
        Assert.assertTrue((Math.abs(sizeExact - sizeApprox) < 10L ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(sizeExact - sizeFastApprox) > 10000L ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void testNoMoreThanThreeSolrRequests() throws Exception {
        NodeState root = (NodeState)Mockito.mock(NodeState.class);
        Mockito.when((Object)root.getNames((String)Matchers.any(String.class))).thenReturn(Collections.emptySet());
        SelectorImpl selector = new SelectorImpl(root, "a");
        String sqlQuery = "select [jcr:path], [jcr:score] from [nt:base] as a where contains([jcr:content/*], 'founded')";
        SolrServer solrServer = (SolrServer)Mockito.mock(SolrServer.class);
        SolrServerProvider solrServerProvider = (SolrServerProvider)Mockito.mock(SolrServerProvider.class);
        Mockito.when((Object)solrServerProvider.getSearchingSolrServer()).thenReturn((Object)solrServer);
        OakSolrConfigurationProvider configurationProvider = (OakSolrConfigurationProvider)Mockito.mock(OakSolrConfigurationProvider.class);
        DefaultSolrConfiguration configuration = new DefaultSolrConfiguration(){

            public boolean useForPropertyRestrictions() {
                return true;
            }

            public int getRows() {
                return 10;
            }
        };
        Mockito.when((Object)configurationProvider.getConfiguration()).thenReturn((Object)configuration);
        SolrQueryIndex solrQueryIndex = new SolrQueryIndex(null, configurationProvider, solrServerProvider);
        FilterImpl filter = new FilterImpl(selector, sqlQuery, new QueryEngineSettings());
        CountingResponse response = new CountingResponse(0);
        Mockito.when((Object)solrServer.query((SolrParams)Matchers.any(SolrParams.class))).thenReturn((Object)response);
        Cursor cursor = solrQueryIndex.query((Filter)filter, root);
        Assert.assertNotNull((Object)cursor);
        while (cursor.hasNext()) {
            IndexRow row = cursor.next();
            Assert.assertNotNull((Object)row);
        }
        Assert.assertEquals((long)3L, (long)response.getCounter());
    }

    private class CountingResponse
    extends QueryResponse {
        private int counter;

        public CountingResponse(int counter) {
            this.counter = counter;
        }

        public SolrDocumentList getResults() {
            SolrDocumentList results = new SolrDocumentList();
            for (int i = 0; i < 1000; ++i) {
                results.add((Object)new SolrDocument());
            }
            results.setNumFound(1000L);
            ++this.counter;
            return results;
        }

        public int getCounter() {
            return this.counter;
        }
    }
}

