/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.query;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.core.query.AbstractQueryTest;

public class TextExtractionQueryTest
extends AbstractQueryTest {
    public void testFileContains() throws Exception {
        this.assertFileContains("test.txt", "text/plain", "AE502DBEA2C411DEBD340AD156D89593");
        this.assertFileContains("test.rtf", "application/rtf", "quick brown fox");
    }

    public void testNtFile() throws RepositoryException, IOException {
        while (this.testRootNode.hasNode(this.nodeName1)) {
            this.testRootNode.getNode(this.nodeName1).remove();
        }
        String content = "The quick brown fox jumps over the lazy dog.";
        Node file = JcrUtils.putFile((Node)this.testRootNode, (String)this.nodeName1, (String)"text/plain", (InputStream)new ByteArrayInputStream(content.getBytes("UTF-8")));
        this.testRootNode.getSession().save();
        String xpath = this.testPath + "/*[jcr:contains(jcr:content, 'lazy')]";
        this.executeXPathQuery(xpath, new Node[]{file});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertFileContains(String name, String type, String ... statements) throws Exception {
        if (this.testRootNode.hasNode(this.nodeName1)) {
            this.testRootNode.getNode(this.nodeName1).remove();
        }
        this.testRootNode.getSession().save();
        Node resource = this.testRootNode.addNode(this.nodeName1, "{http://www.jcp.org/jcr/nt/1.0}resource");
        resource.setProperty("jcr:mimeType", type);
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        TextExtractionQueryTest.assertNotNull((Object)stream);
        try {
            Binary binary = this.testRootNode.getSession().getValueFactory().createBinary(stream);
            resource.setProperty("jcr:data", binary);
        }
        finally {
            stream.close();
        }
        this.testRootNode.getSession().save();
        for (String statement : statements) {
            this.assertContainsQuery(statement, true);
        }
    }

    private void assertContainsQuery(String statement, boolean match) throws RepositoryException {
        StringBuffer stmt = new StringBuffer();
        stmt.append("/jcr:root").append(this.testRoot).append("/*");
        stmt.append("[jcr:contains(., '").append(statement);
        stmt.append("')]");
        Query q = this.qm.createQuery(stmt.toString(), "xpath");
        this.checkResult(q.execute(), match ? 1 : 0);
        stmt = new StringBuffer();
        stmt.append("SELECT * FROM nt:base ");
        stmt.append("WHERE jcr:path LIKE '").append(this.testRoot).append("/%' ");
        stmt.append("AND CONTAINS(., '").append(statement).append("')");
        q = this.qm.createQuery(stmt.toString(), "sql");
        this.checkResult(q.execute(), match ? 1 : 0);
    }
}

