/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfigurationDefaults;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class OakSolrNodeStateConfiguration
implements OakSolrConfiguration {
    private final NodeState definition;

    public OakSolrNodeStateConfiguration(NodeState definition) {
        this.definition = definition;
        if (!definition.hasProperty("type") || !"solr".equals(definition.getProperty("type").getValue(Type.STRING))) {
            throw new IllegalArgumentException("missing or wrong 'type' property in " + definition);
        }
    }

    @Override
    public String getFieldNameFor(Type<?> propertyType) {
        Iterable<String> typeMappings = this.getStringValuesFor("typeMappings");
        if (typeMappings != null) {
            for (String typeMapping : typeMappings) {
                Type type;
                String[] mapping = typeMapping.split("=");
                if (mapping.length != 2 || mapping[0] == null || mapping[1] == null || (type = Type.fromString((String)mapping[0])) == null || type.tag() != propertyType.tag()) continue;
                return mapping[1];
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public String getPathField() {
        return this.getStringValueFor("pathField", "path_exact");
    }

    @Override
    @CheckForNull
    public String getFieldForPathRestriction(Filter.PathRestriction pathRestriction) {
        String fieldName = null;
        switch (pathRestriction) {
            case ALL_CHILDREN: {
                fieldName = this.getStringValueFor("descendantsField", "path_des");
                break;
            }
            case DIRECT_CHILDREN: {
                fieldName = this.getStringValueFor("childrenField", "path_child");
                break;
            }
            case EXACT: {
                fieldName = this.getStringValueFor("pathField", "path_exact");
                break;
            }
            case PARENT: {
                fieldName = this.getStringValueFor("parentField", "path_anc");
                break;
            }
            case NO_RESTRICTION: {
                break;
            }
        }
        return fieldName;
    }

    @Override
    public String getCatchAllField() {
        return this.getStringValueFor("catchAllField", "catch_all");
    }

    @Override
    public String getFieldForPropertyRestriction(Filter.PropertyRestriction propertyRestriction) {
        Iterable<String> propertyMappings = this.getStringValuesFor("propertyMappings");
        if (propertyMappings != null) {
            for (String propertyMapping : propertyMappings) {
                String[] mapping = propertyMapping.split("=");
                if (mapping.length != 2 || mapping[0] == null || mapping[1] == null || !propertyRestriction.propertyName.equals(mapping[0])) continue;
                return mapping[1];
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public OakSolrConfiguration.CommitPolicy getCommitPolicy() {
        return OakSolrConfiguration.CommitPolicy.valueOf(this.getStringValueFor("commitPolicy", OakSolrConfiguration.CommitPolicy.SOFT.toString()));
    }

    @Override
    public int getRows() {
        return this.getIntValueFor("rows", Integer.MAX_VALUE);
    }

    @Override
    public boolean useForPropertyRestrictions() {
        return this.getBooleanValueFor("propertyRestrictions", false);
    }

    @Override
    public boolean useForPrimaryTypes() {
        return this.getBooleanValueFor("primaryTypes", false);
    }

    @Override
    public boolean useForPathRestrictions() {
        return this.getBooleanValueFor("pathRestrictions", false);
    }

    @Override
    @Nonnull
    public Collection<String> getIgnoredProperties() {
        Collection<String> ignoredProperties;
        Iterable<String> ignoredPropertiesValues = this.getStringValuesFor("ignoredProperties");
        if (ignoredPropertiesValues != null) {
            ignoredProperties = new LinkedList<String>();
            for (String ignoredProperty : ignoredPropertiesValues) {
                ignoredProperties.add(ignoredProperty);
            }
        } else {
            ignoredProperties = SolrServerConfigurationDefaults.IGNORED_PROPERTIES;
        }
        return ignoredProperties;
    }

    @Override
    @Nonnull
    public Collection<String> getUsedProperties() {
        List<String> usedProperties;
        Iterable<String> usedPropertiesValues = this.getStringValuesFor("usedProperties");
        if (usedPropertiesValues != null) {
            usedProperties = new LinkedList();
            for (String usedProperty : usedPropertiesValues) {
                usedProperties.add(usedProperty);
            }
        } else {
            usedProperties = Collections.emptyList();
        }
        return usedProperties;
    }

    private boolean getBooleanValueFor(String propertyName, boolean defaultValue) {
        boolean value = defaultValue;
        PropertyState property = this.definition.getProperty(propertyName);
        if (property != null) {
            value = (Boolean)property.getValue(Type.BOOLEAN);
        }
        return value;
    }

    private int getIntValueFor(String propertyName, int defaultValue) {
        long value = defaultValue;
        PropertyState property = this.definition.getProperty(propertyName);
        if (property != null) {
            value = (Long)property.getValue(Type.LONG);
        }
        return (int)value;
    }

    private String getStringValueFor(String propertyName, String defaultValue) {
        String value = defaultValue;
        PropertyState property = this.definition.getProperty(propertyName);
        if (property != null) {
            value = (String)property.getValue(Type.STRING);
        }
        return value;
    }

    private Iterable<String> getStringValuesFor(String propertyName) {
        Iterable values = null;
        PropertyState property = this.definition.getProperty(propertyName);
        if (property != null && property.isArray()) {
            values = (Iterable)property.getValue(Type.STRINGS);
        }
        return values;
    }

    public String toString() {
        return "OakSolrNodeStateConfiguration{definitionChildren=" + Iterables.toString((Iterable)this.definition.getChildNodeNames()) + '}';
    }

    public final class Properties {
        public static final String PATH_FIELD = "pathField";
        public static final String PARENT_FIELD = "parentField";
        public static final String CHILDREN_FIELD = "childrenField";
        public static final String DESCENDANTS_FIELD = "descendantsField";
        public static final String CATCHALL_FIELD = "catchAllField";
        public static final String COMMIT_POLICY = "commitPolicy";
        public static final String ROWS = "rows";
        public static final String PROPERTY_RESTRICIONS = "propertyRestrictions";
        public static final String PRIMARY_TYPES = "primaryTypes";
        public static final String PATH_RESTRICTIONS = "pathRestrictions";
        public static final String IGNORED_PROPERTIES = "ignoredProperties";
        public static final String TYPE_MAPPINGS = "typeMappings";
        public static final String PROPERTY_MAPPINGS = "propertyMappings";
        public static final String USED_PROPERTIES = "usedProperties";
    }
}

