/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.jackrabbit.oak.InitialContentHelper;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrIndexLookup;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class SolrIndexLookupTest {
    private NodeState root = InitialContentHelper.INITIAL_CONTENT;
    private NodeBuilder builder = this.root.builder();

    @Test
    public void collectPathOnRootNode() throws Exception {
        NodeBuilder index = this.builder.child("oak:index");
        SolrIndexLookupTest.newSolrIndexDefinition(index, "l1", (Set<String>)ImmutableSet.of((Object)"foo"));
        SolrIndexLookupTest.newSolrIndexDefinition(index, "l2", (Set<String>)ImmutableSet.of((Object)"foo"));
        SolrIndexLookup lookup = new SolrIndexLookup(this.builder.getNodeState());
        FilterImpl f = FilterImpl.newTestInstance();
        f.restrictPath("/", Filter.PathRestriction.EXACT);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"/oak:index/l1", (Object)"/oak:index/l2"), (Object)lookup.collectIndexNodePaths((Filter)f));
    }

    @Test
    public void collectPathOnSubNode() throws Exception {
        NodeBuilder index = this.builder.child("oak:index");
        SolrIndexLookupTest.newSolrIndexDefinition(index, "l1", (Set<String>)ImmutableSet.of((Object)"foo"));
        index = this.builder.child("a").child("oak:index");
        SolrIndexLookupTest.newSolrIndexDefinition(index, "l2", (Set<String>)ImmutableSet.of((Object)"foo"));
        index = this.builder.child("a").child("b").child("oak:index");
        SolrIndexLookupTest.newSolrIndexDefinition(index, "l3", (Set<String>)ImmutableSet.of((Object)"foo"));
        SolrIndexLookup lookup = new SolrIndexLookup(this.builder.getNodeState());
        FilterImpl f = FilterImpl.newTestInstance();
        f.restrictPath("/a", Filter.PathRestriction.EXACT);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"/oak:index/l1", (Object)"/a/oak:index/l2"), (Object)lookup.collectIndexNodePaths((Filter)f));
        f.restrictPath("/a/b", Filter.PathRestriction.EXACT);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"/oak:index/l1", (Object)"/a/oak:index/l2", (Object)"/a/b/oak:index/l3"), (Object)lookup.collectIndexNodePaths((Filter)f));
    }

    private static NodeBuilder newSolrIndexDefinition(@NotNull NodeBuilder index, @NotNull String name, @Nullable Set<String> properties) {
        if (index.hasChildNode(name)) {
            return index.child(name);
        }
        index = index.child(name);
        index.setProperty("jcr:primaryType", (Object)"oak:QueryIndexDefinition", Type.NAME).setProperty("type", (Object)"solr").setProperty("async", (Object)"async").setProperty("reindex", (Object)true);
        index.child("server").setProperty("solrServerType", (Object)"embedded");
        if (properties != null && !properties.isEmpty()) {
            index.setProperty(PropertyStates.createProperty((String)"usedProperties", properties, (Type)Type.STRINGS));
        }
        return index;
    }
}

