/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.plugins.index.aggregate.AggregateIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="Apache Jackrabbit Oak Solr Query index provider configuration")
public class SolrQueryIndexProviderService {
    private static final boolean QUERY_TIME_AGGREGATION_DEFAULT = false;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<ServiceRegistration> regs = Lists.newArrayList();
    @Reference(target="(|(server.type=embedded)(server.type=remote))")
    private SolrServerProvider solrServerProvider;
    @Reference
    private OakSolrConfigurationProvider oakSolrConfigurationProvider;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC)
    private NodeAggregator nodeAggregator;
    @Property(boolValue={false}, label="query time aggregation", description="enable query time aggregation for Solr index")
    private static final String QUERY_TIME_AGGREGATION = "query.aggregation";

    @Activate
    protected void activate(ComponentContext componentContext) {
        Object value = componentContext.getProperties().get(QUERY_TIME_AGGREGATION);
        boolean queryTimeAggregation = PropertiesUtil.toBoolean(value, (boolean)false);
        if (this.solrServerProvider != null && this.oakSolrConfigurationProvider != null) {
            SolrQueryIndexProvider solrQueryIndexProvider = new SolrQueryIndexProvider(this.solrServerProvider, this.oakSolrConfigurationProvider, this.nodeAggregator);
            this.log.debug("creating Solr query index provider {} query time aggregation", (Object)(queryTimeAggregation ? "with" : "without"));
            if (queryTimeAggregation) {
                solrQueryIndexProvider = AggregateIndexProvider.wrap((QueryIndexProvider)solrQueryIndexProvider);
            }
            this.regs.add(componentContext.getBundleContext().registerService(QueryIndexProvider.class.getName(), (Object)solrQueryIndexProvider, null));
        }
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration registration : this.regs) {
            registration.unregister();
        }
    }

    protected void bindSolrServerProvider(SolrServerProvider solrServerProvider) {
        this.solrServerProvider = solrServerProvider;
    }

    protected void unbindSolrServerProvider(SolrServerProvider solrServerProvider) {
        if (this.solrServerProvider == solrServerProvider) {
            this.solrServerProvider = null;
        }
    }

    protected void bindOakSolrConfigurationProvider(OakSolrConfigurationProvider oakSolrConfigurationProvider) {
        this.oakSolrConfigurationProvider = oakSolrConfigurationProvider;
    }

    protected void unbindOakSolrConfigurationProvider(OakSolrConfigurationProvider oakSolrConfigurationProvider) {
        if (this.oakSolrConfigurationProvider == oakSolrConfigurationProvider) {
            this.oakSolrConfigurationProvider = null;
        }
    }

    protected void bindNodeAggregator(NodeAggregator nodeAggregator) {
        this.nodeAggregator = nodeAggregator;
    }

    protected void unbindNodeAggregator(NodeAggregator nodeAggregator) {
        if (this.nodeAggregator == nodeAggregator) {
            this.nodeAggregator = null;
        }
    }
}

