/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.query.FilterQueryParser;
import org.apache.jackrabbit.oak.plugins.index.solr.query.LMSEstimator;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrQueryIndex
implements QueryIndex.FulltextQueryIndex,
QueryIndex.AdvanceFulltextQueryIndex {
    public static final String TYPE = "solr";
    static final String NATIVE_SOLR_QUERY = "native*solr";
    static final String NATIVE_LUCENE_QUERY = "native*lucene";
    private final Logger log = LoggerFactory.getLogger(SolrQueryIndex.class);
    private final String name;
    private final SolrServer solrServer;
    private final OakSolrConfiguration configuration;
    private final NodeAggregator aggregator;
    private final LMSEstimator estimator;

    public SolrQueryIndex(String name, SolrServer solrServer, OakSolrConfiguration configuration, NodeAggregator aggregator, LMSEstimator estimator) {
        this.name = name;
        this.solrServer = solrServer;
        this.configuration = configuration;
        this.aggregator = aggregator;
        this.estimator = estimator;
    }

    public SolrQueryIndex(String name, SolrServer solrServer, OakSolrConfiguration configuration, NodeAggregator aggregator) {
        this(name, solrServer, configuration, aggregator, new LMSEstimator());
    }

    public SolrQueryIndex(String name, SolrServer solrServer, OakSolrConfiguration configuration) {
        this(name, solrServer, configuration, null, new LMSEstimator());
    }

    public String getIndexName() {
        return this.name;
    }

    public double getCost(Filter filter, NodeState root) {
        double cost = 10.0 / (double)this.getMatchingFilterRestrictions(filter);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Solr: cost for {}\u00a0is {}", (Object)this.name, (Object)cost);
        }
        return cost;
    }

    int getMatchingFilterRestrictions(Filter filter) {
        int match = 0;
        if (filter.getFullTextConstraint() != null || filter.getFulltextConditions() != null && filter.getFulltextConditions().size() > 0) {
            ++match;
        }
        if (filter.getPathRestriction() != null && !Filter.PathRestriction.NO_RESTRICTION.equals((Object)filter.getPathRestriction()) && this.configuration.useForPathRestrictions()) {
            ++match;
        }
        if (filter.getPrimaryTypes().size() > 0 && this.configuration.useForPrimaryTypes()) {
            ++match;
        }
        if (filter.getPropertyRestrictions() != null && filter.getPropertyRestrictions().size() > 0 && (filter.getPropertyRestriction(NATIVE_SOLR_QUERY) != null || filter.getPropertyRestriction(NATIVE_LUCENE_QUERY) != null || this.configuration.useForPropertyRestrictions()) && !SolrQueryIndex.hasIgnoredProperties(filter.getPropertyRestrictions(), this.configuration)) {
            ++match;
        }
        return match;
    }

    private static boolean hasIgnoredProperties(Collection<Filter.PropertyRestriction> propertyRestrictions, OakSolrConfiguration configuration) {
        for (Filter.PropertyRestriction pr : propertyRestrictions) {
            if (!SolrQueryIndex.isIgnoredProperty(pr.propertyName, configuration)) continue;
            return true;
        }
        return false;
    }

    public String getPlan(Filter filter, NodeState nodeState) {
        return FilterQueryParser.getQuery(filter, null, this.configuration).toString();
    }

    private static Set<String> getRelativePaths(FullTextExpression ft) {
        final HashSet<String> relPaths = new HashSet<String>();
        ft.accept((FullTextVisitor)new FullTextVisitor.FullTextVisitorBase(){

            public boolean visit(FullTextTerm term) {
                String p = term.getPropertyName();
                if (p == null) {
                    relPaths.add("");
                } else {
                    if (p.startsWith("../") || p.startsWith("./")) {
                        throw new IllegalArgumentException("Relative parent is not supported:" + p);
                    }
                    if (PathUtils.getDepth((String)p) > 1) {
                        String parent = PathUtils.getParentPath((String)p);
                        relPaths.add(parent);
                    } else {
                        relPaths.add("");
                    }
                }
                return true;
            }
        });
        return relPaths;
    }

    public Cursor query(QueryIndex.IndexPlan plan, NodeState root) {
        return this.query(plan, plan.getSortOrder(), root);
    }

    private Cursor query(QueryIndex.IndexPlan plan, List<QueryIndex.OrderEntry> sortOrder, NodeState root) {
        SolrRowCursor cursor;
        try {
            Filter filter = plan.getFilter();
            Set relPaths = filter.getFullTextConstraint() != null ? SolrQueryIndex.getRelativePaths(filter.getFullTextConstraint()) : Collections.emptySet();
            String parent = relPaths.size() == 0 ? "" : (String)relPaths.iterator().next();
            int parentDepth = PathUtils.getDepth((String)parent);
            AbstractIterator<SolrResultRow> iterator = this.getIterator(filter, sortOrder, parent, parentDepth);
            cursor = new SolrRowCursor((Iterator<SolrResultRow>)iterator, plan, filter.getQueryEngineSettings());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cursor;
    }

    private AbstractIterator<SolrResultRow> getIterator(final Filter filter, final List<QueryIndex.OrderEntry> sortOrder, final String parent, final int parentDepth) {
        return new AbstractIterator<SolrResultRow>(){
            private final Set<String> seenPaths = Sets.newHashSet();
            private final Deque<SolrResultRow> queue = Queues.newArrayDeque();
            private int offset = 0;
            private boolean noDocs = false;
            private long numFound = 0L;

            protected SolrResultRow computeNext() {
                if (!this.queue.isEmpty() || this.loadDocs()) {
                    return this.queue.remove();
                }
                return (SolrResultRow)this.endOfData();
            }

            private SolrResultRow convertToRow(SolrDocument doc) {
                String path = String.valueOf(doc.getFieldValue(SolrQueryIndex.this.configuration.getPathField()));
                if (path != null) {
                    if ("".equals(path)) {
                        path = "/";
                    }
                    if (!parent.isEmpty()) {
                        if (this.seenPaths.contains(path = PathUtils.getAncestorPath((String)path, (int)parentDepth))) {
                            return null;
                        }
                        this.seenPaths.add(path);
                    }
                    float score = 0.0f;
                    Object scoreObj = doc.get((Object)"score");
                    if (scoreObj != null) {
                        score = ((Float)scoreObj).floatValue();
                    }
                    return new SolrResultRow(path, score, doc);
                }
                return null;
            }

            private boolean loadDocs() {
                block12: {
                    if (this.noDocs) {
                        return false;
                    }
                    try {
                        Set suggestEntries;
                        NamedList response;
                        Map suggest;
                        SpellCheckResponse spellCheckResponse;
                        SolrDocumentList docs;
                        if (SolrQueryIndex.this.log.isDebugEnabled()) {
                            SolrQueryIndex.this.log.debug("converting filter {}", (Object)filter);
                        }
                        SolrQuery query = FilterQueryParser.getQuery(filter, sortOrder, SolrQueryIndex.this.configuration);
                        if (this.numFound > 0L) {
                            ++this.offset;
                            int newOffset = this.offset * SolrQueryIndex.this.configuration.getRows();
                            if ((long)newOffset >= this.numFound) {
                                return false;
                            }
                            query.setParam("start", new String[]{String.valueOf(newOffset)});
                        }
                        if (SolrQueryIndex.this.log.isDebugEnabled()) {
                            SolrQueryIndex.this.log.debug("sending query {}", (Object)query);
                        }
                        QueryResponse queryResponse = SolrQueryIndex.this.solrServer.query((SolrParams)query);
                        if (SolrQueryIndex.this.log.isDebugEnabled()) {
                            SolrQueryIndex.this.log.debug("getting response {}", (Object)queryResponse.getHeader());
                        }
                        if ((docs = queryResponse.getResults()) != null) {
                            this.numFound = docs.getNumFound();
                            SolrQueryIndex.this.onRetrievedDocs(filter, docs);
                            for (SolrDocument doc : docs) {
                                SolrResultRow row = this.convertToRow(doc);
                                if (row == null) continue;
                                this.queue.add(row);
                            }
                        }
                        if ((spellCheckResponse = queryResponse.getSpellCheckResponse()) != null && spellCheckResponse.getSuggestions() != null && spellCheckResponse.getSuggestions().size() > 0) {
                            SolrDocument fakeDoc = SolrQueryIndex.this.getSpellChecks(spellCheckResponse, filter);
                            this.queue.add(new SolrResultRow("/", 1.0, fakeDoc));
                            this.noDocs = true;
                        }
                        if ((suggest = (Map)(response = queryResponse.getResponse()).get("suggest")) != null && !(suggestEntries = suggest.entrySet()).isEmpty()) {
                            SolrDocument fakeDoc = SolrQueryIndex.this.getSuggestions(suggestEntries, filter);
                            this.queue.add(new SolrResultRow("/", 1.0, fakeDoc));
                            this.noDocs = true;
                        }
                    }
                    catch (Exception e) {
                        if (!SolrQueryIndex.this.log.isWarnEnabled()) break block12;
                        SolrQueryIndex.this.log.warn("query via {} failed.", (Object)SolrQueryIndex.this.solrServer, (Object)e);
                    }
                }
                return !this.queue.isEmpty();
            }
        };
    }

    private SolrDocument getSpellChecks(SpellCheckResponse spellCheckResponse, Filter filter) throws SolrServerException {
        SolrDocument fakeDoc = new SolrDocument();
        List suggestions = spellCheckResponse.getSuggestions();
        ArrayList alternatives = new ArrayList(suggestions.size());
        for (SpellCheckResponse.Suggestion suggestion : suggestions) {
            alternatives.addAll(suggestion.getAlternatives());
        }
        block1: for (String alternative : alternatives) {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setParam("q", new String[]{alternative});
            solrQuery.setParam("df", new String[]{this.configuration.getCatchAllField()});
            solrQuery.setParam("q.op", new String[]{"AND"});
            solrQuery.setParam("rows", new String[]{"100"});
            QueryResponse suggestQueryResponse = this.solrServer.query((SolrParams)solrQuery);
            SolrDocumentList results = suggestQueryResponse.getResults();
            if (results == null || results.getNumFound() <= 0L) continue;
            for (SolrDocument doc : results) {
                if (!filter.isAccessible(String.valueOf(doc.getFieldValue(this.configuration.getPathField())))) continue;
                fakeDoc.addField("rep:spellcheck()", (Object)alternative);
                continue block1;
            }
        }
        return fakeDoc;
    }

    private SolrDocument getSuggestions(Set<Map.Entry<String, Object>> suggestEntries, Filter filter) throws SolrServerException {
        HashSet<SimpleOrderedMap> retrievedSuggestions = new HashSet<SimpleOrderedMap>();
        SolrDocument fakeDoc = new SolrDocument();
        for (Map.Entry<String, Object> suggester : suggestEntries) {
            SimpleOrderedMap suggestionResponses = (SimpleOrderedMap)suggester.getValue();
            for (Map.Entry suggestionResponse : suggestionResponses) {
                SimpleOrderedMap suggestionResults = (SimpleOrderedMap)suggestionResponse.getValue();
                for (Map.Entry suggestionResult : suggestionResults) {
                    ArrayList suggestions;
                    if (!"suggestions".equals(suggestionResult.getKey()) || (suggestions = (ArrayList)suggestionResult.getValue()).isEmpty()) continue;
                    for (SimpleOrderedMap suggestion : suggestions) {
                        retrievedSuggestions.add(suggestion);
                    }
                }
            }
        }
        block4: for (SimpleOrderedMap suggestion : retrievedSuggestions) {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setParam("q", new String[]{String.valueOf(suggestion.get("term"))});
            solrQuery.setParam("df", new String[]{this.configuration.getCatchAllField()});
            solrQuery.setParam("q.op", new String[]{"AND"});
            solrQuery.setParam("rows", new String[]{"100"});
            QueryResponse suggestQueryResponse = this.solrServer.query((SolrParams)solrQuery);
            SolrDocumentList results = suggestQueryResponse.getResults();
            if (results == null || results.getNumFound() <= 0L) continue;
            for (SolrDocument doc : results) {
                if (!filter.isAccessible(String.valueOf(doc.getFieldValue(this.configuration.getPathField())))) continue;
                fakeDoc.addField("rep:suggest()", (Object)("{term=" + suggestion.get("term") + ",weight=" + suggestion.get("weight") + "}"));
                continue block4;
            }
        }
        return fakeDoc;
    }

    static boolean isIgnoredProperty(String propertyName, OakSolrConfiguration configuration) {
        return !NATIVE_LUCENE_QUERY.equals(propertyName) && !NATIVE_SOLR_QUERY.equals(propertyName) && (!configuration.useForPropertyRestrictions() || configuration.getUsedProperties().size() > 0 && !configuration.getUsedProperties().contains(propertyName) || propertyName.contains("/") || "rep:excerpt".equals(propertyName) || configuration.getIgnoredProperties().contains(propertyName));
    }

    public List<QueryIndex.IndexPlan> getPlans(Filter filter, List<QueryIndex.OrderEntry> sortOrder, NodeState rootState) {
        if (this.getMatchingFilterRestrictions(filter) > 0) {
            return Collections.singletonList(this.planBuilder(filter).setEstimatedEntryCount(this.estimator.estimate(filter)).setSortOrder(sortOrder).build());
        }
        return Collections.emptyList();
    }

    private QueryIndex.IndexPlan.Builder planBuilder(Filter filter) {
        return new QueryIndex.IndexPlan.Builder().setCostPerExecution(this.solrServer instanceof EmbeddedSolrServer ? 1.0 : 2.0).setCostPerEntry(0.3).setFilter(filter).setFulltextIndex(true).setIncludesNodeData(true).setDelayed(true);
    }

    void onRetrievedDocs(Filter filter, SolrDocumentList docs) {
        this.estimator.update(filter, docs);
    }

    public String getPlanDescription(QueryIndex.IndexPlan plan, NodeState root) {
        return plan.toString();
    }

    public Cursor query(Filter filter, NodeState rootState) {
        return this.query(this.planBuilder(filter).build(), null, rootState);
    }

    @CheckForNull
    public NodeAggregator getNodeAggregator() {
        return this.aggregator;
    }

    private class SolrRowCursor
    implements Cursor {
        private final Cursor pathCursor;
        private final QueryIndex.IndexPlan plan;
        SolrResultRow currentRow;

        SolrRowCursor(final Iterator<SolrResultRow> it, QueryIndex.IndexPlan plan, QueryEngineSettings settings) {
            Iterator<String> pathIterator = new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    SolrRowCursor.this.currentRow = (SolrResultRow)it.next();
                    return SolrRowCursor.this.currentRow.path;
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
            this.plan = plan;
            this.pathCursor = new Cursors.PathCursor((Iterator)pathIterator, true, settings);
        }

        public boolean hasNext() {
            return this.pathCursor.hasNext();
        }

        public void remove() {
            this.pathCursor.remove();
        }

        public IndexRow next() {
            final IndexRow pathRow = this.pathCursor.next();
            return new IndexRow(){

                public String getPath() {
                    return pathRow.getPath();
                }

                public PropertyValue getValue(String columnName) {
                    if ("jcr:score".equals(columnName)) {
                        return PropertyValues.newDouble((Double)SolrRowCursor.this.currentRow.score);
                    }
                    List fieldValues = SolrRowCursor.this.currentRow.doc.getFieldValues(columnName);
                    return SolrRowCursor.this.currentRow.doc != null ? PropertyValues.newString((String)Iterables.toString(fieldValues != null ? fieldValues : Collections.emptyList())) : null;
                }
            };
        }

        public long getSize(Result.SizePrecision precision, long max) {
            long estimate = -1L;
            switch (precision) {
                case EXACT: {
                    SolrQuery countQuery = FilterQueryParser.getQuery(this.plan.getFilter(), null, SolrQueryIndex.this.configuration);
                    countQuery.setRows(Integer.valueOf(0));
                    try {
                        estimate = SolrQueryIndex.this.solrServer.query((SolrParams)countQuery).getResults().getNumFound();
                    }
                    catch (SolrServerException e) {
                        SolrQueryIndex.this.log.warn("could not perform count query {}", (Object)countQuery);
                    }
                    break;
                }
                case APPROXIMATION: {
                    estimate = SolrQueryIndex.this.estimator.estimate(this.plan.getFilter());
                    break;
                }
                case FAST_APPROXIMATION: {
                    estimate = this.plan.getEstimatedEntryCount();
                }
            }
            return Math.min(estimate, max);
        }
    }

    static class SolrResultRow {
        final String path;
        final double score;
        final SolrDocument doc;

        SolrResultRow(String path, double score) {
            this(path, score, null);
        }

        SolrResultRow(String path, double score, SolrDocument doc) {
            this.path = path;
            this.score = score;
            this.doc = doc;
        }

        public String toString() {
            return String.format("%s (%1.2f)", this.path, this.score);
        }
    }
}

