/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate.NodeStateSolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate.OakSolrNodeStateConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.query.LMSEstimator;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndex;
import org.apache.jackrabbit.oak.plugins.index.solr.server.OakSolrServer;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrQueryIndexProvider
implements QueryIndexProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SolrServerProvider solrServerProvider;
    private final OakSolrConfigurationProvider oakSolrConfigurationProvider;
    private final NodeAggregator aggregator;
    private final Map<NodeState, LMSEstimator> estimators = new WeakHashMap<NodeState, LMSEstimator>();

    public SolrQueryIndexProvider(@Nonnull SolrServerProvider solrServerProvider, @Nonnull OakSolrConfigurationProvider oakSolrConfigurationProvider, @Nullable NodeAggregator nodeAggregator) {
        this.oakSolrConfigurationProvider = oakSolrConfigurationProvider;
        this.solrServerProvider = solrServerProvider;
        this.aggregator = nodeAggregator;
    }

    public SolrQueryIndexProvider(@Nonnull SolrServerProvider solrServerProvider, @Nonnull OakSolrConfigurationProvider oakSolrConfigurationProvider) {
        this(solrServerProvider, oakSolrConfigurationProvider, null);
    }

    @Nonnull
    public List<? extends QueryIndex> getQueryIndexes(NodeState nodeState) {
        ArrayList<QueryIndex> tempIndexes = new ArrayList<QueryIndex>();
        NodeState definitions = nodeState.getChildNode("oak:index");
        for (ChildNodeEntry entry : definitions.getChildNodeEntries()) {
            NodeState definition = entry.getNodeState();
            String name = entry.getName();
            PropertyState type = definition.getProperty("type");
            if (type == null || !"solr".equals(type.getValue(Type.STRING))) continue;
            try {
                OakSolrConfiguration configuration;
                if (this.isPersistedConfiguration(definition)) {
                    configuration = new OakSolrNodeStateConfiguration(definition);
                    NodeStateSolrServerConfigurationProvider solrServerConfigurationProvider = new NodeStateSolrServerConfigurationProvider(definition.getChildNode("server"));
                    OakSolrServer solrServer = new OakSolrServer(solrServerConfigurationProvider);
                    this.addQueryIndex(tempIndexes, name, solrServer, configuration, definition);
                    continue;
                }
                configuration = this.oakSolrConfigurationProvider.getConfiguration();
                this.addQueryIndex(tempIndexes, name, this.solrServerProvider.getSearchingSolrServer(), configuration, definition);
            }
            catch (Exception e) {
                this.log.warn("could not get Solr query index from node {}", (Object)name, (Object)e);
            }
        }
        return tempIndexes;
    }

    private boolean isPersistedConfiguration(NodeState definition) {
        return definition.hasChildNode("server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addQueryIndex(List<QueryIndex> tempIndexes, String name, SolrServer solrServer, OakSolrConfiguration configuration, NodeState definition) {
        block8: {
            try {
                if (solrServer != null) {
                    LMSEstimator estimator;
                    Map<NodeState, LMSEstimator> map = this.estimators;
                    synchronized (map) {
                        estimator = this.estimators.get(definition);
                        if (estimator == null) {
                            estimator = new LMSEstimator();
                            this.estimators.put(definition, estimator);
                        }
                    }
                    tempIndexes.add((QueryIndex)new SolrQueryIndex(name, solrServer, configuration, this.aggregator, estimator));
                    break block8;
                }
                if (this.log.isWarnEnabled()) {
                    this.log.warn("cannot create Solr query index as SolrServer is null");
                }
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block8;
                this.log.error("unable to create Solr query index at " + name, (Throwable)e);
            }
        }
    }
}

