/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.solr.TestUtils;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.DefaultSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.index.SolrIndexEditor;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SolrIndexEditorTest {
    @Test
    public void testIndexedProperties() throws Exception {
        SolrClient solrServer = TestUtils.createSolrServer();
        OakSolrConfiguration configuration = TestUtils.getTestConfiguration();
        IndexUpdateCallback callback = (IndexUpdateCallback)Mockito.mock(IndexUpdateCallback.class);
        SolrIndexEditor solrIndexEditor = new SolrIndexEditor(solrServer, configuration, callback);
        NodeState before = (NodeState)Mockito.mock(NodeState.class);
        NodeState after = (NodeState)Mockito.mock(NodeState.class);
        Iterable properties = () -> Collections.singletonList(PropertyStates.createProperty((String)"foo1", (Object)"bar")).iterator();
        Mockito.when((Object)after.getProperties()).thenReturn(properties);
        solrIndexEditor.leave(before, after);
        QueryResponse queryResponse = solrServer.query((SolrParams)new SolrQuery("foo1:*"));
        Assert.assertEquals((long)1L, (long)queryResponse.getResults().getNumFound());
    }

    @Test
    public void testIgnoredPropertiesNotIndexed() throws Exception {
        NodeBuilder builder = (NodeBuilder)Mockito.mock(NodeBuilder.class);
        SolrClient solrServer = TestUtils.createSolrServer();
        DefaultSolrConfiguration configuration = new DefaultSolrConfiguration(){

            @NotNull
            public Collection<String> getIgnoredProperties() {
                return Collections.singletonList("foo2");
            }

            @NotNull
            public OakSolrConfiguration.CommitPolicy getCommitPolicy() {
                return OakSolrConfiguration.CommitPolicy.HARD;
            }
        };
        IndexUpdateCallback callback = (IndexUpdateCallback)Mockito.mock(IndexUpdateCallback.class);
        SolrIndexEditor solrIndexEditor = new SolrIndexEditor(solrServer, (OakSolrConfiguration)configuration, callback);
        NodeState before = (NodeState)Mockito.mock(NodeState.class);
        NodeState after = (NodeState)Mockito.mock(NodeState.class);
        Iterable<PropertyState> properties = new Iterable<PropertyState>(){

            @Override
            public Iterator<PropertyState> iterator() {
                return Collections.singletonList(PropertyStates.createProperty((String)"foo2", (Object)"bar")).iterator();
            }
        };
        Mockito.when((Object)after.getProperties()).thenReturn((Object)properties);
        solrIndexEditor.leave(before, after);
        QueryResponse queryResponse = solrServer.query((SolrParams)new SolrQuery("foo2:*"));
        Assert.assertEquals((long)0L, (long)queryResponse.getResults().getNumFound());
    }
}

