/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.query;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.core.query.AbstractQueryTest;

public class QueryFulltextTest
extends AbstractQueryTest {
    public void testScore() throws Exception {
        Session session = this.superuser;
        QueryManager qm = session.getWorkspace().getQueryManager();
        Node n1 = this.testRootNode.addNode("node1");
        n1.setProperty("text", "hello hello hello");
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty("text", "hello");
        session.save();
        String xpath = "/jcr:root//*[jcr:contains(@text, 'hello')] order by jcr:score()";
        Query q = qm.createQuery(xpath, "xpath");
        String result = QueryFulltextTest.getResult(q.execute(), "jcr:score");
        result = result.replaceAll("[0-9\\.]+", "n");
        QueryFulltextTest.assertEquals((String)"n, n", (String)result);
    }

    public void testNativeMatchAll() throws Exception {
        Session session = this.superuser;
        QueryManager qm = session.getWorkspace().getQueryManager();
        String sql2 = "select [jcr:path] as [path] from [nt:base] where native('solr', '*:*')";
        Query q = qm.createQuery(sql2, "JCR-SQL2");
        QueryResult result = q.execute();
        NodeIterator nodes = result.getNodes();
        while (nodes.hasNext()) {
            Node node = nodes.nextNode();
            QueryFulltextTest.assertNotNull((Object)node);
        }
    }

    public void testFulltext() throws Exception {
        Session session = this.superuser;
        QueryManager qm = session.getWorkspace().getQueryManager();
        Node n1 = this.testRootNode.addNode("node1");
        n1.setProperty("text", "hello");
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty("text", "hallo");
        Node n3 = this.testRootNode.addNode("node3");
        n3.setProperty("text", "hello hallo");
        session.save();
        String sql2 = "select [jcr:path] as [path] from [nt:base] where contains([text], 'hello or hallo') order by [jcr:path]";
        Query q = qm.createQuery(sql2, "JCR-SQL2");
        QueryFulltextTest.assertEquals((String)"", (String)QueryFulltextTest.getResult(q.execute(), "path"));
    }

    public void testFulltextRelativeProperty() throws Exception {
        Session session = this.superuser;
        QueryManager qm = session.getWorkspace().getQueryManager();
        Node n1 = this.testRootNode.addNode("node1");
        n1.setProperty("text", "hello");
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty("text", "hallo");
        Node n3 = this.testRootNode.addNode("node3");
        n3.setProperty("text", "hello hallo");
        session.save();
        String sql2 = "select [jcr:path] as [path] from [nt:base] where ISCHILDNODE([/testroot]) AND CONTAINS(text, 'hallo')";
        Query q = qm.createQuery(sql2, "JCR-SQL2");
        QueryFulltextTest.assertEquals((String)"/testroot/node2, /testroot/node3", (String)QueryFulltextTest.getResult(q.execute(), "path"));
        sql2 = "select [jcr:path] as [path] from [nt:base] where contains([node1/text], 'hello') order by [jcr:path]";
        q = qm.createQuery(sql2, "JCR-SQL2");
        QueryFulltextTest.assertEquals((String)"/testroot", (String)QueryFulltextTest.getResult(q.execute(), "path"));
        sql2 = "select [jcr:path] as [path] from [nt:base] where contains([node2/text], 'hello OR hallo') order by [jcr:path]";
        q = qm.createQuery(sql2, "JCR-SQL2");
        QueryFulltextTest.assertEquals((String)"/testroot", (String)QueryFulltextTest.getResult(q.execute(), "path"));
        sql2 = "select [jcr:path] as [path] from [nt:base] where contains([node1/text], 'hello') and contains([node2/text], 'hallo') order by [jcr:path]";
        q = qm.createQuery(sql2, "JCR-SQL2");
        QueryFulltextTest.assertEquals((String)"/testroot", (String)QueryFulltextTest.getResult(q.execute(), "path"));
    }

    public void testInValues() throws Exception {
        Session session = this.superuser;
        QueryManager qm = session.getWorkspace().getQueryManager();
        Node n1 = this.testRootNode.addNode("node1");
        n1.setProperty("text", "hello");
        Node n2 = this.testRootNode.addNode("node2");
        n2.setProperty("text", "hallo");
        Node n3 = this.testRootNode.addNode("node3");
        n3.setProperty("text", "hello hallo");
        session.save();
        String sql2 = "select [jcr:path] as [path], [jcr:score], * from [nt:base] as a where [text] in('hello', 'hallo')";
        Query q = qm.createQuery(sql2, "JCR-SQL2");
        String path = QueryFulltextTest.getResult(q.execute(), "path");
        QueryFulltextTest.assertEquals((String)"/testroot/node1, /testroot/node2", (String)path);
    }

    static String getResult(QueryResult result, String propertyName) throws RepositoryException {
        StringBuilder buff = new StringBuilder();
        RowIterator it = result.getRows();
        while (it.hasNext()) {
            if (buff.length() > 0) {
                buff.append(", ");
            }
            buff.append(it.nextRow().getValue(propertyName).getString());
        }
        return buff.toString();
    }
}

