/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.jcr.OakSegmentTarRepositoryStub;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.aggregate.AggregateIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.DefaultSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.DefaultSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.EmbeddedSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate.NodeStateSolrServersObserver;
import org.apache.jackrabbit.oak.plugins.index.solr.index.SolrIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.EmbeddedSolrServerProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.util.SolrIndexInitializer;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.solr.client.solrj.SolrClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class SolrOakRepositoryStub
extends OakSegmentTarRepositoryStub {
    public SolrOakRepositoryStub(Properties settings) throws RepositoryException {
        super(settings);
    }

    protected void preCreateRepository(Jcr jcr) {
        SolrClient solrServer;
        File f = new File("target" + File.separatorChar + "queryjcrtest-" + System.currentTimeMillis());
        try {
            solrServer = new EmbeddedSolrServerProvider(new EmbeddedSolrServerConfiguration(f.getPath(), "oak")).getSolrServer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SolrServerProvider solrServerProvider = new SolrServerProvider(){

            public void close() throws IOException {
            }

            @Nullable
            public SolrClient getSolrServer() throws Exception {
                return solrServer;
            }

            public SolrClient getIndexingSolrServer() throws Exception {
                return solrServer;
            }

            public SolrClient getSearchingSolrServer() throws Exception {
                return solrServer;
            }
        };
        try {
            Assert.assertNotNull((Object)solrServer);
            solrServer.deleteByQuery("*:*");
            solrServer.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DefaultSolrConfiguration configuration = new DefaultSolrConfiguration(){

            @NotNull
            public OakSolrConfiguration.CommitPolicy getCommitPolicy() {
                return OakSolrConfiguration.CommitPolicy.HARD;
            }
        };
        DefaultSolrConfigurationProvider oakSolrConfigurationProvider = new DefaultSolrConfigurationProvider((OakSolrConfiguration)configuration);
        jcr.with((RepositoryInitializer)new SolrIndexInitializer(false)).with(AggregateIndexProvider.wrap((QueryIndexProvider)new SolrQueryIndexProvider(solrServerProvider, (OakSolrConfigurationProvider)oakSolrConfigurationProvider))).with((Observer)new NodeStateSolrServersObserver()).with((IndexEditorProvider)new SolrIndexEditorProvider(solrServerProvider, (OakSolrConfigurationProvider)oakSolrConfigurationProvider));
    }
}

