/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.fulltext.FullTextAnd;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextOr;
import org.apache.jackrabbit.oak.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrQueryIndex
implements QueryIndex.FulltextQueryIndex {
    private static final String NATIVE_SOLR_QUERY = "native*solr";
    private static final String NATIVE_LUCENE_QUERY = "native*lucene";
    public static final String TYPE = "solr";
    private final Logger log = LoggerFactory.getLogger(SolrQueryIndex.class);
    private final String name;
    private final SolrServer solrServer;
    private final OakSolrConfiguration configuration;
    private final NodeAggregator aggregator;

    public SolrQueryIndex(String name, SolrServer solrServer, OakSolrConfiguration configuration) {
        this.name = name;
        this.solrServer = solrServer;
        this.configuration = configuration;
        this.aggregator = null;
    }

    public String getIndexName() {
        return this.name;
    }

    public double getCost(Filter filter, NodeState root) {
        return 10.0 / (double)this.getMatchingFilterRestrictions(filter);
    }

    private int getMatchingFilterRestrictions(Filter filter) {
        int match = 0;
        if (filter.getFullTextConstraint() != null || filter.getFulltextConditions() != null && filter.getFulltextConditions().size() > 0) {
            ++match;
        }
        if (filter.getPathRestriction() != null && !Filter.PathRestriction.NO_RESTRICTION.equals((Object)filter.getPathRestriction()) && this.configuration.useForPathRestrictions()) {
            ++match;
        }
        if (filter.getPrimaryTypes() != null && filter.getPrimaryTypes().size() > 0 && this.configuration.useForPrimaryTypes()) {
            ++match;
        }
        if (filter.getPropertyRestrictions() != null && filter.getPropertyRestrictions().size() > 0 && (filter.getPropertyRestriction(NATIVE_SOLR_QUERY) != null || filter.getPropertyRestriction(NATIVE_LUCENE_QUERY) != null || this.configuration.useForPropertyRestrictions()) && !this.hasIgnoredProperties(filter.getPropertyRestrictions())) {
            ++match;
        }
        return match;
    }

    private boolean hasIgnoredProperties(Collection<Filter.PropertyRestriction> propertyRestrictions) {
        for (Filter.PropertyRestriction pr : propertyRestrictions) {
            if (!this.configuration.getIgnoredProperties().contains(pr.propertyName)) continue;
            return true;
        }
        return false;
    }

    public String getPlan(Filter filter, NodeState nodeState) {
        return this.getQuery(filter).toString();
    }

    private SolrQuery getQuery(Filter filter) {
        Filter.PathRestriction pathRestriction;
        SolrQuery solrQuery = new SolrQuery();
        this.setDefaults(solrQuery);
        StringBuilder queryBuilder = new StringBuilder();
        FullTextExpression ft = filter.getFullTextConstraint();
        if (ft != null) {
            queryBuilder.append(this.getFullTextQuery(ft));
            queryBuilder.append(' ');
        } else if (filter.getFulltextConditions() != null) {
            Collection fulltextConditions = filter.getFulltextConditions();
            for (String fulltextCondition : fulltextConditions) {
                queryBuilder.append(fulltextCondition).append(" ");
            }
        }
        Collection propertyRestrictions = filter.getPropertyRestrictions();
        if (propertyRestrictions != null && !propertyRestrictions.isEmpty()) {
            for (Filter.PropertyRestriction pr : propertyRestrictions) {
                if (NATIVE_SOLR_QUERY.equals(pr.propertyName) || NATIVE_LUCENE_QUERY.equals(pr.propertyName)) {
                    String nativeQueryString = String.valueOf(pr.first.getValue(pr.first.getType()));
                    if (this.isSupportedHttpRequest(nativeQueryString)) {
                        String requestHandlerString = nativeQueryString.substring(0, nativeQueryString.indexOf(63));
                        if (!"select".equals(requestHandlerString)) {
                            if (requestHandlerString.charAt(0) != '/') {
                                requestHandlerString = "/" + requestHandlerString;
                            }
                            solrQuery.setRequestHandler(requestHandlerString);
                        }
                        String parameterString = nativeQueryString.substring(nativeQueryString.indexOf(63) + 1);
                        for (String param : parameterString.split("&")) {
                            String[] kv = param.split("=");
                            if (kv.length != 2) {
                                throw new RuntimeException("Unparsable native HTTP Solr query");
                            }
                            if ("stream.body".equals(kv[0])) {
                                kv[0] = "q";
                                String mltFlString = "mlt.fl=";
                                int mltFlIndex = parameterString.indexOf(mltFlString);
                                if (mltFlIndex > -1) {
                                    int beginIndex = mltFlIndex + mltFlString.length();
                                    int endIndex = parameterString.indexOf(38, beginIndex);
                                    String fields = endIndex > beginIndex ? parameterString.substring(beginIndex, endIndex) : parameterString.substring(beginIndex);
                                    kv[1] = "_query_:\"{!dismax qf=" + fields + " q.op=OR}" + kv[1] + "\"";
                                }
                            }
                            solrQuery.setParam(kv[0], new String[]{kv[1]});
                        }
                        return solrQuery;
                    }
                    queryBuilder.append(nativeQueryString);
                } else {
                    String prField;
                    CharSequence fieldName;
                    if (!this.configuration.useForPropertyRestrictions() || pr.propertyName.contains("/") || "rep:excerpt".equals(pr.propertyName) || this.configuration.getIgnoredProperties().contains(pr.propertyName)) continue;
                    String first = null;
                    if (pr.first != null) {
                        first = SolrQueryIndex.partialEscape(String.valueOf(pr.first.getValue(pr.first.getType()))).toString();
                    }
                    String last = null;
                    if (pr.last != null) {
                        last = SolrQueryIndex.partialEscape(String.valueOf(pr.last.getValue(pr.last.getType()))).toString();
                    }
                    if ("jcr\\:path".equals((fieldName = SolrQueryIndex.partialEscape((prField = this.configuration.getFieldForPropertyRestriction(pr)) != null ? prField : pr.propertyName)).toString())) {
                        queryBuilder.append(this.configuration.getPathField());
                        queryBuilder.append(':');
                        queryBuilder.append(first);
                    } else if (pr.first != null && pr.last != null && pr.first.equals(pr.last)) {
                        queryBuilder.append(fieldName).append(':');
                        queryBuilder.append(first);
                    } else if (pr.first == null && pr.last == null) {
                        if (!queryBuilder.toString().contains(fieldName + ":")) {
                            queryBuilder.append(fieldName).append(':');
                            queryBuilder.append('*');
                        }
                    } else if (pr.first != null && pr.last == null || pr.last != null && pr.first == null || !pr.first.equals(pr.last)) {
                        queryBuilder.append(fieldName).append(':');
                        queryBuilder.append(SolrQueryIndex.createRangeQuery(first, last, pr.firstIncluding, pr.lastIncluding));
                    } else if (pr.isLike) {
                        queryBuilder.append(fieldName).append(':');
                        queryBuilder.append(SolrQueryIndex.partialEscape(String.valueOf(pr.first.getValue(pr.first.getType())).replace('%', '*').replace('_', '?')));
                    } else {
                        throw new RuntimeException("[unexpected!] not handled case");
                    }
                }
                queryBuilder.append(" ");
            }
        }
        if (this.configuration.useForPrimaryTypes()) {
            String[] pts = filter.getPrimaryTypes().toArray(new String[filter.getPrimaryTypes().size()]);
            for (int i = 0; i < pts.length; ++i) {
                String pt = pts[i];
                if (i == 0) {
                    queryBuilder.append("(");
                }
                if (i > 0 && i < pts.length) {
                    queryBuilder.append("OR ");
                }
                queryBuilder.append("jcr\\:primaryType").append(':').append(SolrQueryIndex.partialEscape(pt)).append(" ");
                if (i != pts.length - 1) continue;
                queryBuilder.append(")");
                queryBuilder.append(' ');
            }
        }
        if (this.configuration.useForPathRestrictions() && (pathRestriction = filter.getPathRestriction()) != null) {
            String path = SolrQueryIndex.purgePath(filter);
            String fieldName = this.configuration.getFieldForPathRestriction(pathRestriction);
            if (fieldName != null) {
                queryBuilder.append(fieldName);
                queryBuilder.append(':');
                queryBuilder.append(path);
            }
        }
        if (queryBuilder.length() == 0) {
            queryBuilder.append("*:*");
        }
        String escapedQuery = queryBuilder.toString();
        solrQuery.setQuery(escapedQuery);
        if (this.log.isDebugEnabled()) {
            this.log.debug("JCR query {} has been converted to Solr query {}", (Object)filter.getQueryStatement(), (Object)solrQuery.toString());
        }
        return solrQuery;
    }

    private String getFullTextQuery(FullTextExpression ft) {
        final StringBuilder fullTextString = new StringBuilder();
        ft.accept(new FullTextVisitor(){

            public boolean visit(FullTextOr or) {
                fullTextString.append('(');
                for (int i = 0; i < or.list.size(); ++i) {
                    if (i > 0 && i < or.list.size()) {
                        fullTextString.append(" OR ");
                    }
                    FullTextExpression e = (FullTextExpression)or.list.get(i);
                    String orTerm = SolrQueryIndex.this.getFullTextQuery(e);
                    fullTextString.append(orTerm);
                }
                fullTextString.append(')');
                fullTextString.append(' ');
                return true;
            }

            public boolean visit(FullTextAnd and) {
                fullTextString.append('(');
                for (int i = 0; i < and.list.size(); ++i) {
                    if (i > 0 && i < and.list.size()) {
                        fullTextString.append(" AND ");
                    }
                    FullTextExpression e = (FullTextExpression)and.list.get(i);
                    String andTerm = SolrQueryIndex.this.getFullTextQuery(e);
                    fullTextString.append(andTerm);
                }
                fullTextString.append(')');
                fullTextString.append(' ');
                return true;
            }

            public boolean visit(FullTextTerm term) {
                String boost;
                String p;
                if (term.isNot()) {
                    fullTextString.append('-');
                }
                if ((p = term.getPropertyName()) != null && p.indexOf(47) >= 0) {
                    p = PathUtils.getName((String)p);
                }
                if (p == null || "*".equals(p)) {
                    p = SolrQueryIndex.this.configuration.getCatchAllField();
                }
                fullTextString.append(SolrQueryIndex.partialEscape(p));
                fullTextString.append(':');
                String termText = term.getText();
                if (termText.indexOf(32) > 0) {
                    fullTextString.append('\"');
                }
                fullTextString.append(termText.replace("/", "\\/").replace(":", "\\:"));
                if (termText.indexOf(32) > 0) {
                    fullTextString.append('\"');
                }
                if ((boost = term.getBoost()) != null) {
                    fullTextString.append('^');
                    fullTextString.append(boost);
                }
                fullTextString.append(' ');
                return true;
            }
        });
        return fullTextString.toString();
    }

    private static Set<String> getRelativePaths(FullTextExpression ft) {
        final HashSet<String> relPaths = new HashSet<String>();
        ft.accept((FullTextVisitor)new FullTextVisitor.FullTextVisitorBase(){

            public boolean visit(FullTextTerm term) {
                String p = term.getPropertyName();
                if (p == null) {
                    relPaths.add("");
                } else {
                    if (p.startsWith("../") || p.startsWith("./")) {
                        throw new IllegalArgumentException("Relative parent is not supported:" + p);
                    }
                    if (PathUtils.getDepth((String)p) > 1) {
                        String parent = PathUtils.getParentPath((String)p);
                        relPaths.add(parent);
                    } else {
                        relPaths.add("");
                    }
                }
                return true;
            }
        });
        return relPaths;
    }

    private boolean isSupportedHttpRequest(String nativeQueryString) {
        return nativeQueryString.matches("(mlt|query|select|get)\\\\?.*");
    }

    private void setDefaults(SolrQuery solrQuery) {
        solrQuery.setParam("q.op", new String[]{"AND"});
        solrQuery.setParam("fl", new String[]{this.configuration.getPathField() + " score"});
        String catchAllField = this.configuration.getCatchAllField();
        if (catchAllField != null && catchAllField.length() > 0) {
            solrQuery.setParam("df", new String[]{catchAllField});
        }
        solrQuery.setParam("rows", new String[]{String.valueOf(this.configuration.getRows())});
    }

    private static String createRangeQuery(String first, String last, boolean firstIncluding, boolean lastIncluding) {
        return "[" + (first != null ? first : "*") + " TO " + (last != null ? last : "*") + "]";
    }

    private static String purgePath(Filter filter) {
        return SolrQueryIndex.partialEscape(filter.getPath()).toString();
    }

    private static CharSequence partialEscape(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '/' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '-' || c == ' ') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb;
    }

    public Cursor query(final Filter filter, NodeState root) {
        SolrRowCursor cursor;
        try {
            Set relPaths = filter.getFullTextConstraint() != null ? SolrQueryIndex.getRelativePaths(filter.getFullTextConstraint()) : Collections.emptySet();
            final String parent = relPaths.size() == 0 ? "" : (String)relPaths.iterator().next();
            final int parentDepth = PathUtils.getDepth((String)parent);
            cursor = new SolrRowCursor((Iterator<SolrResultRow>)new AbstractIterator<SolrResultRow>(){
                private final Set<String> seenPaths = Sets.newHashSet();
                private final Deque<SolrResultRow> queue = Queues.newArrayDeque();
                private SolrDocument lastDoc;
                public int offset = 0;

                protected SolrResultRow computeNext() {
                    if (!this.queue.isEmpty() || this.loadDocs()) {
                        return this.queue.remove();
                    }
                    return (SolrResultRow)this.endOfData();
                }

                private SolrResultRow convertToRow(SolrDocument doc) throws IOException {
                    String path = String.valueOf(doc.getFieldValue(SolrQueryIndex.this.configuration.getPathField()));
                    if (path != null) {
                        if ("".equals(path)) {
                            path = "/";
                        }
                        if (!parent.isEmpty()) {
                            if (this.seenPaths.contains(path = PathUtils.getAncestorPath((String)path, (int)parentDepth))) {
                                return null;
                            }
                            this.seenPaths.add(path);
                        }
                        float score = 0.0f;
                        Object scoreObj = doc.get((Object)"score");
                        if (scoreObj != null) {
                            score = ((Float)scoreObj).floatValue();
                        }
                        return new SolrResultRow(path, score, doc);
                    }
                    return null;
                }

                private boolean loadDocs() {
                    SolrDocument lastDocToRecord;
                    block9: {
                        lastDocToRecord = null;
                        try {
                            if (SolrQueryIndex.this.log.isDebugEnabled()) {
                                SolrQueryIndex.this.log.debug("converting filter {}", (Object)filter);
                            }
                            SolrQuery query = SolrQueryIndex.this.getQuery(filter);
                            if (this.lastDoc != null) {
                                ++this.offset;
                                int newOffset = this.offset * SolrQueryIndex.this.configuration.getRows();
                                query.setParam("start", new String[]{String.valueOf(newOffset)});
                            }
                            if (SolrQueryIndex.this.log.isDebugEnabled()) {
                                SolrQueryIndex.this.log.debug("sending query {}", (Object)query);
                            }
                            SolrDocumentList docs = SolrQueryIndex.this.solrServer.query((SolrParams)query).getResults();
                            if (SolrQueryIndex.this.log.isDebugEnabled()) {
                                SolrQueryIndex.this.log.debug("getting docs {}", (Object)docs);
                            }
                            for (SolrDocument doc : docs) {
                                SolrResultRow row = this.convertToRow(doc);
                                if (row != null) {
                                    this.queue.add(row);
                                }
                                lastDocToRecord = doc;
                            }
                        }
                        catch (Exception e) {
                            if (!SolrQueryIndex.this.log.isWarnEnabled()) break block9;
                            SolrQueryIndex.this.log.warn("query via {} failed.", (Object)SolrQueryIndex.this.solrServer, (Object)e);
                        }
                    }
                    if (lastDocToRecord != null) {
                        this.lastDoc = lastDocToRecord;
                    }
                    return !this.queue.isEmpty();
                }
            }, filter.getQueryEngineSettings());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cursor;
    }

    @CheckForNull
    public NodeAggregator getNodeAggregator() {
        return this.aggregator;
    }

    static class SolrRowCursor
    implements Cursor {
        private final Cursor pathCursor;
        SolrResultRow currentRow;

        SolrRowCursor(final Iterator<SolrResultRow> it, QueryEngineSettings settings) {
            Iterator<String> pathIterator = new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    SolrRowCursor.this.currentRow = (SolrResultRow)it.next();
                    return SolrRowCursor.this.currentRow.path;
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
            this.pathCursor = new Cursors.PathCursor((Iterator)pathIterator, true, settings);
        }

        public boolean hasNext() {
            return this.pathCursor.hasNext();
        }

        public void remove() {
            this.pathCursor.remove();
        }

        public IndexRow next() {
            final IndexRow pathRow = this.pathCursor.next();
            return new IndexRow(){

                public String getPath() {
                    return pathRow.getPath();
                }

                public PropertyValue getValue(String columnName) {
                    if ("jcr:score".equals(columnName)) {
                        return PropertyValues.newDouble((Double)SolrRowCursor.this.currentRow.score);
                    }
                    return SolrRowCursor.this.currentRow.doc != null ? PropertyValues.newString((String)String.valueOf(SolrRowCursor.this.currentRow.doc.getFieldValue(columnName))) : null;
                }
            };
        }
    }

    static class SolrResultRow {
        final String path;
        final double score;
        SolrDocument doc;

        SolrResultRow(String path, double score) {
            this.path = path;
            this.score = score;
        }

        SolrResultRow(String path, double score, SolrDocument doc) {
            this.path = path;
            this.score = score;
            this.doc = doc;
        }

        public String toString() {
            return String.format("%s (%1.2f)", this.path, this.score);
        }
    }
}

