/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.util;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.CommitPolicy;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.DefaultSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.DefaultSolrServerProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class OakSolrUtils {
    public static boolean checkServerAlive(@Nonnull SolrServer solrServer) throws IOException, SolrServerException {
        return solrServer.ping().getStatus() == 0;
    }

    public static QueryIndexProvider adaptOsgiQueryIndexProvider() {
        QueryIndexProvider queryIndexProvider = null;
        try {
            BundleContext ctx = ((BundleReference)BundleReference.class.cast(SolrQueryIndexProvider.class.getClassLoader())).getBundle().getBundleContext();
            ServiceReference serviceReference = ctx.getServiceReference(QueryIndexProvider.class.getName());
            if (serviceReference != null) {
                queryIndexProvider = (QueryIndexProvider)QueryIndexProvider.class.cast(ctx.getService(serviceReference));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return queryIndexProvider;
    }

    public static <T extends SolrServerProvider> SolrServerProvider adaptOsgiSolrServerProvider(Class<T> providerClass) {
        SolrServerProvider solrServerProvider = null;
        try {
            BundleContext ctx = FrameworkUtil.getBundle(providerClass).getBundleContext();
            ServiceReference serviceReference = ctx.getServiceReference(SolrServerProvider.class.getName());
            if (serviceReference != null) {
                solrServerProvider = (SolrServerProvider)SolrServerProvider.class.cast(ctx.getService(serviceReference));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return solrServerProvider;
    }

    public static <T extends SolrServerProvider> SolrServerProvider getSolrServerProvider(Class<T> providerClass) {
        SolrServerProvider solrServerProvider = OakSolrUtils.adaptOsgiSolrServerProvider(providerClass);
        if (solrServerProvider == null && providerClass != null) {
            try {
                solrServerProvider = (SolrServerProvider)providerClass.newInstance();
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (solrServerProvider == null) {
            solrServerProvider = new DefaultSolrServerProvider();
        }
        return solrServerProvider;
    }

    public static <T extends OakSolrConfigurationProvider> OakSolrConfigurationProvider adaptOsgiOakSolrConfigurationProvider(Class<T> providerClass) {
        OakSolrConfigurationProvider oakSolrConfigurationProvider = null;
        try {
            BundleContext ctx = FrameworkUtil.getBundle(providerClass).getBundleContext();
            ServiceReference serviceReference = ctx.getServiceReference(OakSolrConfigurationProvider.class.getName());
            if (serviceReference != null) {
                oakSolrConfigurationProvider = (OakSolrConfigurationProvider)OakSolrConfigurationProvider.class.cast(ctx.getService(serviceReference));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return oakSolrConfigurationProvider;
    }

    public static <T extends OakSolrConfigurationProvider> OakSolrConfigurationProvider getOakSolrConfigurationProvider(Class<T> providerClass) {
        OakSolrConfigurationProvider oakSolrConfigurationProvider = OakSolrUtils.adaptOsgiOakSolrConfigurationProvider(providerClass);
        if (oakSolrConfigurationProvider == null && providerClass != null) {
            try {
                oakSolrConfigurationProvider = (OakSolrConfigurationProvider)providerClass.newInstance();
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (oakSolrConfigurationProvider == null) {
            oakSolrConfigurationProvider = new DefaultSolrConfigurationProvider();
        }
        return oakSolrConfigurationProvider;
    }

    public static void commitByPolicy(SolrServer solrServer, CommitPolicy commitPolicy) throws IOException, SolrServerException {
        switch (commitPolicy) {
            case HARD: {
                solrServer.commit();
                break;
            }
            case SOFT: {
                solrServer.commit(false, false, true);
                break;
            }
        }
    }
}

