/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndex;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrQueryIndexProvider
implements QueryIndexProvider {
    private final Logger log = LoggerFactory.getLogger(SolrQueryIndexProvider.class);
    private SolrServerProvider solrServerProvider;
    private OakSolrConfigurationProvider oakSolrConfigurationProvider;

    public SolrQueryIndexProvider(SolrServerProvider solrServerProvider, OakSolrConfigurationProvider oakSolrConfigurationProvider) {
        this.oakSolrConfigurationProvider = oakSolrConfigurationProvider;
        this.solrServerProvider = solrServerProvider;
    }

    @Nonnull
    public List<? extends QueryIndex> getQueryIndexes(NodeState nodeState) {
        ArrayList<SolrQueryIndex> tempIndexes = new ArrayList<SolrQueryIndex>();
        if (this.solrServerProvider == null || this.oakSolrConfigurationProvider == null) {
            return tempIndexes;
        }
        NodeState definitions = nodeState.getChildNode("oak:index");
        for (ChildNodeEntry entry : definitions.getChildNodeEntries()) {
            NodeState definition = entry.getNodeState();
            PropertyState type = definition.getProperty("type");
            if (type != null && "solr".equals(type.getValue(Type.STRING)) && this.log.isDebugEnabled()) {
                this.log.debug("found a Solr index definition {}", (Object)entry.getName());
            }
            try {
                tempIndexes.add(new SolrQueryIndex(entry.getName(), this.solrServerProvider.getSolrServer(), this.oakSolrConfigurationProvider.getConfiguration()));
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error("unable to create Solr query index at " + entry.getName(), (Throwable)e);
            }
        }
        return tempIndexes;
    }
}

