/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.util.Collection;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrQueryIndex
implements QueryIndex {
    private static final Logger log = LoggerFactory.getLogger(SolrQueryIndex.class);
    public static final String TYPE = "solr";
    private final String name;
    private final SolrServer solrServer;
    private final OakSolrConfiguration configuration;

    public SolrQueryIndex(String name, SolrServer solrServer, OakSolrConfiguration configuration) {
        this.name = name;
        this.solrServer = solrServer;
        this.configuration = configuration;
    }

    public String getIndexName() {
        return this.name;
    }

    public double getCost(Filter filter, NodeState root) {
        return (filter.getPropertyRestrictions() != null ? (double)filter.getPropertyRestrictions().size() * 0.1 : 0.0) + (filter.getFulltextConditions() != null ? (double)filter.getFulltextConditions().size() * 0.01 : 0.0) + (filter.getPathRestriction() != null ? 0.2 : 0.0);
    }

    public String getPlan(Filter filter, NodeState nodeState) {
        return this.getQuery(filter).toString();
    }

    private SolrQuery getQuery(Filter filter) {
        Collection propertyRestrictions;
        SolrQuery solrQuery = new SolrQuery();
        this.setDefaults(solrQuery);
        StringBuilder queryBuilder = new StringBuilder();
        Filter.PathRestriction pathRestriction = filter.getPathRestriction();
        if (pathRestriction != null) {
            String path = SolrQueryIndex.purgePath(filter);
            String fieldName = this.configuration.getFieldForPathRestriction(pathRestriction);
            if (fieldName != null) {
                queryBuilder.append(fieldName);
                queryBuilder.append(':');
                queryBuilder.append(path);
                if (!path.equals("\\/")) {
                    queryBuilder.append("\\/");
                }
                if (pathRestriction.equals((Object)Filter.PathRestriction.ALL_CHILDREN)) {
                    queryBuilder.append("*");
                }
                queryBuilder.append(" ");
            }
        }
        if ((propertyRestrictions = filter.getPropertyRestrictions()) != null && !propertyRestrictions.isEmpty()) {
            for (Filter.PropertyRestriction pr : propertyRestrictions) {
                String prField;
                CharSequence fieldName;
                if (pr.propertyName.contains("/")) continue;
                String first = null;
                if (pr.first != null) {
                    first = SolrQueryIndex.partialEscape(String.valueOf(pr.first.getValue(pr.first.getType()))).toString();
                }
                String last = null;
                if (pr.last != null) {
                    last = SolrQueryIndex.partialEscape(String.valueOf(pr.last.getValue(pr.last.getType()))).toString();
                }
                if ("jcr\\:path".equals((fieldName = SolrQueryIndex.partialEscape((prField = this.configuration.getFieldForPropertyRestriction(pr)) != null ? prField : pr.propertyName)).toString())) {
                    queryBuilder.append(this.configuration.getPathField());
                    queryBuilder.append(':');
                    queryBuilder.append(first);
                    if (first != null && !"\\/".equals(first)) {
                        queryBuilder.append("\\/");
                    }
                } else {
                    queryBuilder.append(fieldName).append(':');
                    if (pr.first != null && pr.last != null && pr.first.equals(pr.last)) {
                        queryBuilder.append(first);
                    } else if (pr.first == null && pr.last == null) {
                        queryBuilder.append('*');
                    } else if (pr.first != null && pr.last == null || pr.last != null && pr.first == null || !pr.first.equals(pr.last)) {
                        queryBuilder.append(SolrQueryIndex.createRangeQuery(first, last, pr.firstIncluding, pr.lastIncluding));
                    } else if (pr.isLike) {
                        queryBuilder.append(SolrQueryIndex.partialEscape(String.valueOf(pr.first.getValue(pr.first.getType())).replace('%', '*').replace('_', '?')));
                    } else {
                        throw new RuntimeException("[unexpected!] not handled case");
                    }
                }
                queryBuilder.append(" ");
            }
        }
        Collection fulltextConditions = filter.getFulltextConditions();
        for (String fulltextCondition : fulltextConditions) {
            queryBuilder.append(fulltextCondition).append(" ");
        }
        if (queryBuilder.length() == 0) {
            queryBuilder.append("*:*");
        }
        String escapedQuery = queryBuilder.toString();
        solrQuery.setQuery(escapedQuery);
        if (log.isDebugEnabled()) {
            log.debug("JCR query: \n" + filter.getQueryStatement() + " \nhas been converted to Solr query: \n" + solrQuery.toString());
        }
        return solrQuery;
    }

    private void setDefaults(SolrQuery solrQuery) {
        solrQuery.setParam("q.op", new String[]{"AND"});
        solrQuery.setParam("df", new String[]{"catch_all"});
        solrQuery.setParam("rows", new String[]{String.valueOf(Integer.MAX_VALUE)});
    }

    private static String createRangeQuery(String first, String last, boolean firstIncluding, boolean lastIncluding) {
        StringBuilder rangeQueryBuilder = new StringBuilder("[");
        rangeQueryBuilder.append(first != null ? first : "*");
        rangeQueryBuilder.append(" TO ");
        rangeQueryBuilder.append(last != null ? last : "*");
        rangeQueryBuilder.append("]");
        return rangeQueryBuilder.toString();
    }

    private static String purgePath(Filter filter) {
        return SolrQueryIndex.partialEscape(filter.getPath()).toString();
    }

    private static CharSequence partialEscape(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '/' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '-' || c == ' ') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb;
    }

    public Cursor query(Filter filter, NodeState root) {
        SolrCursor cursor;
        try {
            SolrQuery query = this.getQuery(filter);
            QueryResponse queryResponse = this.solrServer.query((SolrParams)query);
            cursor = new SolrCursor(queryResponse);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cursor;
    }

    private class SolrCursor
    implements Cursor {
        private final SolrDocumentList results;
        private int i;

        public SolrCursor(QueryResponse queryResponse) {
            this.results = queryResponse.getResults();
            this.i = 0;
        }

        public boolean hasNext() {
            return this.results != null && this.i < this.results.size();
        }

        public void remove() {
            this.results.remove(this.i);
        }

        public IndexRow next() {
            if (this.i < this.results.size()) {
                final SolrDocument doc = (SolrDocument)this.results.get(this.i);
                ++this.i;
                return new IndexRow(){

                    public String getPath() {
                        String path = String.valueOf(doc.getFieldValue(SolrQueryIndex.this.configuration.getPathField()));
                        if ("/".equals(path)) {
                            return "/";
                        }
                        return path.substring(0, path.length() - 1);
                    }

                    public PropertyValue getValue(String columnName) {
                        Object o = doc.getFieldValue(columnName);
                        return o == null ? null : PropertyValues.newString((String)o.toString());
                    }
                };
            }
            return null;
        }
    }
}

