/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.index.SolrIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

@Component(metatype=false, immediate=true)
@Service(value={IndexEditorProvider.class})
public class SolrIndexEditorProviderService
implements IndexEditorProvider {
    @Reference(policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.STATIC)
    private SolrServerProvider solrServerProvider;
    @Reference(policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.STATIC)
    private OakSolrConfigurationProvider oakSolrConfigurationProvider;
    private SolrIndexEditorProvider solrIndexEditorProvider;

    @CheckForNull
    public Editor getIndexEditor(@Nonnull String type, @Nonnull NodeBuilder definition, @Nonnull NodeState root, IndexUpdateCallback callback) throws CommitFailedException {
        Editor indexEditor = null;
        if (this.solrServerProvider != null && this.oakSolrConfigurationProvider != null && this.solrIndexEditorProvider == null) {
            this.solrIndexEditorProvider = new SolrIndexEditorProvider(this.solrServerProvider, this.oakSolrConfigurationProvider);
            indexEditor = this.solrIndexEditorProvider.getIndexEditor(type, definition, root, callback);
        }
        return indexEditor;
    }

    protected void bindSolrServerProvider(SolrServerProvider solrServerProvider) {
        this.solrServerProvider = solrServerProvider;
    }

    protected void unbindSolrServerProvider(SolrServerProvider solrServerProvider) {
        if (this.solrServerProvider == solrServerProvider) {
            this.solrServerProvider = null;
        }
    }

    protected void bindOakSolrConfigurationProvider(OakSolrConfigurationProvider oakSolrConfigurationProvider) {
        this.oakSolrConfigurationProvider = oakSolrConfigurationProvider;
    }

    protected void unbindOakSolrConfigurationProvider(OakSolrConfigurationProvider oakSolrConfigurationProvider) {
        if (this.oakSolrConfigurationProvider == oakSolrConfigurationProvider) {
            this.oakSolrConfigurationProvider = null;
        }
    }
}

