/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.index;

import java.io.IOException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexEditor;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.util.OakSolrUtils;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;

public class SolrIndexEditor
implements IndexEditor {
    private final SolrIndexEditor parent;
    private final String name;
    private String path;
    private final NodeBuilder definition;
    private final SolrServer solrServer;
    private final OakSolrConfiguration configuration;
    private boolean propertiesChanged = false;
    private final IndexUpdateCallback updateCallback;

    SolrIndexEditor(NodeBuilder definition, SolrServer solrServer, OakSolrConfiguration configuration, IndexUpdateCallback callback) throws CommitFailedException {
        this.parent = null;
        this.name = null;
        this.path = "/";
        this.definition = definition;
        this.solrServer = solrServer;
        this.configuration = configuration;
        this.updateCallback = callback;
    }

    private SolrIndexEditor(SolrIndexEditor parent, String name) {
        this.parent = parent;
        this.name = name;
        this.path = null;
        this.definition = parent.definition;
        this.solrServer = parent.solrServer;
        this.configuration = parent.configuration;
        this.updateCallback = parent.updateCallback;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat((String)this.parent.getPath(), (String)this.name);
        }
        return this.path;
    }

    public void enter(NodeState before, NodeState after) {
    }

    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        if (this.propertiesChanged || !before.exists()) {
            this.updateCallback.indexUpdate();
            try {
                this.solrServer.add(this.docFromState(after));
            }
            catch (SolrServerException e) {
                throw new CommitFailedException("Solr", 2, "Failed to add a document to Solr", (Throwable)e);
            }
            catch (IOException e) {
                throw new CommitFailedException("Solr", 6, "Failed to send data to Solr", (Throwable)e);
            }
        }
        if (this.parent == null) {
            try {
                OakSolrUtils.commitByPolicy(this.solrServer, this.configuration.getCommitPolicy());
            }
            catch (SolrServerException e) {
                throw new CommitFailedException("Solr", 3, "Failed to commit changes to Solr", (Throwable)e);
            }
            catch (IOException e) {
                throw new CommitFailedException("Solr", 6, "Failed to send data to Solr", (Throwable)e);
            }
        }
    }

    public void propertyAdded(PropertyState after) {
        this.propertiesChanged = true;
    }

    public void propertyChanged(PropertyState before, PropertyState after) {
        this.propertiesChanged = true;
    }

    public void propertyDeleted(PropertyState before) {
        this.propertiesChanged = true;
    }

    public Editor childNodeAdded(String name, NodeState after) {
        return new SolrIndexEditor(this, name);
    }

    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        return new SolrIndexEditor(this, name);
    }

    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        String path = PathUtils.concat((String)this.getPath(), (String)name).replace("/", "\\/");
        try {
            this.solrServer.deleteByQuery(String.format("%s:%s\\/*", this.configuration.getPathField(), path));
            this.updateCallback.indexUpdate();
        }
        catch (SolrServerException e) {
            throw new CommitFailedException("Solr", 5, "Failed to remove documents from Solr", (Throwable)e);
        }
        catch (IOException e) {
            throw new CommitFailedException("Solr", 6, "Failed to send data to Solr", (Throwable)e);
        }
        return null;
    }

    private SolrInputDocument docFromState(NodeState state) {
        SolrInputDocument inputDocument = new SolrInputDocument();
        String path = this.getPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        inputDocument.addField(this.configuration.getPathField(), (Object)path);
        for (PropertyState property : state.getProperties()) {
            String fieldName = this.configuration.getFieldNameFor(property.getType());
            if (fieldName != null) {
                inputDocument.addField(fieldName, property.getValue(property.getType()));
                continue;
            }
            if (property.isArray()) {
                for (String s : (Iterable)property.getValue(Type.STRINGS)) {
                    inputDocument.addField(property.getName(), (Object)s);
                }
                continue;
            }
            inputDocument.addField(property.getName(), property.getValue(Type.STRING));
        }
        return inputDocument;
    }
}

