/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.configuration;

public class SolrServerConfiguration {
    private final String solrHomePath;
    private final String solrConfigPath;
    private final String coreName;
    private HttpConfiguration httpConfiguration;

    public SolrServerConfiguration(String solrHomePath, String solrConfigPath, String coreName) {
        this.solrHomePath = solrHomePath;
        this.solrConfigPath = solrConfigPath;
        this.coreName = coreName;
    }

    public SolrServerConfiguration withHttpConfiguration(String context, Integer httpPort) {
        if (context != null && context.length() > 0 && httpPort != null && httpPort > 0) {
            this.httpConfiguration = new HttpConfiguration(context, httpPort);
        }
        return this;
    }

    public String getSolrHomePath() {
        return this.solrHomePath;
    }

    public String getSolrConfigPath() {
        return this.solrConfigPath;
    }

    public String getCoreName() {
        return this.coreName;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public class HttpConfiguration {
        private String context;
        private Integer httpPort;

        HttpConfiguration(String context, Integer httpPort) {
            this.context = context;
            this.httpPort = httpPort;
        }

        public String getContext() {
            return this.context;
        }

        public Integer getHttpPort() {
            return this.httpPort;
        }
    }
}

