/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.configuration;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.CommitPolicy;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public abstract class OakSolrNodeStateConfiguration
implements OakSolrConfiguration,
SolrServerConfigurationProvider {
    protected abstract NodeState getConfigurationNodeState();

    @Override
    public String getFieldNameFor(Type<?> propertyType) {
        if (Type.BINARIES.equals(propertyType) || Type.BINARY.equals(propertyType)) {
            return propertyType.toString() + "_bin";
        }
        return null;
    }

    @Override
    public String getFieldForPropertyRestriction(Filter.PropertyRestriction propertyRestriction) {
        return null;
    }

    @Override
    public String getPathField() {
        return this.getStringValueFor("pathField", "path_exact");
    }

    @Override
    public String getFieldForPathRestriction(Filter.PathRestriction pathRestriction) {
        String fieldName = null;
        switch (pathRestriction) {
            case ALL_CHILDREN: {
                fieldName = this.getStringValueFor("descendantsField", "path_desc");
                break;
            }
            case DIRECT_CHILDREN: {
                fieldName = this.getStringValueFor("childrenField", "path_child");
                break;
            }
            case EXACT: {
                fieldName = this.getStringValueFor("pathField", "path_exact");
                break;
            }
            case PARENT: {
                fieldName = this.getStringValueFor("parentField", "path_anc");
                break;
            }
            case NO_RESTRICTION: {
                break;
            }
        }
        return fieldName;
    }

    @Override
    public CommitPolicy getCommitPolicy() {
        return CommitPolicy.valueOf(this.getStringValueFor("commitPolicy", CommitPolicy.SOFT.toString()));
    }

    protected String getStringValueFor(String propertyName, String defaultValue) {
        PropertyState property;
        String value = null;
        NodeState configurationNodeState = this.getConfigurationNodeState();
        if (configurationNodeState.exists() && (property = configurationNodeState.getProperty(propertyName)) != null) {
            value = (String)property.getValue(Type.STRING);
        }
        if (value == null || value.length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public SolrServerConfiguration getSolrServerConfiguration() {
        String solrHomePath = this.getStringValueFor("solrHomePath", "solr");
        String solrConfigPath = this.getStringValueFor("solrConfigPath", "solr.xml");
        String coreName = this.getStringValueFor("coreName", "oak");
        String context = this.getStringValueFor("solrContext", "/solr");
        Integer httpPort = Integer.valueOf(this.getStringValueFor("httpPort", "8983"));
        return new SolrServerConfiguration(solrHomePath, solrConfigPath, coreName).withHttpConfiguration(context, httpPort);
    }

    public final class Properties {
        public static final String SOLRHOME_PATH = "solrHomePath";
        public static final String SOLRCONFIG_PATH = "solrConfigPath";
        public static final String CONTEXT = "solrContext";
        public static final String HTTP_PORT = "httpPort";
        public static final String CORE_NAME = "coreName";
        public static final String PATH_FIELD = "pathField";
        public static final String PARENT_FIELD = "parentField";
        public static final String CHILDREN_FIELD = "childrenField";
        public static final String DESCENDANTS_FIELD = "descendantsField";
        public static final String COMMIT_POLICY = "commitPolicy";
    }
}

