/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.configuration;

import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.CommitPolicy;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.spi.query.Filter;

public class DefaultSolrConfiguration
implements OakSolrConfiguration {
    @Override
    public String getFieldNameFor(Type<?> propertyType) {
        if (Type.BINARIES.equals(propertyType) || Type.BINARY.equals(propertyType)) {
            return propertyType.toString() + "_bin";
        }
        return null;
    }

    @Override
    public String getPathField() {
        return "path_exact";
    }

    @Override
    public String getFieldForPathRestriction(Filter.PathRestriction pathRestriction) {
        String fieldName = null;
        switch (pathRestriction) {
            case ALL_CHILDREN: {
                fieldName = "path_desc";
                break;
            }
            case DIRECT_CHILDREN: {
                fieldName = "path_child";
                break;
            }
            case EXACT: {
                fieldName = "path_exact";
                break;
            }
            case PARENT: {
                fieldName = "path_anc";
                break;
            }
            case NO_RESTRICTION: {
                break;
            }
        }
        return fieldName;
    }

    @Override
    public String getFieldForPropertyRestriction(Filter.PropertyRestriction propertyRestriction) {
        return null;
    }

    @Override
    public CommitPolicy getCommitPolicy() {
        return CommitPolicy.SOFT;
    }
}

