/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.HttpMethod;
import com.amazonaws.SdkClientException;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.model.BucketAccelerateConfiguration;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GetBucketAccelerateConfigurationRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.PartSummary;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.Copy;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.util.NamedThreadFactory;
import org.apache.jackrabbit.guava.common.cache.Cache;
import org.apache.jackrabbit.guava.common.cache.CacheBuilder;
import org.apache.jackrabbit.oak.blob.cloud.s3.S3RequestDecorator;
import org.apache.jackrabbit.oak.blob.cloud.s3.Utils;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.commons.collections.AbstractIterator;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.ListUtils;
import org.apache.jackrabbit.oak.commons.collections.MapUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordDownloadOptions;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUpload;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUploadException;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUploadToken;
import org.apache.jackrabbit.oak.spi.blob.AbstractDataRecord;
import org.apache.jackrabbit.oak.spi.blob.AbstractSharedBackend;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Backend
extends AbstractSharedBackend {
    private static final Logger LOG = LoggerFactory.getLogger(S3Backend.class);
    private static final Logger LOG_STREAMS_DOWNLOAD = LoggerFactory.getLogger((String)"oak.datastore.download.streams");
    private static final Logger LOG_STREAMS_UPLOAD = LoggerFactory.getLogger((String)"oak.datastore.upload.streams");
    private static final String KEY_PREFIX = "dataStore_";
    private static final String META_KEY_PREFIX = "META/";
    private static final String REF_KEY = "reference.key";
    private static final int MAX_UNIQUE_RECORD_TRIES = 10;
    static final String PART_NUMBER = "partNumber";
    static final String UPLOAD_ID = "uploadId";
    private static final int ONE_MB = 0x100000;
    static final long MIN_MULTIPART_UPLOAD_PART_SIZE = 0xA00000L;
    static final long MAX_MULTIPART_UPLOAD_PART_SIZE = 0x10000000L;
    static final long MAX_SINGLE_PUT_UPLOAD_SIZE = 0x140000000L;
    static final long MAX_BINARY_UPLOAD_SIZE = 0x50000000000L;
    private static final int MAX_ALLOWABLE_UPLOAD_URIS = 10000;
    private AmazonS3Client s3service;
    private AmazonS3Client s3PresignService;
    private String bucket;
    private byte[] secret;
    private TransferManager tmx;
    private Properties properties;
    private Date startTime;
    private S3RequestDecorator s3ReqDecorator;
    private Cache<DataIdentifier, URI> httpDownloadURICache;
    private int httpUploadURIExpirySeconds = 0;
    private int httpDownloadURIExpirySeconds = 0;
    private boolean presignedDownloadURIVerifyExists = true;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() throws DataStoreException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String enablePresignedAccelerationStr;
            String getExpiry;
            String putExpiry;
            int n;
            String region;
            this.startTime = new Date();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            LOG.debug("init");
            this.s3ReqDecorator = new S3RequestDecorator(this.properties);
            this.s3PresignService = this.s3service = Utils.openService(this.properties);
            if (this.bucket == null || "".equals(this.bucket.trim())) {
                this.bucket = this.properties.getProperty("s3Bucket");
                if (StringUtils.isEmpty((CharSequence)this.bucket)) {
                    this.bucket = this.properties.getProperty("container");
                }
            }
            if (StringUtils.isEmpty((CharSequence)(region = this.properties.getProperty("s3Region")))) {
                Region region2 = Regions.getCurrentRegion();
                if (region2 == null) throw new AmazonClientException("parameter [s3Region] not configured and cannot be derived from environment");
                region = region2.getName();
            } else if ("us-standard".equals(region)) {
                region = com.amazonaws.services.s3.model.Region.US_Standard.toString();
            }
            this.createBucketIfNeeded(region);
            int n2 = 10;
            String writeThreadsStr = this.properties.getProperty("writeThreads");
            if (writeThreadsStr != null) {
                n = Integer.parseInt(writeThreadsStr);
            }
            LOG.info("Using thread pool of [{}] threads in S3 transfer manager.", (Object)n);
            this.tmx = new TransferManager((AmazonS3)this.s3service, Executors.newFixedThreadPool(n, (ThreadFactory)new NamedThreadFactory("s3-transfer-manager-worker")));
            String renameKeyProp = this.properties.getProperty("s3RenameKeys");
            boolean renameKeyBool = renameKeyProp == null || "".equals(renameKeyProp) ? false : Boolean.parseBoolean(renameKeyProp);
            LOG.info("Rename keys [{}]", (Object)renameKeyBool);
            if (renameKeyBool) {
                this.renameKeys();
            }
            if ((putExpiry = this.properties.getProperty("presignedHttpUploadURIExpirySeconds")) != null) {
                this.setHttpUploadURIExpirySeconds(Integer.parseInt(putExpiry));
            }
            if ((getExpiry = this.properties.getProperty("presignedHttpDownloadURIExpirySeconds")) != null) {
                int getExpirySeconds = Integer.parseInt(getExpiry);
                this.setHttpDownloadURIExpirySeconds(getExpirySeconds);
                int cacheMaxSize = 0;
                String cacheMaxSizeStr = this.properties.getProperty("presignedHttpDownloadURICacheMaxSize");
                if (cacheMaxSizeStr != null) {
                    cacheMaxSize = Integer.parseInt(cacheMaxSizeStr);
                }
                this.setHttpDownloadURICacheSize(cacheMaxSize);
            }
            this.setBinaryTransferAccelerationEnabled((enablePresignedAccelerationStr = this.properties.getProperty("presignedURIEnableTransferAcceleration")) != null && "true".equals(enablePresignedAccelerationStr));
            this.presignedDownloadURIVerifyExists = PropertiesUtil.toBoolean((Object)this.properties.get("presignedHttpDownloadURIVerifyExists"), (boolean)true);
            this.getOrCreateReferenceKey();
            LOG.debug("S3 Backend initialized in [{}] ms", (Object)(System.currentTimeMillis() - this.startTime.getTime()));
            return;
        }
        catch (Exception e) {
            void var3_9;
            LOG.error("Error ", (Throwable)e);
            HashMap hashMap = new HashMap();
            if (this.properties == null) throw new DataStoreException("Could not initialize S3 from " + String.valueOf(var3_9), (Throwable)e);
            Map map = MapUtils.filterKeys(Utils.asMap(this.properties), input -> !input.equals("accessKey") && !input.equals("secretKey"));
            throw new DataStoreException("Could not initialize S3 from " + String.valueOf(var3_9), (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    private void createBucketIfNeeded(String region) {
        try {
            if (!this.s3service.doesBucketExist(this.bucket)) {
                String bucketRegion = region;
                if ("us-east-1".equals(region)) {
                    bucketRegion = null;
                }
                CreateBucketRequest req = new CreateBucketRequest(this.bucket, bucketRegion);
                this.s3service.createBucket(req);
                if (Utils.waitForBucket((AmazonS3)this.s3service, this.bucket)) {
                    LOG.error("Bucket [{}] does not exist in [{}] and was not automatically created", (Object)this.bucket, (Object)region);
                    return;
                }
                LOG.info("Created bucket [{}] in [{}] ", (Object)this.bucket, (Object)region);
            } else {
                LOG.info("Using bucket [{}] in [{}] ", (Object)this.bucket, (Object)region);
            }
        }
        catch (SdkClientException awsException) {
            LOG.error("Attempt to create S3 bucket [{}] in [{}] failed", new Object[]{this.bucket, region, awsException});
        }
    }

    void setBinaryTransferAccelerationEnabled(boolean enabled) {
        if (enabled) {
            BucketAccelerateConfiguration accelerateConfig = this.s3service.getBucketAccelerateConfiguration(new GetBucketAccelerateConfigurationRequest(this.bucket));
            if (accelerateConfig.isAccelerateEnabled()) {
                this.s3PresignService = Utils.openService(this.properties);
                this.s3PresignService.setS3ClientOptions(S3ClientOptions.builder().setAccelerateModeEnabled(true).build());
                LOG.info("S3 Transfer Acceleration enabled for presigned URIs.");
            } else {
                LOG.warn("S3 Transfer Acceleration is not enabled on the bucket {}. Will create normal, non-accelerated presigned URIs.", (Object)this.bucket, (Object)"presignedURIEnableTransferAcceleration");
            }
        } else {
            this.s3PresignService = this.s3service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataIdentifier identifier, File file) throws DataStoreException {
        long start;
        block15: {
            String key = S3Backend.getKeyName(identifier);
            ObjectMetadata objectMetaData = null;
            start = System.currentTimeMillis();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                block14: {
                    Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                    try {
                        objectMetaData = this.s3service.getObjectMetadata(this.s3ReqDecorator.decorate(new GetObjectMetadataRequest(this.bucket, key)));
                    }
                    catch (AmazonServiceException ase) {
                        if (ase.getStatusCode() == 404 || ase.getStatusCode() == 403) break block14;
                        throw ase;
                    }
                }
                if (objectMetaData != null) {
                    long l = objectMetaData.getContentLength();
                    if (l != file.length()) {
                        throw new DataStoreException("Collision: " + key + " new length: " + file.length() + " old length: " + l);
                    }
                    LOG.debug("[{}]'s exists, lastmodified = [{}]", (Object)key, (Object)objectMetaData.getLastModified().getTime());
                    CopyObjectRequest copReq = new CopyObjectRequest(this.bucket, key, this.bucket, key);
                    LOG.warn("Object MetaData before copy: {}", (Object)objectMetaData.getRawMetadata());
                    if (Objects.equals((Object)RemoteStorageMode.S3, this.properties.get("mode"))) {
                        copReq.setNewObjectMetadata(objectMetaData);
                    }
                    Copy copy = this.tmx.copy(this.s3ReqDecorator.decorate(copReq));
                    try {
                        copy.waitForCopyResult();
                        LOG.debug("lastModified of [{}] updated successfully.", (Object)identifier);
                    }
                    catch (Exception e2) {
                        throw new DataStoreException("Could not upload " + key, (Throwable)e2);
                    }
                }
                if (objectMetaData != null) break block15;
                try {
                    Upload up = this.tmx.upload(this.s3ReqDecorator.decorate(new PutObjectRequest(this.bucket, key, file)));
                    if (LOG_STREAMS_UPLOAD.isDebugEnabled()) {
                        LOG_STREAMS_UPLOAD.debug("Binary uploaded to S3 - identifier={}", (Object)key, (Object)new Exception());
                    }
                    up.waitForUploadResult();
                    LOG.debug("synchronous upload to identifier [{}] completed.", (Object)identifier);
                }
                catch (Exception e2) {
                    throw new DataStoreException("Could not upload " + key, (Throwable)e2);
                }
            }
            finally {
                if (contextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            }
        }
        LOG.debug("write of [{}], length=[{}], in [{}]ms", new Object[]{identifier, file.length(), System.currentTimeMillis() - start});
    }

    public boolean exists(DataIdentifier identifier) throws DataStoreException {
        long start = System.currentTimeMillis();
        String key = S3Backend.getKeyName(identifier);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            ObjectMetadata objectMetaData = this.s3service.getObjectMetadata(this.s3ReqDecorator.decorate(new GetObjectMetadataRequest(this.bucket, key)));
            if (objectMetaData != null) {
                LOG.trace("exists [{}]: [true] took [{}] ms.", (Object)identifier, (Object)(System.currentTimeMillis() - start));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404 || e.getStatusCode() == 403) {
                LOG.debug("exists [{}]: [false] took [{}] ms.", (Object)identifier, (Object)(System.currentTimeMillis() - start));
                boolean bl = false;
                return bl;
            }
            throw new DataStoreException("Error occured to getObjectMetadata for key [" + identifier.toString() + "]", (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public InputStream read(DataIdentifier identifier) throws DataStoreException {
        long start = System.currentTimeMillis();
        String key = S3Backend.getKeyName(identifier);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            S3Object object = this.s3service.getObject(this.bucket, key);
            S3ObjectInputStream in = object.getObjectContent();
            LOG.debug("[{}] read took [{}]ms", (Object)identifier, (Object)(System.currentTimeMillis() - start));
            if (LOG_STREAMS_DOWNLOAD.isDebugEnabled()) {
                LOG_STREAMS_DOWNLOAD.debug("Binary downloaded from S3 - identifier={}", (Object)key, (Object)new Exception());
            }
            S3ObjectInputStream s3ObjectInputStream = in;
            return s3ObjectInputStream;
        }
        catch (AmazonServiceException e) {
            throw new DataStoreException("Object not found: " + key, (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        return new RecordsIterator<DataIdentifier>(input -> new DataIdentifier(S3Backend.getIdentifierName(input.getKey())));
    }

    public void deleteRecord(DataIdentifier identifier) throws DataStoreException {
        long start = System.currentTimeMillis();
        String key = S3Backend.getKeyName(identifier);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.s3service.deleteObject(this.bucket, key);
            LOG.debug("Identifier [{}] deleted. It took [{}]ms.", new Object[]{identifier, System.currentTimeMillis() - start});
        }
        catch (AmazonServiceException e) {
            throw new DataStoreException("Could not delete dataIdentifier " + String.valueOf(identifier), (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public void close() {
        if (this.s3service.doesBucketExist(this.bucket)) {
            this.tmx.abortMultipartUploads(this.bucket, this.startTime);
        }
        this.tmx.shutdownNow();
        this.s3service.shutdown();
        LOG.info("S3Backend closed.");
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        this.setRemoteStorageMode();
    }

    private void setRemoteStorageMode() {
        String s3EndPoint = this.properties.getProperty("s3EndPoint", "");
        if (s3EndPoint.contains("googleapis")) {
            if (this.properties.get("mode") == RemoteStorageMode.S3) {
                LOG.warn("Mismatch between remote storage mode and s3EndPoint, overriding mode to GCP");
            }
            this.properties.put("mode", (Object)RemoteStorageMode.GCP);
            return;
        }
        this.properties.put("mode", (Object)RemoteStorageMode.S3);
    }

    public void addMetadataRecord(InputStream input, String name) throws DataStoreException {
        Validate.checkArgument((input != null ? 1 : 0) != 0, (String)"input should not be null");
        Validate.checkArgument((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (String)"name should not be empty");
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Upload upload = this.tmx.upload(this.s3ReqDecorator.decorate(new PutObjectRequest(this.bucket, S3Backend.addMetaKeyPrefix(name), input, new ObjectMetadata())));
            upload.waitForUploadResult();
        }
        catch (InterruptedException e) {
            LOG.error("Error in uploading", (Throwable)e);
            throw new DataStoreException("Error in uploading", (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public void addMetadataRecord(File input, String name) throws DataStoreException {
        Validate.checkArgument((input != null ? 1 : 0) != 0, (String)"input should not be null");
        Validate.checkArgument((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (String)"name should not be empty");
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Upload upload = this.tmx.upload(this.s3ReqDecorator.decorate(new PutObjectRequest(this.bucket, S3Backend.addMetaKeyPrefix(name), input)));
            upload.waitForUploadResult();
        }
        catch (InterruptedException e) {
            LOG.error("Exception in uploading metadata file {}", new Object[]{input, e});
            throw new DataStoreException("Error in uploading metadata file", (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRecord getMetadataRecord(String name) {
        Validate.checkArgument((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (String)"name should not be empty");
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            ObjectMetadata meta = this.s3service.getObjectMetadata(this.bucket, S3Backend.addMetaKeyPrefix(name));
            S3DataRecord s3DataRecord = new S3DataRecord(this, this.s3service, this.bucket, new DataIdentifier(name), meta.getLastModified().getTime(), meta.getContentLength(), true, this.s3ReqDecorator);
            return s3DataRecord;
        }
        catch (Exception e) {
            LOG.error("Error getting metadata record for {}", (Object)name, (Object)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataRecord> getAllMetadataRecords(String prefix) {
        Validate.checkArgument((null != prefix ? 1 : 0) != 0, (String)"prefix should not be null");
        ArrayList<DataRecord> metadataList = new ArrayList<DataRecord>();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucket).withPrefix(S3Backend.addMetaKeyPrefix(prefix));
            ObjectListing prevObjectListing = this.s3service.listObjects(listObjectsRequest);
            for (S3ObjectSummary s3ObjSumm : prevObjectListing.getObjectSummaries()) {
                metadataList.add((DataRecord)new S3DataRecord(this, this.s3service, this.bucket, new DataIdentifier(S3Backend.stripMetaKeyPrefix(s3ObjSumm.getKey())), s3ObjSumm.getLastModified().getTime(), s3ObjSumm.getSize(), true, this.s3ReqDecorator));
            }
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        return metadataList;
    }

    public boolean deleteMetadataRecord(String name) {
        Validate.checkArgument((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (String)"name should not be empty");
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.s3service.deleteObject(this.bucket, S3Backend.addMetaKeyPrefix(name));
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllMetadataRecords(String prefix) {
        Validate.checkArgument((null != prefix ? 1 : 0) != 0, (String)"prefix should not be empty");
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucket).withPrefix(S3Backend.addMetaKeyPrefix(prefix));
            ObjectListing metaList = this.s3service.listObjects(listObjectsRequest);
            ArrayList<DeleteObjectsRequest.KeyVersion> deleteList = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            ArrayList<String> keysToDelete = new ArrayList<String>();
            for (S3ObjectSummary s3ObjSumm : metaList.getObjectSummaries()) {
                deleteList.add(new DeleteObjectsRequest.KeyVersion(s3ObjSumm.getKey()));
                keysToDelete.add(s3ObjSumm.getKey());
            }
            if (!deleteList.isEmpty()) {
                RemoteStorageMode mode = (RemoteStorageMode)((Object)this.properties.getOrDefault((Object)"mode", (Object)RemoteStorageMode.S3));
                if (mode == RemoteStorageMode.S3) {
                    DeleteObjectsRequest delObjsReq = new DeleteObjectsRequest(this.bucket);
                    delObjsReq.setKeys(deleteList);
                    this.s3service.deleteObjects(delObjsReq);
                } else {
                    keysToDelete.forEach(key -> this.s3service.deleteObject(this.bucket, key));
                }
            }
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public Iterator<DataRecord> getAllRecords() {
        S3Backend backend = this;
        return new RecordsIterator<DataRecord>(input -> new S3DataRecord(backend, this.s3service, this.bucket, new DataIdentifier(S3Backend.getIdentifierName(input.getKey())), input.getLastModified().getTime(), input.getSize(), this.s3ReqDecorator));
    }

    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        long start = System.currentTimeMillis();
        String key = S3Backend.getKeyName(identifier);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            ObjectMetadata object = this.s3service.getObjectMetadata(this.s3ReqDecorator.decorate(new GetObjectMetadataRequest(this.bucket, key)));
            S3DataRecord record = new S3DataRecord(this, this.s3service, this.bucket, identifier, object.getLastModified().getTime(), object.getContentLength(), this.s3ReqDecorator);
            LOG.debug("Identifier [{}]'s getRecord = [{}] took [{}]ms.", new Object[]{identifier, record, System.currentTimeMillis() - start});
            S3DataRecord s3DataRecord = record;
            return s3DataRecord;
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404 || e.getStatusCode() == 403) {
                LOG.debug("getRecord:Identifier [{}] not found. Took [{}] ms.", (Object)identifier, (Object)(System.currentTimeMillis() - start));
            }
            throw new DataStoreException((Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public byte[] getOrCreateReferenceKey() throws DataStoreException {
        try {
            byte[] key;
            if (this.secret != null && this.secret.length != 0) {
                return this.secret;
            }
            if (this.metadataRecordExists(REF_KEY)) {
                key = this.readMetadataBytes(REF_KEY);
            } else {
                key = super.getOrCreateReferenceKey();
                this.addMetadataRecord(new ByteArrayInputStream(key), REF_KEY);
                key = this.readMetadataBytes(REF_KEY);
            }
            this.secret = key;
            return this.secret;
        }
        catch (IOException e) {
            throw new DataStoreException("Unable to get or create key " + String.valueOf(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readMetadataBytes(String name) throws IOException, DataStoreException {
        DataRecord rec = this.getMetadataRecord(name);
        InputStream stream = null;
        try {
            stream = rec.getStream();
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean metadataRecordExists(String name) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            boolean bl = this.s3service.doesObjectExist(this.bucket, S3Backend.addMetaKeyPrefix(name));
            return bl;
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    void setHttpUploadURIExpirySeconds(int seconds) {
        this.httpUploadURIExpirySeconds = seconds;
    }

    private DataIdentifier generateSafeRandomIdentifier() {
        return new DataIdentifier(String.format("%s-%d", UUID.randomUUID().toString(), Instant.now().toEpochMilli()));
    }

    private URI createPresignedPutURI(DataIdentifier identifier) {
        if (this.httpUploadURIExpirySeconds <= 0) {
            return null;
        }
        return this.createPresignedURI(identifier, HttpMethod.PUT, this.httpUploadURIExpirySeconds);
    }

    void setHttpDownloadURIExpirySeconds(int seconds) {
        this.httpDownloadURIExpirySeconds = seconds;
    }

    void setHttpDownloadURICacheSize(int maxSize) {
        if (maxSize > 0) {
            LOG.info("presigned GET URI cache enabled, maxSize = {} items, expiry = {} seconds", (Object)maxSize, (Object)(this.httpDownloadURIExpirySeconds / 2));
            this.httpDownloadURICache = CacheBuilder.newBuilder().maximumSize((long)maxSize).expireAfterWrite((long)(this.httpDownloadURIExpirySeconds / 2), TimeUnit.SECONDS).build();
        } else {
            LOG.info("presigned GET URI cache disabled");
            this.httpDownloadURICache = null;
        }
    }

    URI createHttpDownloadURI(@NotNull DataIdentifier identifier, @NotNull DataRecordDownloadOptions downloadOptions) {
        if (this.httpDownloadURIExpirySeconds <= 0) {
            return null;
        }
        if (null == identifier) {
            throw new NullPointerException("identifier");
        }
        if (null == downloadOptions) {
            throw new NullPointerException("downloadOptions");
        }
        URI uri = null;
        if (this.httpDownloadURICache != null) {
            uri = (URI)this.httpDownloadURICache.getIfPresent((Object)identifier);
        }
        if (null == uri) {
            String contentDisposition;
            if (this.presignedDownloadURIVerifyExists) {
                try {
                    if (!this.exists(identifier)) {
                        LOG.warn("Cannot create download URI for nonexistent blob {}; returning null", (Object)S3Backend.getKeyName(identifier));
                        return null;
                    }
                }
                catch (DataStoreException e) {
                    LOG.warn("Cannot create download URI for blob {} (caught DataStoreException); returning null", (Object)S3Backend.getKeyName(identifier), (Object)e);
                    return null;
                }
            }
            HashMap<String, String> requestParams = new HashMap<String, String>();
            requestParams.put("response-cache-control", String.format("private, max-age=%d, immutable", this.httpDownloadURIExpirySeconds));
            String contentType = downloadOptions.getContentTypeHeader();
            if (!StringUtils.isEmpty((CharSequence)contentType)) {
                requestParams.put("response-content-type", contentType);
            }
            if (!StringUtils.isEmpty((CharSequence)(contentDisposition = downloadOptions.getContentDispositionHeader()))) {
                requestParams.put("response-content-disposition", contentDisposition);
            }
            if ((uri = this.createPresignedURI(identifier, HttpMethod.GET, this.httpDownloadURIExpirySeconds, requestParams)) != null && this.httpDownloadURICache != null) {
                this.httpDownloadURICache.put((Object)identifier, (Object)uri);
            }
        }
        return uri;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DataRecordUpload initiateHttpUpload(long maxUploadSizeInBytes, int maxNumberOfURIs) {
        final ArrayList<URI> uploadPartURIs = new ArrayList<URI>();
        final long minPartSize = 0xA00000L;
        final long maxPartSize = 0x10000000L;
        if (0L >= maxUploadSizeInBytes) {
            throw new IllegalArgumentException("maxUploadSizeInBytes must be > 0");
        }
        if (0 == maxNumberOfURIs) {
            throw new IllegalArgumentException("maxNumberOfURIs must either be > 0 or -1");
        }
        if (-1 > maxNumberOfURIs) {
            throw new IllegalArgumentException("maxNumberOfURIs must either be > 0 or -1");
        }
        if (maxUploadSizeInBytes > 0x140000000L && maxNumberOfURIs == 1) {
            throw new IllegalArgumentException(String.format("Cannot do single-put upload with file size %d - exceeds max single-put upload size of %d", maxUploadSizeInBytes, 0x140000000L));
        }
        if (maxUploadSizeInBytes > 0x50000000000L) {
            throw new IllegalArgumentException(String.format("Cannot do upload with file size %d - exceeds max upload size of %d", maxUploadSizeInBytes, 0x50000000000L));
        }
        DataIdentifier newIdentifier = this.generateSafeRandomIdentifier();
        String blobId = S3Backend.getKeyName(newIdentifier);
        String uploadId = null;
        if (this.httpUploadURIExpirySeconds <= 0) return null;
        if (maxNumberOfURIs == 1 || maxUploadSizeInBytes <= minPartSize) {
            uploadPartURIs.add(this.createPresignedPutURI(newIdentifier));
        } else {
            long numParts;
            InitiateMultipartUploadRequest req = new InitiateMultipartUploadRequest(this.bucket, blobId);
            InitiateMultipartUploadResult res = this.s3service.initiateMultipartUpload(this.s3ReqDecorator.decorate(req));
            uploadId = res.getUploadId();
            if (maxNumberOfURIs > 1) {
                long requestedPartSize = (long)Math.ceil((double)maxUploadSizeInBytes / (double)maxNumberOfURIs);
                if (requestedPartSize > maxPartSize) throw new IllegalArgumentException(String.format("Cannot do multi-part upload with requested part size %d", requestedPartSize));
                numParts = Math.min((long)maxNumberOfURIs, Math.min((long)Math.ceil((double)maxUploadSizeInBytes / (double)minPartSize), 10000L));
            } else {
                long maximalNumParts = (long)Math.ceil((double)maxUploadSizeInBytes / 1.048576E7);
                numParts = Math.min(maximalNumParts, 10000L);
            }
            HashMap<String, String> presignedURIRequestParams = new HashMap<String, String>();
            for (long blockId = 1L; blockId <= numParts; ++blockId) {
                presignedURIRequestParams.put(PART_NUMBER, String.valueOf(blockId));
                presignedURIRequestParams.put(UPLOAD_ID, uploadId);
                uploadPartURIs.add(this.createPresignedURI(newIdentifier, HttpMethod.PUT, this.httpUploadURIExpirySeconds, presignedURIRequestParams));
            }
        }
        try {
            byte[] secret = this.getOrCreateReferenceKey();
            final String uploadToken = new DataRecordUploadToken(blobId, uploadId).getEncodedToken(secret);
            return new DataRecordUpload(){

                @NotNull
                public String getUploadToken() {
                    return uploadToken;
                }

                public long getMinPartSize() {
                    return minPartSize;
                }

                public long getMaxPartSize() {
                    return maxPartSize;
                }

                @NotNull
                public Collection<URI> getUploadURIs() {
                    return uploadPartURIs;
                }
            };
        }
        catch (DataStoreException e) {
            LOG.warn("Unable to obtain data store key");
        }
        return null;
    }

    DataRecord completeHttpUpload(@NotNull String uploadTokenStr) throws DataRecordUploadException, DataStoreException {
        if (StringUtils.isEmpty((CharSequence)uploadTokenStr)) {
            throw new IllegalArgumentException("uploadToken required");
        }
        DataRecordUploadToken uploadToken = DataRecordUploadToken.fromEncodedToken((String)uploadTokenStr, (byte[])this.getOrCreateReferenceKey());
        String key = uploadToken.getBlobId();
        DataIdentifier blobId = new DataIdentifier(S3Backend.getIdentifierName(key));
        Object record = null;
        try {
            record = this.getRecord(blobId);
        }
        catch (DataStoreException e) {
            if (uploadToken.getUploadId().isPresent()) {
                String uploadId = (String)uploadToken.getUploadId().get();
                ListPartsRequest listPartsRequest = new ListPartsRequest(this.bucket, key, uploadId);
                PartListing listing = this.s3service.listParts(listPartsRequest);
                ArrayList<PartETag> eTags = new ArrayList<PartETag>();
                long size = 0L;
                Date lastModified = null;
                for (PartSummary partSummary : listing.getParts()) {
                    PartETag eTag = new PartETag(partSummary.getPartNumber(), partSummary.getETag());
                    eTags.add(eTag);
                    size += partSummary.getSize();
                    if (null != lastModified && !partSummary.getLastModified().after(lastModified)) continue;
                    lastModified = partSummary.getLastModified();
                }
                CompleteMultipartUploadRequest completeReq = new CompleteMultipartUploadRequest(this.bucket, key, uploadId, eTags);
                this.s3service.completeMultipartUpload(completeReq);
                record = new S3DataRecord(this, this.s3service, this.bucket, blobId, lastModified.getTime(), size, this.s3ReqDecorator);
            }
            throw new DataRecordUploadException(String.format("Unable to finalize direct write of binary %s - upload ID missing from upload token", blobId));
        }
        return record;
    }

    private URI createPresignedURI(DataIdentifier identifier, HttpMethod method, int expirySeconds) {
        return this.createPresignedURI(identifier, method, expirySeconds, new HashMap<String, String>());
    }

    private URI createPresignedURI(DataIdentifier identifier, HttpMethod method, int expirySeconds, Map<String, String> reqParams) {
        String key = S3Backend.getKeyName(identifier);
        try {
            Date expiration = new Date();
            expiration.setTime(expiration.getTime() + (long)(expirySeconds * 1000));
            GeneratePresignedUrlRequest request = this.s3ReqDecorator.decorate(new GeneratePresignedUrlRequest(this.bucket, key).withMethod(method).withExpiration(expiration));
            for (Map.Entry<String, String> e : reqParams.entrySet()) {
                request.addRequestParameter(e.getKey(), e.getValue());
            }
            URI uri = null;
            URL presignedURL = null;
            try {
                presignedURL = this.s3PresignService.generatePresignedUrl(request);
                uri = presignedURL.toURI();
                LOG.debug("Presigned {} URI for key {}: {}", new Object[]{method.name(), key, uri.toString()});
            }
            catch (URISyntaxException e) {
                LOG.error("AWS request to create presigned S3 URI failed - could not convert '{}' to URI", (Object)(null != presignedURL ? presignedURL.toString() : ""));
            }
            return uri;
        }
        catch (AmazonServiceException e) {
            LOG.error("AWS request to create presigned S3 {} URI failed. Key: {}, Error: {}, HTTP Code: {}, AWS Error Code: {}, Error Type: {}, Request ID: {}", new Object[]{method.name(), key, e.getMessage(), e.getStatusCode(), e.getErrorCode(), e.getErrorType(), e.getRequestId()});
            return null;
        }
    }

    private static String addMetaKeyPrefix(String key) {
        return META_KEY_PREFIX + key;
    }

    private static String stripMetaKeyPrefix(String name) {
        if (name.startsWith(META_KEY_PREFIX)) {
            return name.substring(META_KEY_PREFIX.length());
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameKeys() throws DataStoreException {
        block12: {
            long startTime = System.currentTimeMillis();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            long count = 0L;
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                ObjectListing prevObjectListing = this.s3service.listObjects(this.bucket);
                ArrayList<DeleteObjectsRequest.KeyVersion> deleteList = new ArrayList<DeleteObjectsRequest.KeyVersion>();
                ArrayList<String> keysToDelete = new ArrayList<String>();
                int nThreads = Integer.parseInt(this.properties.getProperty("maxConnections"));
                ExecutorService executor = Executors.newFixedThreadPool(nThreads, (ThreadFactory)new NamedThreadFactory("s3-object-rename-worker"));
                boolean taskAdded = false;
                while (true) {
                    for (S3ObjectSummary s3ObjSumm : prevObjectListing.getObjectSummaries()) {
                        executor.execute(new KeyRenameThread(s3ObjSumm.getKey()));
                        taskAdded = true;
                        ++count;
                        if (!s3ObjSumm.getKey().startsWith(KEY_PREFIX)) continue;
                        deleteList.add(new DeleteObjectsRequest.KeyVersion(s3ObjSumm.getKey()));
                        keysToDelete.add(s3ObjSumm.getKey());
                    }
                    if (!prevObjectListing.isTruncated()) break;
                    prevObjectListing = this.s3service.listNextBatchOfObjects(prevObjectListing);
                }
                executor.shutdown();
                try {
                    while (taskAdded && !executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                        LOG.info("Rename S3 keys tasks timedout. Waiting again");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LOG.info("Renamed [{}] keys, time taken [{}]sec", (Object)count, (Object)((System.currentTimeMillis() - startTime) / 1000L));
                if (deleteList.isEmpty()) break block12;
                RemoteStorageMode mode = (RemoteStorageMode)((Object)this.properties.getOrDefault((Object)"mode", (Object)RemoteStorageMode.S3));
                if (mode == RemoteStorageMode.S3) {
                    DeleteObjectsRequest delObjsReq = new DeleteObjectsRequest(this.bucket);
                    int batchSize = 500;
                    int startIndex = 0;
                    int size = deleteList.size();
                    int endIndex = Math.min(batchSize, size);
                    while (endIndex <= size) {
                        delObjsReq.setKeys(Collections.unmodifiableList(deleteList.subList(startIndex, endIndex)));
                        DeleteObjectsResult dobjs = this.s3service.deleteObjects(delObjsReq);
                        LOG.info("Records[{}] deleted in datastore from index [{}] to [{}]", new Object[]{dobjs.getDeletedObjects().size(), startIndex, endIndex - 1});
                        if (endIndex == size) {
                            break block12;
                        }
                        startIndex = endIndex;
                        endIndex = Math.min(startIndex + batchSize, size);
                    }
                    break block12;
                }
                long keysDeleteStartTime = System.currentTimeMillis();
                keysToDelete.forEach(key -> this.s3service.deleteObject(this.bucket, key));
                LOG.debug("Delete operation for rename keys from gcp took: {} seconds", (Object)((System.currentTimeMillis() - keysDeleteStartTime) / 1000L));
            }
            finally {
                if (contextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            }
        }
    }

    private static String convertKey(String oldKey) throws IllegalArgumentException {
        if (!oldKey.startsWith(KEY_PREFIX)) {
            return oldKey;
        }
        String key = oldKey.substring(KEY_PREFIX.length());
        return key.substring(0, 4) + "-" + key.substring(4);
    }

    private static String getKeyName(DataIdentifier identifier) {
        String key = identifier.toString();
        return key.substring(0, 4) + "-" + key.substring(4);
    }

    private static String getIdentifierName(String key) {
        if (!key.contains("-")) {
            return null;
        }
        if (key.contains(META_KEY_PREFIX)) {
            return key;
        }
        return key.substring(0, 4) + key.substring(5);
    }

    static enum RemoteStorageMode {
        S3,
        GCP;

    }

    private class KeyRenameThread
    implements Runnable {
        private String oldKey;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                String newS3Key = S3Backend.convertKey(this.oldKey);
                CopyObjectRequest copReq = new CopyObjectRequest(S3Backend.this.bucket, this.oldKey, S3Backend.this.bucket, newS3Key);
                Copy copy = S3Backend.this.tmx.copy(S3Backend.this.s3ReqDecorator.decorate(copReq));
                try {
                    copy.waitForCopyResult();
                    LOG.debug("[{}] renamed to [{}] ", (Object)this.oldKey, (Object)newS3Key);
                }
                catch (InterruptedException ie) {
                    LOG.error(" Exception in renaming [{}] to [{}] ", new Object[]{ie, this.oldKey, newS3Key});
                }
            }
            finally {
                if (contextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            }
        }

        public KeyRenameThread(String oldKey) {
            this.oldKey = oldKey;
        }
    }

    static class S3DataRecord
    extends AbstractDataRecord {
        private AmazonS3Client s3service;
        private long length;
        private long lastModified;
        private String bucket;
        private boolean isMeta;
        private final S3RequestDecorator s3ReqDecorator;

        public S3DataRecord(AbstractSharedBackend backend, AmazonS3Client s3service, String bucket, DataIdentifier key, long lastModified, long length, S3RequestDecorator s3ReqDecorator) {
            this(backend, s3service, bucket, key, lastModified, length, false, s3ReqDecorator);
        }

        public S3DataRecord(AbstractSharedBackend backend, AmazonS3Client s3service, String bucket, DataIdentifier key, long lastModified, long length, boolean isMeta, S3RequestDecorator s3ReqDecorator) {
            super(backend, key);
            this.s3service = s3service;
            this.lastModified = lastModified;
            this.length = length;
            this.bucket = bucket;
            this.isMeta = isMeta;
            this.s3ReqDecorator = s3ReqDecorator;
        }

        public long getLength() throws DataStoreException {
            return this.length;
        }

        public InputStream getStream() throws DataStoreException {
            String id = S3Backend.getKeyName(this.getIdentifier());
            if (this.isMeta) {
                id = S3Backend.addMetaKeyPrefix(this.getIdentifier().toString());
                return this.s3service.getObject(this.bucket, id).getObjectContent();
            }
            if (LOG_STREAMS_DOWNLOAD.isDebugEnabled()) {
                LOG_STREAMS_DOWNLOAD.debug("Binary downloaded from S3 - identifier={}", (Object)id, (Object)new Exception());
            }
            return this.s3service.getObject(this.s3ReqDecorator.decorate(new GetObjectRequest(this.bucket, id))).getObjectContent();
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public String toString() {
            return "S3DataRecord{identifier=" + String.valueOf(this.getIdentifier()) + ", length=" + this.length + ", lastModified=" + this.lastModified + ", bucket='" + this.bucket + "'}";
        }
    }

    class RecordsIterator<T>
    extends AbstractIterator<T> {
        ObjectListing prevObjectListing;
        Queue<S3ObjectSummary> queue = new LinkedList<S3ObjectSummary>();
        long size;
        Function<S3ObjectSummary, T> transformer;

        public RecordsIterator(Function<S3ObjectSummary, T> transformer) {
            this.transformer = transformer;
        }

        protected T computeNext() {
            if (this.queue.isEmpty()) {
                this.loadBatch();
            }
            while (this.queue.isEmpty() && this.prevObjectListing.getNextMarker() != null) {
                LOG.debug("Queue is empty, but there is more data in the S3 bucket");
                this.loadBatch();
            }
            if (!this.queue.isEmpty()) {
                return this.transformer.apply(this.queue.remove());
            }
            return (T)this.endOfData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean loadBatch() {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            long start = System.currentTimeMillis();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                if (this.prevObjectListing == null) {
                    ListObjectsRequest listReq = new ListObjectsRequest();
                    listReq.withBucketName(S3Backend.this.bucket);
                    if (S3Backend.this.properties.containsKey("maxKeys")) {
                        listReq.setMaxKeys(Integer.valueOf(S3Backend.this.properties.getProperty("maxKeys")));
                    }
                    this.prevObjectListing = S3Backend.this.s3service.listObjects(listReq);
                } else if (this.prevObjectListing.isTruncated()) {
                    this.prevObjectListing = S3Backend.this.s3service.listNextBatchOfObjects(this.prevObjectListing);
                } else {
                    boolean listReq = false;
                    return listReq;
                }
                List listing = ListUtils.toList((Iterable)IterableUtils.filter((Iterable)this.prevObjectListing.getObjectSummaries(), input -> !input.getKey().startsWith(S3Backend.META_KEY_PREFIX)));
                if (listing.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                this.size += (long)listing.size();
                this.queue.addAll(listing);
                LOG.info("Loaded batch of size [{}] in [{}] ms.", (Object)listing.size(), (Object)(System.currentTimeMillis() - start));
                boolean bl = true;
                return bl;
            }
            catch (AmazonServiceException e) {
                LOG.warn("Could not list objects", (Throwable)e);
            }
            finally {
                if (contextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            }
            return false;
        }
    }
}

