/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.identifier.AbstractIdFactory;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;

class IdFactoryImpl
extends AbstractIdFactory {
    private static final IdFactory INSTANCE = new IdFactoryImpl();

    private IdFactoryImpl() {
    }

    public static IdFactory getInstance() {
        return INSTANCE;
    }

    protected PathFactory getPathFactory() {
        return PathFactoryImpl.getInstance();
    }

    public NodeId createNodeId(Node node, NamePathResolver resolver) throws RepositoryException {
        PathBuilder builder = new PathBuilder();
        boolean pathElements = false;
        String uniqueId = node.getIdentifier();
        return this.createNodeId(uniqueId);
    }

    public PropertyId createPropertyId(Property property, NamePathResolver resolver) throws RepositoryException {
        Name name;
        Node parent = property.getParent();
        NodeId nodeId = this.createNodeId(parent, resolver);
        String jcrName = property.getName();
        try {
            name = resolver.getQName(jcrName);
        }
        catch (NameException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        return this.createPropertyId(nodeId, name);
    }
}

