/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi;

import java.util.Arrays;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.AbstractSPITest;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.SessionInfo;

public class RepositoryServiceTest
extends AbstractSPITest {
    private RepositoryService service;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.service = helper.getRepositoryService();
    }

    public void testGetIdFactory() throws RepositoryException {
        RepositoryServiceTest.assertNotNull((Object)this.service.getIdFactory());
    }

    public void testGetQValueFactory() throws RepositoryException {
        RepositoryServiceTest.assertNotNull((Object)this.service.getQValueFactory());
    }

    public void testGetNameFactory() throws RepositoryException {
        RepositoryServiceTest.assertNotNull((Object)this.service.getNameFactory());
    }

    public void testGetPathFactory() throws RepositoryException {
        RepositoryServiceTest.assertNotNull((Object)this.service.getPathFactory());
    }

    public void testGetRepositoryDescriptors() throws RepositoryException {
        Map descriptors = this.service.getRepositoryDescriptors();
        RepositoryServiceTest.assertNotNull((Object)descriptors);
        RepositoryServiceTest.assertTrue((!descriptors.isEmpty() ? 1 : 0) != 0);
    }

    public void testGetWorkspaceNames() throws RepositoryException {
        String[] workspaceNames = this.service.getWorkspaceNames(this.sessionInfo);
        RepositoryServiceTest.assertNotNull((String)"Workspace names must not be null", (Object)workspaceNames);
        RepositoryServiceTest.assertTrue((String)"Workspace names must contain at least a single workspace", (workspaceNames.length > 0 ? 1 : 0) != 0);
        String wspName = this.getProperty("workspacename");
        if (wspName != null) {
            RepositoryServiceTest.assertTrue((String)"Workspace name used for retrieving the SessionInfo must be included in the available workspaces.", (boolean)Arrays.asList(workspaceNames).contains(wspName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullWorkspaceName() throws RepositoryException {
        SessionInfo sInfo = this.service.obtain(helper.getAdminCredentials(), null);
        try {
            RepositoryServiceTest.assertNotNull((Object)sInfo.getWorkspaceName());
        }
        finally {
            this.service.dispose(sInfo);
        }
    }
}

