/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.spi.AbstractSPITest;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QValueTest
extends AbstractSPITest {
    private static Logger log = LoggerFactory.getLogger(QValueTest.class);
    private final Calendar CALENDAR = Calendar.getInstance();
    protected Path rootPath;
    protected Name testName;
    protected String reference;
    protected QValueFactory factory;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        RepositoryService service = helper.getRepositoryService();
        this.factory = service.getQValueFactory();
        this.rootPath = service.getPathFactory().getRootPath();
        this.testName = service.getNameFactory().create("http://www.jcp.org/jcr/1.0", "data");
        this.reference = this.getProperty("reference");
    }

    public void testIllegalType() throws RepositoryException {
        try {
            this.factory.create("any", 54);
            QValueTest.fail((String)"54 is not a valid property type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateInvalidDoubleValue() throws RepositoryException {
        try {
            this.factory.create("any", 4);
            QValueTest.fail((String)"'any' cannot be converted to a valid double value.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDoubleOnBooleanValue() throws RepositoryException {
        try {
            QValue v = this.factory.create(true);
            v.getDouble();
            QValueTest.fail((String)"'true' cannot be converted to a valid double value.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testCreateInvalidLongValue() throws RepositoryException {
        try {
            this.factory.create("any", 3);
            QValueTest.fail((String)"'any' cannot be converted to a valid long value.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetLongOnBooleanValue() throws RepositoryException {
        try {
            QValue v = this.factory.create(true);
            v.getLong();
            QValueTest.fail((String)"'true' cannot be converted to a valid long value.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testFinalBooleanValue() throws RepositoryException {
        QValueTest.assertSame((Object)this.factory.create(true), (Object)this.factory.create(Boolean.TRUE.toString(), 6));
        QValueTest.assertSame((Object)this.factory.create(true), (Object)this.factory.create(true));
        QValueTest.assertSame((Object)this.factory.create(false), (Object)this.factory.create(Boolean.FALSE.toString(), 6));
        QValueTest.assertSame((Object)this.factory.create(false), (Object)this.factory.create(false));
    }

    public void testCreateBooleanValueFromString() throws RepositoryException {
        QValue v = this.factory.create(Boolean.TRUE.toString(), 6);
        QValueTest.assertEquals((String)"Creating boolean type QValue from boolean or String must be equal.", (Object)this.factory.create(true), (Object)v);
        v = this.factory.create(Boolean.FALSE.toString(), 6);
        QValueTest.assertEquals((String)"Creating boolean type QValue from boolean or String must be equal.", (Object)this.factory.create(false), (Object)v);
    }

    public void testCreateTrueBooleanValue() throws RepositoryException {
        QValue v = this.factory.create(true);
        QValueTest.assertEquals((String)"Boolean value must be true", (String)Boolean.TRUE.toString(), (String)v.getString());
        QValueTest.assertEquals((String)"Boolean value must be true", (boolean)true, (boolean)v.getBoolean());
    }

    public void testCreateFalseBooleanValue() throws RepositoryException {
        QValue v = this.factory.create(false);
        QValueTest.assertEquals((String)"Boolean value must be false", (String)Boolean.FALSE.toString(), (String)v.getString());
        QValueTest.assertEquals((String)"Boolean value must be false", (boolean)false, (boolean)v.getBoolean());
    }

    public void testCreateTrueFromString() throws ValueFormatException, RepositoryException {
        QValue v = this.factory.create(Boolean.TRUE.toString(), 1);
        QValueTest.assertEquals((String)"Boolean value must be true", (boolean)true, (boolean)v.getBoolean());
    }

    public void testCreateFalseFromString() throws ValueFormatException, RepositoryException {
        QValue v = this.factory.create("any", 1);
        QValueTest.assertEquals((String)"Boolean value must be false", (boolean)false, (boolean)v.getBoolean());
    }

    public void testReadBooleanAsLong() throws RepositoryException {
        try {
            QValue v = this.factory.create(true);
            v.getLong();
        }
        catch (ValueFormatException e) {
            return;
        }
        QValueTest.assertTrue((String)"Cannot convert value to long", (boolean)false);
    }

    public void testNullDateValue() throws IOException, RepositoryException {
        try {
            this.factory.create((Calendar)null);
            QValueTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.factory.create(null, 5);
            QValueTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testDateValueType() throws RepositoryException {
        QValue v = this.factory.create(this.CALENDAR);
        QValueTest.assertTrue((String)"Type of a date value must be PropertyType.DATE", (v.getType() == 5 ? 1 : 0) != 0);
    }

    public void testDateValueEquality() throws RepositoryException {
        QValue v = this.factory.create(this.CALENDAR);
        QValue otherV = this.factory.create(this.CALENDAR);
        QValueTest.assertEquals((String)"Equality of date value must be calculated based on their String representation.", (Object)v, (Object)otherV);
    }

    public void testDateValueEquality2() throws RepositoryException {
        QValue v = this.factory.create(this.CALENDAR);
        QValue otherV = this.factory.create(v.getString(), 5);
        QValueTest.assertEquals((String)"Equality of date value must be calculated based on their String representation.", (Object)v, (Object)otherV);
    }

    public void testNullReferenceValue() throws IOException, RepositoryException {
        try {
            this.factory.create(null, 9);
            QValueTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testReferenceValueType() throws RepositoryException {
        if (this.reference != null) {
            QValue v = this.factory.create(this.reference, 9);
            QValueTest.assertTrue((String)"Type of a date value must be PropertyType.REFERENCE.", (v.getType() == 9 ? 1 : 0) != 0);
        } else {
            log.warn("Configuration entry 'QValueFactoryTest.reference' is missing -> skip test 'testReferenceValueType'.");
        }
    }

    public void testReferenceValueEquality() throws RepositoryException {
        if (this.reference != null) {
            QValue v = this.factory.create(this.reference, 9);
            QValue otherV = this.factory.create(this.reference, 9);
            QValueTest.assertEquals((String)"Reference values created from the same string must be equal.", (Object)v, (Object)otherV);
        } else {
            log.warn("Configuration entry 'QValueFactoryTest.reference' is missing -> skip test 'testReferenceValueEquality'.");
        }
    }

    public void testEqualityDifferentTypes() throws RepositoryException {
        if (this.reference != null) {
            QValue v = this.factory.create(this.reference, 9);
            QValue v2 = this.factory.create(this.reference, 1);
            QValueTest.assertFalse((boolean)v.equals(v2));
        } else {
            log.warn("Configuration entry 'QValueFactoryTest.reference' is missing -> skip test 'testEqualityDifferentTypes'.");
        }
    }

    public void testNullNameValue() throws IOException, RepositoryException {
        try {
            this.factory.create((Name)null);
            QValueTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testNameValueType() throws IOException, RepositoryException {
        QValue v = this.factory.create(this.testName);
        QValueTest.assertTrue((v.getType() == 7 ? 1 : 0) != 0);
        v = this.factory.create(this.testName.toString(), 7);
        QValueTest.assertTrue((v.getType() == 7 ? 1 : 0) != 0);
    }

    public void testNameValueEquality() throws IOException, RepositoryException {
        QValue v = this.factory.create(this.testName);
        QValue v2 = this.factory.create(this.testName.toString(), 7);
        QValueTest.assertTrue((boolean)v.equals(v2));
    }

    public void testNameValueGetString() throws IOException, RepositoryException {
        QValue v = this.factory.create(this.testName);
        QValueTest.assertTrue((boolean)v.getString().equals(this.testName.toString()));
    }

    public void testNameValueGetName() throws RepositoryException {
        QValue v = this.factory.create(this.testName);
        QValueTest.assertTrue((boolean)v.getName().equals(this.testName));
    }

    public void testInvalidNameValue() throws RepositoryException {
        try {
            this.factory.create("abc", 7);
            QValueTest.fail((String)"'abc' is not a valid Name -> creating QValue should fail.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testAnyValueGetName() throws RepositoryException {
        try {
            this.factory.create(12345L).getName();
            QValueTest.fail((String)"12345 is not a valid Name value -> QValue.getName() should fail.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testNullPathValue() throws IOException, RepositoryException {
        try {
            this.factory.create((Path)null);
            QValueTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testPathValueType() throws IOException, RepositoryException {
        QValue v = this.factory.create(this.rootPath);
        QValueTest.assertTrue((v.getType() == 8 ? 1 : 0) != 0);
        v = this.factory.create(this.rootPath.toString(), 8);
        QValueTest.assertTrue((v.getType() == 8 ? 1 : 0) != 0);
    }

    public void testPathValueEquality() throws IOException, RepositoryException {
        QValue v = this.factory.create(this.rootPath);
        QValue v2 = this.factory.create(this.rootPath.toString(), 8);
        QValueTest.assertTrue((boolean)v.equals(v2));
    }

    public void testPathValueGetString() throws IOException, RepositoryException {
        QValue v = this.factory.create(this.rootPath);
        QValueTest.assertTrue((boolean)v.getString().equals(this.rootPath.toString()));
    }

    public void testPathValueGetPath() throws RepositoryException {
        QValue v = this.factory.create(this.rootPath);
        QValueTest.assertTrue((boolean)v.getPath().equals(this.rootPath));
    }

    public void testInvalidPathValue() throws RepositoryException {
        try {
            this.factory.create("abc", 8);
            QValueTest.fail((String)"'abc' is not a valid Path -> creating QValue should fail.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testAnyValueGetPath() throws RepositoryException {
        try {
            this.factory.create(12345L).getPath();
            QValueTest.fail((String)"12345 is not a valid Path value -> QValue.getPath() should fail.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testNullBinaryValue() throws IOException, RepositoryException {
        try {
            this.factory.create((byte[])null);
            QValueTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.factory.create((InputStream)null);
            QValueTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.factory.create((File)null);
            QValueTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testBinaryValueType() throws IOException, RepositoryException {
        QValue v = this.factory.create(new byte[]{97, 98, 99});
        QValueTest.assertTrue((v.getType() == 2 ? 1 : 0) != 0);
    }

    public void testBinaryFromByteArray() throws RepositoryException, IOException {
        QValue v = this.factory.create(new byte[]{97, 98, 99});
        QValueTest.assertEquals((int)2, (int)v.getType());
        QValueTest.assertEquals((long)3L, (long)v.getLength());
        QValueTest.assertEquals((String)"abc", (String)v.getString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QValueTest.spool(out, v.getStream());
        QValueTest.assertEquals((String)"abc", (String)new String(out.toByteArray()));
    }

    public void testEmptyBinaryFromByteArray() throws RepositoryException, IOException {
        QValue v = this.factory.create(new byte[0]);
        QValueTest.assertEquals((int)2, (int)v.getType());
        QValueTest.assertEquals((long)0L, (long)v.getLength());
        QValueTest.assertEquals((String)"", (String)v.getString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QValueTest.spool(out, v.getStream());
        QValueTest.assertEquals((String)"", (String)new String(out.toByteArray()));
    }

    public void testBinaryFromInputStream() throws RepositoryException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{97, 98, 99});
        QValue v = this.factory.create((InputStream)in);
        QValueTest.assertEquals((int)2, (int)v.getType());
        QValueTest.assertEquals((long)3L, (long)v.getLength());
        QValueTest.assertEquals((String)"abc", (String)v.getString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QValueTest.spool(out, v.getStream());
        QValueTest.assertEquals((String)"abc", (String)new String(out.toByteArray()));
    }

    public void testEmptyBinaryFromInputStream() throws RepositoryException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[0]);
        QValue v = this.factory.create((InputStream)in);
        QValueTest.assertEquals((int)2, (int)v.getType());
        QValueTest.assertEquals((long)0L, (long)v.getLength());
        QValueTest.assertEquals((String)"", (String)v.getString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QValueTest.spool(out, v.getStream());
        QValueTest.assertEquals((String)"", (String)new String(out.toByteArray()));
    }

    public void testBinaryFromFile() throws RepositoryException, IOException {
        File f = File.createTempFile("QValueFactoryImplTest", ".txt");
        f.deleteOnExit();
        FileWriter fw = new FileWriter(f);
        fw.write("abc");
        fw.close();
        QValue v = this.factory.create(f);
        QValueTest.assertEquals((int)2, (int)v.getType());
        QValueTest.assertEquals((long)3L, (long)v.getLength());
        QValueTest.assertEquals((String)"abc", (String)v.getString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QValueTest.spool(out, v.getStream());
        QValueTest.assertEquals((String)"abc", (String)new String(out.toByteArray()));
    }

    public void testEmptyBinaryFromFile() throws RepositoryException, IOException {
        File f = File.createTempFile("QValueFactoryImplTest", ".txt");
        f.deleteOnExit();
        QValue v = this.factory.create(f);
        QValueTest.assertEquals((int)2, (int)v.getType());
        QValueTest.assertEquals((long)0L, (long)v.getLength());
        QValueTest.assertEquals((String)"", (String)v.getString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QValueTest.spool(out, v.getStream());
        QValueTest.assertEquals((String)"", (String)new String(out.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void spool(OutputStream out, InputStream in) throws RepositoryException, IOException {
        try {
            int read;
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }
}

