/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.RepositoryServiceStub;
import org.apache.jackrabbit.spi.SessionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper {
    private static Logger log = LoggerFactory.getLogger(Helper.class);
    private RepositoryServiceStub repoServiceStub;
    private Map configuration = new HashMap();

    public Helper() {
    }

    public Helper(Map config) {
        this.configuration.putAll(config);
    }

    public RepositoryService getRepositoryService() throws RepositoryException {
        if (this.repoServiceStub == null) {
            this.repoServiceStub = RepositoryServiceStub.getInstance(this.configuration);
        }
        return this.repoServiceStub.getRepositoryService();
    }

    public String getProperty(String name) throws RepositoryException {
        this.getRepositoryService();
        return this.repoServiceStub.getProperty(name);
    }

    public Credentials getAdminCredentials() throws RepositoryException {
        this.getRepositoryService();
        return this.repoServiceStub.getAdminCredentials();
    }

    public Credentials getReadOnlyCredentials() throws RepositoryException {
        this.getRepositoryService();
        return this.repoServiceStub.getReadOnlyCredentials();
    }

    public SessionInfo getAdminSessionInfo() throws RepositoryException {
        this.getRepositoryService();
        String propName = "org.apache.jackrabbit.spi.workspacename";
        String wspName = this.repoServiceStub.getProperty(propName);
        return this.getRepositoryService().obtain(this.getAdminCredentials(), wspName);
    }

    public SessionInfo getReadOnlySessionInfo() throws RepositoryException {
        this.getRepositoryService();
        String propName = "org.apache.jackrabbit.spi.workspacename";
        String wspName = this.repoServiceStub.getProperty(propName);
        return this.getRepositoryService().obtain(this.getReadOnlyCredentials(), wspName);
    }
}

