/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.RepositoryService;

public abstract class RepositoryServiceStub {
    public static final String STUB_IMPL_PROPS = "repositoryServiceStubImpl.properties";
    public static final String PROP_PREFIX = "org.apache.jackrabbit.spi";
    public static final String STUB_IMPL_SYS_PROPS = "org.apache.jackrabbit.spi.properties";
    public static final String PROP_STUB_IMPL_CLASS = "org.apache.jackrabbit.spi.repository_service_stub_impl";
    public static final String PROP_ADMIN_PWD = "admin.pwd";
    public static final String PROP_ADMIN_NAME = "admin.name";
    public static final String PROP_READONLY_PWD = "readonly.pwd";
    public static final String PROP_READONLY_NAME = "readonly.name";
    public static final String PROP_WORKSPACE = "workspacename";
    protected final Properties environment;

    protected RepositoryServiceStub(Properties env) {
        if (env == null) {
            throw new IllegalArgumentException("Parameter 'env' must not be null!");
        }
        this.environment = env;
    }

    public static RepositoryServiceStub getInstance(Map configuration) throws RepositoryException {
        Properties props = null;
        RepositoryServiceStub stub = null;
        String implProp = System.getProperty(STUB_IMPL_SYS_PROPS);
        if (implProp != null) {
            File implPropFile = new File(implProp);
            if (implPropFile.exists()) {
                props = new Properties();
                try {
                    props.load(new FileInputStream(implPropFile));
                }
                catch (IOException e) {
                    throw new RepositoryException("Unable to load config file: " + implProp + " " + e.toString());
                }
            } else {
                throw new RepositoryException("File does not exist: " + implProp);
            }
        }
        if (props == null) {
            props = new Properties();
            InputStream is = RepositoryServiceStub.class.getClassLoader().getResourceAsStream(STUB_IMPL_PROPS);
            if (is != null) {
                try {
                    props.load(is);
                }
                catch (IOException e) {
                    throw new RepositoryException("Exception reading repositoryServiceStubImpl.properties: " + e.toString());
                }
            }
        }
        props.putAll((Map<?, ?>)configuration);
        try {
            String className = props.getProperty(PROP_STUB_IMPL_CLASS);
            if (className == null || className.length() == 0) {
                throw new RepositoryException("Property org.apache.jackrabbit.spi.repository_service_stub_impl not defined!");
            }
            Class<?> stubClass = Class.forName(className);
            Constructor<?> constr = stubClass.getConstructor(Properties.class);
            stub = (RepositoryServiceStub)constr.newInstance(props);
        }
        catch (ClassCastException e) {
            throw new RepositoryException(e.toString());
        }
        catch (NoSuchMethodException e) {
            throw new RepositoryException(e.toString());
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException(e.toString());
        }
        catch (InstantiationException e) {
            throw new RepositoryException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new RepositoryException(e.toString());
        }
        return stub;
    }

    public abstract RepositoryService getRepositoryService() throws RepositoryException;

    public String getProperty(String name) {
        return this.environment.getProperty(name);
    }

    public abstract Credentials getAdminCredentials() throws RepositoryException;

    public abstract Credentials getReadOnlyCredentials() throws RepositoryException;
}

