/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.spi.AbstractSPITest;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QValueFactoryTest
extends AbstractSPITest {
    private static Logger log = LoggerFactory.getLogger(QValueFactoryTest.class);
    protected QValueFactory factory;
    private final Calendar calendar = Calendar.getInstance();
    protected Path rootPath;
    protected Name testName;
    protected String reference;

    protected void setUp() throws Exception {
        super.setUp();
        RepositoryService service = helper.getRepositoryService();
        this.factory = service.getQValueFactory();
        this.rootPath = service.getPathFactory().getRootPath();
        this.testName = service.getNameFactory().create("http://www.jcp.org/jcr/1.0", "data");
        this.reference = this.getProperty("reference");
    }

    private static void assertValueLength(QValue v, long expectedLength) throws RepositoryException {
        long length = v.getLength();
        if (length != -1L) {
            QValueFactoryTest.assertEquals((long)expectedLength, (long)length);
        }
    }

    public void testIllegalType() throws RepositoryException {
        try {
            this.factory.create("any", 54);
            QValueFactoryTest.fail((String)"54 is not a valid property type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateInvalidDoubleValue() throws RepositoryException {
        try {
            this.factory.create("any", 4);
            QValueFactoryTest.fail((String)"'any' cannot be converted to a valid double value.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDoubleOnBooleanValue() throws RepositoryException {
        try {
            QValue v = this.factory.create(true);
            v.getDouble();
            QValueFactoryTest.fail((String)"'true' cannot be converted to a valid double value.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testCreateInvalidLongValue() throws RepositoryException {
        try {
            this.factory.create("any", 3);
            QValueFactoryTest.fail((String)"'any' cannot be converted to a valid long value.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetLongOnBooleanValue() throws RepositoryException {
        try {
            QValue v = this.factory.create(true);
            v.getLong();
            QValueFactoryTest.fail((String)"'true' cannot be converted to a valid long value.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testFinalBooleanValue() throws RepositoryException {
        QValueFactoryTest.assertSame((Object)this.factory.create(true), (Object)this.factory.create(Boolean.TRUE.toString(), 6));
        QValueFactoryTest.assertSame((Object)this.factory.create(true), (Object)this.factory.create(true));
        QValueFactoryTest.assertSame((Object)this.factory.create(false), (Object)this.factory.create(Boolean.FALSE.toString(), 6));
        QValueFactoryTest.assertSame((Object)this.factory.create(false), (Object)this.factory.create(false));
    }

    public void testCreateBooleanValueFromString() throws RepositoryException {
        QValue v = this.factory.create(Boolean.TRUE.toString(), 6);
        QValueFactoryTest.assertEquals((String)"Creating boolean type QValue from boolean or String must be equal.", (Object)this.factory.create(true), (Object)v);
        v = this.factory.create(Boolean.FALSE.toString(), 6);
        QValueFactoryTest.assertEquals((String)"Creating boolean type QValue from boolean or String must be equal.", (Object)this.factory.create(false), (Object)v);
    }

    public void testCreateTrueBooleanValue() throws RepositoryException {
        QValue v = this.factory.create(true);
        QValueFactoryTest.assertEquals((String)"Boolean value must be true", (String)Boolean.TRUE.toString(), (String)v.getString());
        QValueFactoryTest.assertEquals((String)"Boolean value must be true", (boolean)true, (boolean)v.getBoolean());
    }

    public void testCreateFalseBooleanValue() throws RepositoryException {
        QValue v = this.factory.create(false);
        QValueFactoryTest.assertEquals((String)"Boolean value must be false", (String)Boolean.FALSE.toString(), (String)v.getString());
        QValueFactoryTest.assertEquals((String)"Boolean value must be false", (boolean)false, (boolean)v.getBoolean());
    }

    public void testCreateTrueFromString() throws ValueFormatException, RepositoryException {
        QValue v = this.factory.create(Boolean.TRUE.toString(), 1);
        QValueFactoryTest.assertEquals((String)"Boolean value must be true", (boolean)true, (boolean)v.getBoolean());
    }

    public void testCreateFalseFromString() throws ValueFormatException, RepositoryException {
        QValue v = this.factory.create("any", 1);
        QValueFactoryTest.assertEquals((String)"Boolean value must be false", (boolean)false, (boolean)v.getBoolean());
    }

    public void testReadBooleanAsLong() throws RepositoryException {
        try {
            QValue v = this.factory.create(true);
            v.getLong();
        }
        catch (ValueFormatException e) {
            return;
        }
        QValueFactoryTest.assertTrue((String)"Cannot convert value to long", (boolean)false);
    }

    public void testNullDateValue() throws IOException, RepositoryException {
        try {
            this.factory.create((Calendar)null);
            QValueFactoryTest.fail();
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.factory.create(null, 5);
            QValueFactoryTest.fail();
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDateValueType() throws RepositoryException {
        QValue v = this.factory.create(this.calendar);
        QValueFactoryTest.assertTrue((String)"Type of a date value must be PropertyType.DATE", (v.getType() == 5 ? 1 : 0) != 0);
    }

    public void testDateValueEquality() throws RepositoryException {
        QValue v = this.factory.create(this.calendar);
        QValue otherV = this.factory.create(this.calendar);
        QValueFactoryTest.assertEquals((String)"Equality of date value must be calculated based on their String representation.", (Object)v, (Object)otherV);
    }

    public void testDateValueEquality2() throws RepositoryException {
        QValue v = this.factory.create(this.calendar);
        QValue otherV = this.factory.create(v.getString(), 5);
        QValueFactoryTest.assertEquals((String)"Equality of date value must be calculated based on their String representation.", (Object)v, (Object)otherV);
    }

    public void testNullReferenceValue() throws IOException, RepositoryException {
        try {
            this.factory.create(null, 9);
            QValueFactoryTest.fail();
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testReferenceValueType() throws RepositoryException {
        if (this.reference != null) {
            QValue v = this.factory.create(this.reference, 9);
            QValueFactoryTest.assertTrue((String)"Type of a date value must be PropertyType.REFERENCE.", (v.getType() == 9 ? 1 : 0) != 0);
        } else {
            log.warn("Configuration entry 'QValueFactoryTest.reference' is missing -> skip test 'testReferenceValueType'.");
        }
    }

    public void testReferenceValueEquality() throws RepositoryException {
        if (this.reference != null) {
            QValue v = this.factory.create(this.reference, 9);
            QValue otherV = this.factory.create(this.reference, 9);
            QValueFactoryTest.assertEquals((String)"Reference values created from the same string must be equal.", (Object)v, (Object)otherV);
        } else {
            log.warn("Configuration entry 'QValueFactoryTest.reference' is missing -> skip test 'testReferenceValueEquality'.");
        }
    }

    public void testEqualityDifferentTypes() throws RepositoryException {
        if (this.reference != null) {
            QValue v = this.factory.create(this.reference, 9);
            QValue v2 = this.factory.create(this.reference, 1);
            QValueFactoryTest.assertFalse((boolean)v.equals(v2));
        } else {
            log.warn("Configuration entry 'QValueFactoryTest.reference' is missing -> skip test 'testEqualityDifferentTypes'.");
        }
    }

    public void testNullNameValue() throws IOException, RepositoryException {
        try {
            this.factory.create((Name)null);
            QValueFactoryTest.fail();
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNameValueType() throws IOException, RepositoryException {
        QValue v = this.factory.create(this.testName);
        QValueFactoryTest.assertTrue((v.getType() == 7 ? 1 : 0) != 0);
        v = this.factory.create(this.testName.toString(), 7);
        QValueFactoryTest.assertTrue((v.getType() == 7 ? 1 : 0) != 0);
    }

    public void testNameValueEquality() throws IOException, RepositoryException {
        QValue v = this.factory.create(this.testName);
        QValue v2 = this.factory.create(this.testName.toString(), 7);
        QValueFactoryTest.assertTrue((boolean)v.equals(v2));
    }

    public void testNameValueGetString() throws IOException, RepositoryException {
        QValue v = this.factory.create(this.testName);
        QValueFactoryTest.assertTrue((boolean)v.getString().equals(this.testName.toString()));
    }

    public void testNameValueGetName() throws RepositoryException {
        QValue v = this.factory.create(this.testName);
        QValueFactoryTest.assertTrue((boolean)v.getName().equals(this.testName));
    }

    public void testInvalidNameValue() throws RepositoryException {
        try {
            this.factory.create("abc", 7);
            QValueFactoryTest.fail((String)"'abc' is not a valid Name -> creating QValue should fail.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testAnyValueGetName() throws RepositoryException {
        try {
            this.factory.create(12345L).getName();
            QValueFactoryTest.fail((String)"12345 is not a valid Name value -> QValue.getName() should fail.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testNullPathValue() throws IOException, RepositoryException {
        try {
            this.factory.create((Path)null);
            QValueFactoryTest.fail();
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPathValueType() throws IOException, RepositoryException {
        QValue v = this.factory.create(this.rootPath);
        QValueFactoryTest.assertTrue((v.getType() == 8 ? 1 : 0) != 0);
        v = this.factory.create(this.rootPath.toString(), 8);
        QValueFactoryTest.assertTrue((v.getType() == 8 ? 1 : 0) != 0);
    }

    public void testPathValueEquality() throws IOException, RepositoryException {
        QValue v = this.factory.create(this.rootPath);
        QValue v2 = this.factory.create(this.rootPath.toString(), 8);
        QValueFactoryTest.assertTrue((boolean)v.equals(v2));
    }

    public void testPathValueGetString() throws IOException, RepositoryException {
        QValue v = this.factory.create(this.rootPath);
        QValueFactoryTest.assertTrue((boolean)v.getString().equals(this.rootPath.toString()));
    }

    public void testPathValueGetPath() throws RepositoryException {
        QValue v = this.factory.create(this.rootPath);
        QValueFactoryTest.assertTrue((boolean)v.getPath().equals(this.rootPath));
    }

    public void testInvalidPathValue() throws RepositoryException {
        try {
            this.factory.create("abc", 8);
            QValueFactoryTest.fail((String)"'abc' is not a valid Path -> creating QValue should fail.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testAnyValueGetPath() throws RepositoryException {
        try {
            this.factory.create(12345L).getPath();
            QValueFactoryTest.fail((String)"12345 is not a valid Path value -> QValue.getPath() should fail.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testNullBinaryValue() throws IOException, RepositoryException {
        try {
            this.factory.create((byte[])null);
            QValueFactoryTest.fail();
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.factory.create((InputStream)null);
            QValueFactoryTest.fail();
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.factory.create((File)null);
            QValueFactoryTest.fail();
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBinaryValueType() throws IOException, RepositoryException {
        QValue v = this.factory.create(new byte[]{97, 98, 99});
        QValueFactoryTest.assertTrue((v.getType() == 2 ? 1 : 0) != 0);
    }

    public void testBinaryFromByteArray() throws RepositoryException, IOException {
        QValue v = this.factory.create(new byte[]{97, 98, 99});
        QValueFactoryTest.assertEquals((int)2, (int)v.getType());
        QValueFactoryTest.assertValueLength(v, 3L);
        QValueFactoryTest.assertEquals((String)"abc", (String)v.getString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QValueFactoryTest.spool(out, v.getStream());
        QValueFactoryTest.assertEquals((String)"abc", (String)new String(out.toByteArray()));
    }

    public void testEmptyBinaryFromByteArray() throws RepositoryException, IOException {
        QValue v = this.factory.create(new byte[0]);
        QValueFactoryTest.assertEquals((int)2, (int)v.getType());
        QValueFactoryTest.assertValueLength(v, 0L);
        QValueFactoryTest.assertEquals((String)"", (String)v.getString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QValueFactoryTest.spool(out, v.getStream());
        QValueFactoryTest.assertEquals((String)"", (String)new String(out.toByteArray()));
    }

    public void testBinaryFromInputStream() throws RepositoryException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{97, 98, 99});
        QValue v = this.factory.create((InputStream)in);
        QValueFactoryTest.assertEquals((int)2, (int)v.getType());
        QValueFactoryTest.assertValueLength(v, 3L);
        QValueFactoryTest.assertEquals((String)"abc", (String)v.getString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QValueFactoryTest.spool(out, v.getStream());
        QValueFactoryTest.assertEquals((String)"abc", (String)new String(out.toByteArray()));
    }

    public void testEmptyBinaryFromInputStream() throws RepositoryException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[0]);
        QValue v = this.factory.create((InputStream)in);
        QValueFactoryTest.assertEquals((int)2, (int)v.getType());
        QValueFactoryTest.assertValueLength(v, 0L);
        QValueFactoryTest.assertEquals((String)"", (String)v.getString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QValueFactoryTest.spool(out, v.getStream());
        QValueFactoryTest.assertEquals((String)"", (String)new String(out.toByteArray()));
    }

    public void testBinaryFromFile() throws RepositoryException, IOException {
        File f = File.createTempFile("QValueFactoryImplTest", ".txt");
        f.deleteOnExit();
        FileWriter fw = new FileWriter(f);
        fw.write("abc");
        fw.close();
        QValue v = this.factory.create(f);
        QValueFactoryTest.assertEquals((int)2, (int)v.getType());
        QValueFactoryTest.assertValueLength(v, 3L);
        QValueFactoryTest.assertEquals((String)"abc", (String)v.getString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QValueFactoryTest.spool(out, v.getStream());
        QValueFactoryTest.assertEquals((String)"abc", (String)new String(out.toByteArray()));
    }

    public void testEmptyBinaryFromFile() throws RepositoryException, IOException {
        File f = File.createTempFile("QValueFactoryImplTest", ".txt");
        f.deleteOnExit();
        QValue v = this.factory.create(f);
        QValueFactoryTest.assertEquals((int)2, (int)v.getType());
        QValueFactoryTest.assertValueLength(v, 0L);
        QValueFactoryTest.assertEquals((String)"", (String)v.getString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QValueFactoryTest.spool(out, v.getStream());
        QValueFactoryTest.assertEquals((String)"", (String)new String(out.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void spool(OutputStream out, InputStream in) throws RepositoryException, IOException {
        try {
            int read;
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }
}

