/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.valuechoices;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.unittestsupport.jmocking.JUnitRuleMockery2;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.ui.components.widgets.valuechoices.ValueChoicesSelect2Panel;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class FixedObjectAdapterMementoProviderTest {
    @Rule
    public JUnitRuleMockery2 context = JUnitRuleMockery2.createFor((JUnitRuleMockery2.Mode)JUnitRuleMockery2.Mode.INTERFACES_AND_CLASSES);
    private List<ObjectAdapterMemento> mementos;
    private ObjectAdapterMemento mockMemento1;
    private ObjectAdapterMemento mockMemento2;
    private ValueChoicesSelect2Panel.FixedObjectAdapterMementoProvider provider;

    @Before
    public void setUp() throws Exception {
        this.mockMemento1 = this.mock("mockMemento1");
        this.mockMemento2 = this.mock("mockMemento2");
        this.mementos = Lists.newArrayList((Object[])new ObjectAdapterMemento[]{this.mockMemento1, this.mockMemento2});
        WicketViewerSettings wicketViewerSettings = (WicketViewerSettings)this.context.mock(WicketViewerSettings.class);
        this.provider = new ValueChoicesSelect2Panel.FixedObjectAdapterMementoProvider(null, this.mementos, wicketViewerSettings);
    }

    @Test
    public void whenInList() throws Exception {
        Collection mementos = this.provider.toChoices(Collections.singletonList("mockMemento1"));
        Assert.assertThat((Object)mementos.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(mementos.iterator().next(), (Matcher)CoreMatchers.is((Object)this.mockMemento1));
    }

    @Test
    public void whenNullPlaceholder() throws Exception {
        Collection mementos = this.provider.toChoices(Collections.singletonList("$$_isis_null_$$"));
        Assert.assertThat((Object)mementos.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(mementos.iterator().next(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private ObjectAdapterMemento mock(final String id) {
        final ObjectAdapterMemento mock = (ObjectAdapterMemento)this.context.mock(ObjectAdapterMemento.class, id);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectAdapterMemento)this.allowing(mock)).asString();
                this.will(1.returnValue((Object)id));
            }
        });
        return mock;
    }
}

