/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jodatime;

import org.apache.isis.core.unittestsupport.jmocking.JUnitRuleMockery2;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.jodatime.DateConverterForJodaLocalDateTime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.auto.Mock;
import org.jmock.internal.ExpectationBuilder;
import org.joda.time.LocalDateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DateConverterForJodaLocalDateTimeTest {
    @Rule
    public JUnitRuleMockery2 context = JUnitRuleMockery2.createFor((JUnitRuleMockery2.Mode)JUnitRuleMockery2.Mode.INTERFACES_AND_CLASSES);
    @Mock
    private WicketViewerSettings settings;

    @Before
    public void setUp() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((WicketViewerSettings)this.allowing(DateConverterForJodaLocalDateTimeTest.this.settings)).getDatePattern();
                this.will(1.returnValue((Object)"yyyy-MM-dd"));
                ((WicketViewerSettings)this.allowing(DateConverterForJodaLocalDateTimeTest.this.settings)).getDateTimePattern();
                this.will(1.returnValue((Object)"yyyy-MM-dd HH:mm"));
                ((WicketViewerSettings)this.allowing(DateConverterForJodaLocalDateTimeTest.this.settings)).getDatePickerPattern();
                this.will(1.returnValue((Object)"yy-mm-dd"));
            }
        });
    }

    @Test
    public void roundtripWhenParsingDateFormat() {
        DateConverterForJodaLocalDateTime converter = new DateConverterForJodaLocalDateTime(this.settings, 0);
        LocalDateTime dt = (LocalDateTime)converter.convertToObject("2013-05-11", null);
        Assert.assertThat((Object)dt, (Matcher)CoreMatchers.is((Object)new LocalDateTime(2013, 5, 11, 0, 0)));
        String str = converter.convertToString((Object)dt, null);
        Assert.assertThat((Object)str, (Matcher)CoreMatchers.is((Object)"2013-05-11 00:00"));
    }

    @Test
    public void roundtripWhenParsingDateTimeFormat() {
        DateConverterForJodaLocalDateTime converter = new DateConverterForJodaLocalDateTime(this.settings, 0);
        LocalDateTime dt = (LocalDateTime)converter.convertToObject("2013-05-11 00:00", null);
        Assert.assertThat((Object)dt, (Matcher)CoreMatchers.is((Object)new LocalDateTime(2013, 5, 11, 0, 0)));
        String str = converter.convertToString((Object)dt, null);
        Assert.assertThat((Object)str, (Matcher)CoreMatchers.is((Object)"2013-05-11 00:00"));
    }

    @Test
    public void roundtripWhenParsingDateFormatWithAdjustBy() {
        DateConverterForJodaLocalDateTime converter = new DateConverterForJodaLocalDateTime(this.settings, -1);
        LocalDateTime dt = (LocalDateTime)converter.convertToObject("2013-05-11", null);
        Assert.assertThat((Object)dt, (Matcher)CoreMatchers.is((Object)new LocalDateTime(2013, 5, 12, 0, 0)));
        String str = converter.convertToString((Object)dt, null);
        Assert.assertThat((Object)str, (Matcher)CoreMatchers.is((Object)"2013-05-11 00:00"));
    }

    @Test
    public void roundtripWhenParsingDateTimeFormatWithAdjustBy() {
        DateConverterForJodaLocalDateTime converter = new DateConverterForJodaLocalDateTime(this.settings, -1);
        LocalDateTime dt = (LocalDateTime)converter.convertToObject("2013-05-11 00:00", null);
        Assert.assertThat((Object)dt, (Matcher)CoreMatchers.is((Object)new LocalDateTime(2013, 5, 12, 0, 0)));
        String str = converter.convertToString((Object)dt, null);
        Assert.assertThat((Object)str, (Matcher)CoreMatchers.is((Object)"2013-05-11 00:00"));
    }
}

