/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jdkmath;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkmath.BigDecimalConverterWithScale;
import org.apache.wicket.util.convert.ConversionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BigDecimalConverterWithScaleTest_roundtrip {
    final BigDecimal bd_123_45_scale2 = new BigDecimal("123.45").setScale(2);
    final BigDecimal bd_123_4500_scale2 = new BigDecimal("123.4500").setScale(2);
    final BigDecimal bd_789123_45_scale2 = new BigDecimal("789123.45").setScale(2);
    final BigDecimal bd_123_45_scale4 = new BigDecimal("123.45").setScale(4);
    final BigDecimal bd_123_4500_scale4 = new BigDecimal("123.4500").setScale(4);
    private BigDecimalConverterWithScale converter;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.converter = this.newConverter(2);
    }

    @Test
    public void scale2_english() {
        BigDecimal actual = this.converter.convertToObject("123.45", Locale.ENGLISH);
        Assert.assertEquals((Object)this.bd_123_4500_scale2, (Object)actual);
        Assert.assertEquals((Object)this.bd_123_45_scale2, (Object)actual);
        Assert.assertNotEquals((Object)this.bd_123_4500_scale4, (Object)actual);
        Assert.assertNotEquals((Object)this.bd_123_45_scale4, (Object)actual);
        String actualStr = this.converter.convertToString((Number)actual, Locale.ENGLISH);
        Assert.assertEquals((Object)"123.45", (Object)actualStr);
    }

    @Test
    public void scale4_english() {
        this.converter = this.newConverter(4);
        BigDecimal actual = this.converter.convertToObject("123.45", Locale.ENGLISH);
        Assert.assertNotEquals((Object)this.bd_123_4500_scale2, (Object)actual);
        Assert.assertNotEquals((Object)this.bd_123_45_scale2, (Object)actual);
        Assert.assertEquals((Object)this.bd_123_4500_scale4, (Object)actual);
        Assert.assertEquals((Object)this.bd_123_45_scale4, (Object)actual);
        String actualStr = this.converter.convertToString((Number)actual, Locale.ENGLISH);
        Assert.assertEquals((Object)"123.4500", (Object)actualStr);
    }

    @Test
    public void scaleNull_english() {
        this.converter = this.newConverter(null);
        BigDecimal actual = this.converter.convertToObject("123.45", Locale.ENGLISH);
        Assert.assertEquals((Object)this.bd_123_4500_scale2, (Object)actual);
        Assert.assertEquals((Object)this.bd_123_45_scale2, (Object)actual);
        BigDecimal actual2 = this.converter.convertToObject("123.4500", Locale.ENGLISH);
        Assert.assertEquals((Object)this.bd_123_4500_scale4, (Object)actual2);
        Assert.assertEquals((Object)this.bd_123_45_scale4, (Object)actual2);
    }

    @Test
    public void scale2_italian() {
        BigDecimal actual = this.converter.convertToObject("123,45", Locale.ITALIAN);
        Assert.assertEquals((Object)this.bd_123_4500_scale2, (Object)actual);
        Assert.assertEquals((Object)this.bd_123_45_scale2, (Object)actual);
        Assert.assertNotEquals((Object)this.bd_123_4500_scale4, (Object)actual);
        Assert.assertNotEquals((Object)this.bd_123_45_scale4, (Object)actual);
    }

    @Test
    public void scale2_english_withThousandSeparators() {
        this.exception.expect(ConversionException.class);
        this.exception.expectMessage("Thousands separator ',' is not allowed in input");
        this.converter.convertToObject("789,123.45", Locale.ENGLISH);
    }

    @Test
    public void scale2_english_withoutThousandSeparators() {
        BigDecimal actual = this.converter.convertToObject("789123.45", Locale.ENGLISH);
        Assert.assertEquals((Object)this.bd_789123_45_scale2, (Object)actual);
        String actualStr = this.converter.convertToString((Number)actual, Locale.ENGLISH);
        Assert.assertEquals((Object)"789123.45", (Object)actualStr);
    }

    @Test
    public void scale2_english_tooLargeScale() {
        this.exception.expect(ConversionException.class);
        this.exception.expectMessage("No more than 2 digits can be entered after the decimal place");
        this.converter.convertToObject("123.454", Locale.ENGLISH);
    }

    private BigDecimalConverterWithScale newConverter(Integer scale) {
        return new BigDecimalConverterWithScale(scale);
    }
}

