/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.isisapplib;

import java.util.TimeZone;
import org.apache.isis.applib.value.Date;
import org.apache.isis.core.unittestsupport.jmocking.JUnitRuleMockery2;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.isisapplib.DateConverterForApplibDate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.auto.Mock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DateConverterForApplibDateTest {
    @Rule
    public JUnitRuleMockery2 context = JUnitRuleMockery2.createFor((JUnitRuleMockery2.Mode)JUnitRuleMockery2.Mode.INTERFACES_AND_CLASSES);
    @Mock
    private WicketViewerSettings settings;
    private TimeZone timezone;

    @Before
    public void setUp() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((WicketViewerSettings)this.allowing(DateConverterForApplibDateTest.this.settings)).getDatePattern();
                this.will(1.returnValue((Object)"yyyy-MM-dd"));
            }
        });
    }

    @Before
    public void fixTimezone() throws Exception {
        this.timezone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @Before
    public void restoreTimezone() throws Exception {
        TimeZone.setDefault(this.timezone);
    }

    @Test
    public void roundtripWhenParsingDateFormat() {
        DateConverterForApplibDate converter = new DateConverterForApplibDate(this.settings, 0);
        Date dt = (Date)converter.convertToObject("2013-05-11", null);
        Assert.assertThat((Object)dt, (Matcher)CoreMatchers.is((Object)new Date(2013, 5, 11)));
        String str = converter.convertToString((Object)dt, null);
        Assert.assertThat((Object)str, (Matcher)CoreMatchers.is((Object)"2013-05-11"));
    }

    @Test
    public void roundtripWhenParsingDateFormatWithAdjustBy() {
        DateConverterForApplibDate converter = new DateConverterForApplibDate(this.settings, -1);
        Date dt = (Date)converter.convertToObject("2013-05-11", null);
        Assert.assertThat((Object)dt, (Matcher)CoreMatchers.is((Object)new Date(2013, 5, 12)));
        String str = converter.convertToString((Object)dt, null);
        Assert.assertThat((Object)str, (Matcher)CoreMatchers.is((Object)"2013-05-11"));
    }
}

