/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui;

import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ComponentFactoryAbstractTest_init {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void canInstantiateComponentFactoryWithNoComponentClass() {
        class ComponentFactoryWithNoComponentClass
        extends ComponentFactoryAbstract {
            private static final long serialVersionUID = 1L;

            public ComponentFactoryWithNoComponentClass() {
                super(null);
            }

            protected ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
                return null;
            }

            public Component createComponent(String id, IModel<?> model) {
                return null;
            }
        }
        new ComponentFactoryWithNoComponentClass();
    }

    @Test
    public void canInstantiateComponentFactoryWithComponentClass() {
        class ComponentFactoryWithComponentClass
        extends ComponentFactoryAbstract {
            private static final long serialVersionUID = 1L;

            public ComponentFactoryWithComponentClass() {
                class ComponentClass {
                    ComponentClass() {
                    }
                }
                super(null, ComponentClass.class);
            }

            protected ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
                return null;
            }

            public Component createComponent(String id, IModel<?> model) {
                return null;
            }
        }
        new ComponentFactoryWithComponentClass();
    }

    @Test
    public void cannotInstantiateComponentFactoryWithIncorrectComponentClass() {
        this.thrown.expect(IllegalArgumentException.class);
        class ComponentFactoryWithIncorrectComponentClass
        extends ComponentFactoryAbstract {
            private static final long serialVersionUID = 1L;

            public ComponentFactoryWithIncorrectComponentClass() {
                super(null, ComponentFactoryWithIncorrectComponentClass.class);
            }

            protected ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
                return null;
            }

            public Component createComponent(String id, IModel<?> model) {
                return null;
            }
        }
        new ComponentFactoryWithIncorrectComponentClass();
    }
}

