/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.services;

import java.io.File;
import org.apache.isis.viewer.wicket.viewer.services.TranslationsResolverWicket;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TranslationsResolverWicketTest {

    public static class NewFile
    extends TranslationsResolverWicketTest {
        @Before
        public void setUp() throws Exception {
            Assume.assumeThat((Object)System.getProperty("os.name").startsWith("Windows"), (Matcher)CoreMatchers.is((Object)true));
        }

        @Test
        public void simple() throws Exception {
            File file = TranslationsResolverWicket.newFile((String)"c:/foo", (String)"bar");
            String absolutePath = file.getAbsolutePath();
            Assert.assertThat((Object)absolutePath, (Matcher)CoreMatchers.is((Object)"c:\\foo\\bar"));
        }

        @Test
        public void nestedChild() throws Exception {
            File file = TranslationsResolverWicket.newFile((String)"c:/foo", (String)"bar/baz");
            String absolutePath = file.getAbsolutePath();
            Assert.assertThat((Object)absolutePath, (Matcher)CoreMatchers.is((Object)"c:\\foo\\bar\\baz"));
        }
    }
}

