/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.pages;

import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.pages.PageClassList;
import org.apache.isis.viewer.wicket.ui.pages.actionprompt.ActionPromptPage;
import org.apache.isis.viewer.wicket.viewer.registries.pages.PageClassListDefault;
import org.apache.isis.viewer.wicket.viewer.registries.pages.PageClassRegistryDefault;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PageClassListDefault_RegistrationAndCaching {
    private PageClassRegistryDefault registryImpl;

    @Before
    public void setUp() throws Exception {
        PageClassListDefault pageClassList = new PageClassListDefault();
        this.registryImpl = new PageClassRegistryDefault((PageClassList)pageClassList);
    }

    @Test
    public void cachesPageByPageType() {
        Class pageClass = this.registryImpl.getPageClass(PageType.ACTION_PROMPT);
        Assert.assertThat((Object)pageClass, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @Test
    public void canRegisterNewPageType() {
        class TestingActionPage
        extends ActionPromptPage {
            TestingActionPage() {
                super((ActionModel)null);
            }
        }
        this.registryImpl.registerPage(PageType.ACTION_PROMPT, TestingActionPage.class);
        Class pageClass = this.registryImpl.getPageClass(PageType.ACTION_PROMPT);
        Assert.assertThat((Object)pageClass, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(TestingActionPage.class)));
    }
}

