/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.imagecache;

import java.util.Iterator;
import java.util.List;
import org.apache.isis.viewer.wicket.viewer.imagecache.ImageResourceCacheKey;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ImageResourceCacheKeyTest {
    ImageResourceCacheKey key;

    public static class ResourcePaths
    extends ImageResourceCacheKeyTest {
        @Test
        public void withIconName() throws Exception {
            this.key = new ImageResourceCacheKey(SomeSubclass.class, "foo");
            List keys = this.key.resourcePaths(new String[]{"png", "jpg", "jpeg"});
            Iterator<ImageResourceCacheKey> iterator = keys.iterator();
            ResourcePaths.assertNext(iterator, SomeSubclass.class, "SomeSubclass-foo.png");
            ResourcePaths.assertNext(iterator, SomeSubclass.class, "SomeSubclass-foo.jpg");
            ResourcePaths.assertNext(iterator, SomeSubclass.class, "SomeSubclass-foo.jpeg");
            ResourcePaths.assertNext(iterator, SomeSubclass.class, "foo.png");
            ResourcePaths.assertNext(iterator, SomeSubclass.class, "foo.jpg");
            ResourcePaths.assertNext(iterator, SomeSubclass.class, "foo.jpeg");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass-foo.png");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass-foo.jpg");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass-foo.jpeg");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "foo.png");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "foo.jpg");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "foo.jpeg");
            ResourcePaths.assertNext(iterator, null, "SomeSubclass-foo.png");
            ResourcePaths.assertNext(iterator, null, "SomeSubclass-foo.jpg");
            ResourcePaths.assertNext(iterator, null, "SomeSubclass-foo.jpeg");
            ResourcePaths.assertNext(iterator, null, "SomeSuperclass-foo.png");
            ResourcePaths.assertNext(iterator, null, "SomeSuperclass-foo.jpg");
            ResourcePaths.assertNext(iterator, null, "SomeSuperclass-foo.jpeg");
            ResourcePaths.assertNext(iterator, null, "foo.png");
            ResourcePaths.assertNext(iterator, null, "foo.jpg");
            ResourcePaths.assertNext(iterator, null, "foo.jpeg");
            ResourcePaths.assertNext(iterator, SomeSubclass.class, "SomeSubclass.png");
            ResourcePaths.assertNext(iterator, SomeSubclass.class, "SomeSubclass.jpg");
            ResourcePaths.assertNext(iterator, SomeSubclass.class, "SomeSubclass.jpeg");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass.png");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass.jpg");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass.jpeg");
            ResourcePaths.assertNext(iterator, null, "SomeSubclass.png");
            ResourcePaths.assertNext(iterator, null, "SomeSubclass.jpg");
            ResourcePaths.assertNext(iterator, null, "SomeSubclass.jpeg");
            ResourcePaths.assertNext(iterator, null, "SomeSuperclass.png");
            ResourcePaths.assertNext(iterator, null, "SomeSuperclass.jpg");
            ResourcePaths.assertNext(iterator, null, "SomeSuperclass.jpeg");
            ResourcePaths.assertNext(iterator, null, "Default.png");
            ResourcePaths.assertNext(iterator, null, "Default.jpg");
            ResourcePaths.assertNext(iterator, null, "Default.jpeg");
        }

        @Test
        public void withoutIconName() throws Exception {
            this.key = new ImageResourceCacheKey(SomeSubclass.class, null);
            List keys = this.key.resourcePaths(new String[]{"png", "jpg", "jpeg"});
            Iterator<ImageResourceCacheKey> iterator = keys.iterator();
            ResourcePaths.assertNext(iterator, SomeSubclass.class, "SomeSubclass.png");
            ResourcePaths.assertNext(iterator, SomeSubclass.class, "SomeSubclass.jpg");
            ResourcePaths.assertNext(iterator, SomeSubclass.class, "SomeSubclass.jpeg");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass.png");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass.jpg");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass.jpeg");
            ResourcePaths.assertNext(iterator, null, "SomeSubclass.png");
            ResourcePaths.assertNext(iterator, null, "SomeSubclass.jpg");
            ResourcePaths.assertNext(iterator, null, "SomeSubclass.jpeg");
            ResourcePaths.assertNext(iterator, null, "SomeSuperclass.png");
            ResourcePaths.assertNext(iterator, null, "SomeSuperclass.jpg");
            ResourcePaths.assertNext(iterator, null, "SomeSuperclass.jpeg");
            ResourcePaths.assertNext(iterator, null, "Default.png");
            ResourcePaths.assertNext(iterator, null, "Default.jpg");
            ResourcePaths.assertNext(iterator, null, "Default.jpeg");
        }

        @Test
        public void withoutClass() throws Exception {
            this.key = new ImageResourceCacheKey(null, "foo");
            List keys = this.key.resourcePaths(new String[]{"png", "jpg", "jpeg"});
            Iterator<ImageResourceCacheKey> iterator = keys.iterator();
            ResourcePaths.assertNext(iterator, null, "foo.png");
            ResourcePaths.assertNext(iterator, null, "foo.jpg");
            ResourcePaths.assertNext(iterator, null, "foo.jpeg");
            ResourcePaths.assertNext(iterator, null, "Default.png");
            ResourcePaths.assertNext(iterator, null, "Default.jpg");
            ResourcePaths.assertNext(iterator, null, "Default.jpeg");
        }

        @Test
        public void withoutClassButIconNameSpecifyingADifferentContextClassAndClassName() throws Exception {
            this.key = new ImageResourceCacheKey(SomeOtherContextClass.class, SomeSuperclass.class.getName());
            List keys = this.key.resourcePaths(new String[]{"png", "jpg", "jpeg"});
            Iterator<ImageResourceCacheKey> iterator = keys.iterator();
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass.png");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass.jpg");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass.jpeg");
            ResourcePaths.assertNext(iterator, null, "Default.png");
            ResourcePaths.assertNext(iterator, null, "Default.jpg");
            ResourcePaths.assertNext(iterator, null, "Default.jpeg");
        }

        @Test
        public void withoutClassButIconNameSpecifyingAClassName() throws Exception {
            this.key = new ImageResourceCacheKey(null, SomeSuperclass.class.getName());
            List keys = this.key.resourcePaths(new String[]{"png", "jpg", "jpeg"});
            Iterator<ImageResourceCacheKey> iterator = keys.iterator();
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass.png");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass.jpg");
            ResourcePaths.assertNext(iterator, SomeSuperclass.class, "SomeSuperclass.jpeg");
            ResourcePaths.assertNext(iterator, null, "Default.png");
            ResourcePaths.assertNext(iterator, null, "Default.jpg");
            ResourcePaths.assertNext(iterator, null, "Default.jpeg");
        }

        private static void assertNext(Iterator<ImageResourceCacheKey> iterator, Class<?> resourceClass, String resourceName) {
            Assert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
            ImageResourceCacheKey next = iterator.next();
            Assert.assertEquals(resourceClass, (Object)next.getResourceClass());
            Assert.assertEquals((Object)resourceName, (Object)next.getResourceName());
        }
    }

    public static class SuperKey
    extends ImageResourceCacheKeyTest {
        @Test
        public void whenSubclass() throws Exception {
            this.key = new ImageResourceCacheKey(SomeSubclass.class, "foo");
            ImageResourceCacheKey superKey = this.key.superKey();
            Assert.assertEquals(SomeSuperclass.class, (Object)superKey.getResourceClass());
            Assert.assertEquals((Object)"foo", (Object)this.key.getResourceName());
        }

        @Test
        public void whenSuperClass() throws Exception {
            this.key = new ImageResourceCacheKey(SomeSuperclass.class, null);
            ImageResourceCacheKey superKey = this.key.superKey();
            Assert.assertNull((Object)superKey);
        }
    }

    public static class SomeOtherContextClass
    extends SomeSuperclass {
    }

    public static class SomeSubclass
    extends SomeSuperclass {
    }

    public static class SomeSuperclass {
    }
}

