/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.app.wicket;

import java.util.Locale;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.unittestsupport.jmocking.JUnitRuleMockery2;
import org.apache.isis.viewer.wicket.viewer.integration.wicket.AuthenticatedWebSessionForIsis;
import org.apache.wicket.request.Request;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.auto.Mock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class AuthenticatedWebSessionForIsis_Authenticate {
    @Rule
    public final JUnitRuleMockery2 context = JUnitRuleMockery2.createFor((JUnitRuleMockery2.Mode)JUnitRuleMockery2.Mode.INTERFACES_AND_CLASSES);
    private AuthenticatedWebSessionForIsis webSession;
    @Mock
    private Request stubRequest;
    @Mock
    private AuthenticationManager mockAuthMgr;

    @Before
    public void setUp() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Request)this.allowing(AuthenticatedWebSessionForIsis_Authenticate.this.stubRequest)).getLocale();
                this.will(1.returnValue((Object)Locale.getDefault()));
                this.ignoring(AuthenticatedWebSessionForIsis_Authenticate.this.stubRequest);
            }
        });
    }

    @Test
    public void delegatesToAuthenticationManagerAndCachesAuthSessionIfOk() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((AuthenticationManager)this.one(AuthenticatedWebSessionForIsis_Authenticate.this.mockAuthMgr)).authenticate((AuthenticationRequest)this.with(2.any(AuthenticationRequest.class)));
            }
        });
        this.webSession = new AuthenticatedWebSessionForIsis(this.stubRequest){
            private static final long serialVersionUID = 1L;

            protected AuthenticationManager getAuthenticationManager() {
                return AuthenticatedWebSessionForIsis_Authenticate.this.mockAuthMgr;
            }
        };
        Assert.assertThat((Object)this.webSession.authenticate("jsmith", "secret"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.webSession.getAuthenticationSession(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @Test
    public void delegatesToAuthenticationManagerAndHandlesIfNotAuthenticated() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((AuthenticationManager)this.one(AuthenticatedWebSessionForIsis_Authenticate.this.mockAuthMgr)).authenticate((AuthenticationRequest)this.with(4.any(AuthenticationRequest.class)));
                this.will(4.returnValue(null));
            }
        });
        this.webSession = new AuthenticatedWebSessionForIsis(this.stubRequest){
            private static final long serialVersionUID = 1L;

            protected AuthenticationManager getAuthenticationManager() {
                return AuthenticatedWebSessionForIsis_Authenticate.this.mockAuthMgr;
            }
        };
        Assert.assertThat((Object)this.webSession.authenticate("jsmith", "secret"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.webSession.getAuthenticationSession(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

