/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer;

import org.apache.isis.core.unittestsupport.jmocking.JUnitRuleMockery2;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.home.HomePage;
import org.apache.isis.viewer.wicket.viewer.IsisWicketApplication;
import org.apache.wicket.markup.html.WebPage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.auto.Mock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class IsisWicketApplication_Pages {
    @Rule
    public JUnitRuleMockery2 context = JUnitRuleMockery2.createFor((JUnitRuleMockery2.Mode)JUnitRuleMockery2.Mode.INTERFACES_ONLY);
    @Mock
    private PageClassRegistry mockPageClassRegistry;
    private IsisWicketApplication application;

    @Test
    public void delegatesToPageClassRegistryToObtainPageTypes() {
        final PageType pageType = PageType.HOME;
        final Class<HomePage> expectedPageClass = HomePage.class;
        this.application = new IsisWicketApplication(){
            private static final long serialVersionUID = 1L;

            public PageClassRegistry getPageClassRegistry() {
                return IsisWicketApplication_Pages.this.mockPageClassRegistry;
            }
        };
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PageClassRegistry)this.one(IsisWicketApplication_Pages.this.mockPageClassRegistry)).getPageClass(pageType);
                this.will(2.returnValue((Object)expectedPageClass));
            }
        });
        Class pageClass = this.application.getHomePage();
        Assert.assertThat((Object)expectedPageClass.isAssignableFrom(pageClass), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void delegatesToPageClassRegistryToObtainPageTypes_ForSignIn() {
        final PageType pageType = PageType.SIGN_IN;
        final Class<WebPage> expectedPageClass = WebPage.class;
        final PageClassRegistry mockPageClassRegistry = (PageClassRegistry)this.context.mock(PageClassRegistry.class);
        this.application = new IsisWicketApplication(){
            private static final long serialVersionUID = 1L;

            public PageClassRegistry getPageClassRegistry() {
                return mockPageClassRegistry;
            }
        };
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PageClassRegistry)this.one(mockPageClassRegistry)).getPageClass(pageType);
                this.will(4.returnValue((Object)expectedPageClass));
            }
        });
        Class pageClass = this.application.getSignInPageClass();
        Assert.assertThat((Object)expectedPageClass.isAssignableFrom(pageClass), (Matcher)Matchers.is((Object)true));
    }
}

