/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;

public final class UrlParserUtils {
    private static final Pattern OBJECT_OID = Pattern.compile(".*objects\\/([^/]+)\\/(.+)");
    private static final Pattern DOMAIN_TYPE = Pattern.compile(".*domain-types\\/([^/]+).*");

    public static final String encodedOidFromLink(JsonRepresentation link) {
        String href = link.getString("href");
        Matcher matcher = OBJECT_OID.matcher(href);
        if (!matcher.matches()) {
            return null;
        }
        String domainType = matcher.group(1);
        String instanceId = matcher.group(2);
        return UrlParserUtils.getOidMarshaller().joinAsOid(domainType, instanceId);
    }

    public static final String domainTypeFrom(JsonRepresentation link) {
        return UrlParserUtils.domainTypeFrom(link.getString("href"));
    }

    public static String domainTypeFrom(String href) {
        Matcher matcher = DOMAIN_TYPE.matcher(href);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    private static OidMarshaller getOidMarshaller() {
        return new OidMarshaller();
    }
}

