/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.util;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOidDefault;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.server.util.UrlDecoderUtils;

public final class OidUtils {
    private OidUtils() {
    }

    public static String getDomainType(RendererContext renderContext, ObjectAdapter objectAdapter) {
        return org.apache.isis.viewer.restfulobjects.rendering.util.OidUtils.getDomainType((ObjectAdapter)objectAdapter);
    }

    public static String getInstanceId(RendererContext renderContext, ObjectAdapter objectAdapter) {
        return org.apache.isis.viewer.restfulobjects.rendering.util.OidUtils.getInstanceId((RendererContext)renderContext, (ObjectAdapter)objectAdapter);
    }

    public static String joinAsOid(String domainType, String instanceIdEncoded) {
        String instanceIdUnencoded = UrlDecoderUtils.urlDecode(instanceIdEncoded);
        return OidUtils.getOidMarshaller().joinAsOid(domainType, instanceIdUnencoded);
    }

    public static ObjectAdapter getObjectAdapterElseNull(RendererContext resourceContext, String domainType, String instanceId) throws ObjectNotFoundException {
        try {
            return OidUtils.getObjectAdapterElseThrowNotFound(resourceContext, domainType, instanceId);
        }
        catch (ObjectNotFoundException ex) {
            return null;
        }
    }

    public static ObjectAdapter getObjectAdapterElseThrowNotFound(RendererContext resourceContext, String domainType, String instanceId) throws ObjectNotFoundException {
        String oidStr = OidUtils.joinAsOid(domainType, instanceId);
        return OidUtils.getObjectAdapterForUnencodedElseThrowNotFound(resourceContext, oidStr);
    }

    public static ObjectAdapter getObjectAdapterElseNull(RendererContext resourceContext, String oidEncodedStr) {
        try {
            return OidUtils.getObjectAdapterElseThrowNotFound(resourceContext, oidEncodedStr);
        }
        catch (ObjectNotFoundException ex) {
            return null;
        }
    }

    public static ObjectAdapter getObjectAdapterElseThrowNotFound(RendererContext resourceContext, String oidEncodedStr) {
        String oidStr = UrlDecoderUtils.urlDecode(oidEncodedStr);
        return OidUtils.getObjectAdapterForUnencodedElseThrowNotFound(resourceContext, oidStr);
    }

    private static ObjectAdapter getObjectAdapterForUnencodedElseThrowNotFound(RendererContext resourceContext, String oidStr) {
        RootOid rootOid = RootOidDefault.deStringEncoded((String)oidStr, (OidMarshaller)OidUtils.getOidMarshaller());
        return resourceContext.getPersistenceSession().loadObject((TypedOid)rootOid);
    }

    private static OidMarshaller getOidMarshaller() {
        return new OidMarshaller();
    }
}

