/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import com.google.common.io.Resources;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.server.resources.HomePageReprRenderer;

public class VersionReprRenderer
extends ReprRendererAbstract<VersionReprRenderer, Void> {
    private static final String META_INF_POM_PROPERTIES = "/META-INF/maven/org.apache.isis.viewer/isis-viewer-restfulobjects-server/pom.properties";

    VersionReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.VERSION, representation);
    }

    public VersionReprRenderer with(Void t) {
        return this;
    }

    public JsonRepresentation render() {
        if (this.includesSelf) {
            this.addLinkToSelf();
            this.addLinkToUp();
        }
        this.representation.mapPut("specVersion", "1.0.0");
        this.representation.mapPut("implVersion", VersionReprRenderer.versionFromManifest());
        this.putOptionalCapabilities();
        this.putExtensions();
        return this.representation;
    }

    private void addLinkToSelf() {
        JsonRepresentation link = LinkBuilder.newBuilder((RendererContext)this.getRendererContext(), (String)Rel.SELF.getName(), (RepresentationType)RepresentationType.VERSION, (String)"version", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            VersionReprRenderer renderer = new VersionReprRenderer(this.getRendererContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToUp() {
        JsonRepresentation link = LinkBuilder.newBuilder((RendererContext)this.rendererContext, (String)Rel.UP.getName(), (RepresentationType)RepresentationType.HOME_PAGE, (String)"", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            HomePageReprRenderer renderer = new HomePageReprRenderer(this.getRendererContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private static String versionFromManifest() {
        try {
            URL resource = Resources.getResource((String)META_INF_POM_PROPERTIES);
            Properties p = new Properties();
            p.load((Reader)Resources.newReaderSupplier((URL)resource, (Charset)Charset.defaultCharset()).getInput());
            return p.getProperty("version");
        }
        catch (Exception ex) {
            return "UNKNOWN";
        }
    }

    private void putOptionalCapabilities() {
        JsonRepresentation optionalCapabilities = JsonRepresentation.newMap((String[])new String[0]);
        optionalCapabilities.mapPut("blobsClobs", "yes");
        optionalCapabilities.mapPut("deleteObjects", "yes");
        optionalCapabilities.mapPut("domainModel", "formal");
        optionalCapabilities.mapPut("validateOnly", "yes");
        optionalCapabilities.mapPut("protoPersistentObjects", "yes");
        this.representation.mapPut("optionalCapabilities", optionalCapabilities);
    }

    private void putExtensions() {
        this.representation.mapPut("extensions", JsonRepresentation.newMap((String[])new String[0]));
    }
}

