/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.server.resources.HomePageReprRenderer;

public class UserReprRenderer
extends ReprRendererAbstract<UserReprRenderer, AuthenticationSession> {
    UserReprRenderer(RendererContext rendererContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(rendererContext, linkFollower, RepresentationType.USER, representation);
    }

    public UserReprRenderer with(AuthenticationSession authenticationSession) {
        this.representation.mapPut("userName", authenticationSession.getUserName());
        JsonRepresentation roles = JsonRepresentation.newArray();
        for (String role : authenticationSession.getRoles()) {
            roles.arrayAdd(role);
        }
        this.representation.mapPut("roles", roles);
        return this;
    }

    public JsonRepresentation render() {
        if (this.includesSelf) {
            this.addLinkToSelf();
            this.addLinkToUp();
        }
        this.getExtensions();
        return this.representation;
    }

    private void addLinkToSelf() {
        JsonRepresentation link = LinkBuilder.newBuilder((RendererContext)this.getRendererContext(), (String)Rel.SELF.getName(), (RepresentationType)RepresentationType.USER, (String)"user", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            UserReprRenderer renderer = new UserReprRenderer(this.getRendererContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            renderer.with(this.getRendererContext().getAuthenticationSession());
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToUp() {
        JsonRepresentation link = LinkBuilder.newBuilder((RendererContext)this.rendererContext, (String)Rel.UP.getName(), (RepresentationType)RepresentationType.HOME_PAGE, (String)"", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            HomePageReprRenderer renderer = new HomePageReprRenderer(this.getRendererContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }
}

