/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.services.ServiceUtil;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.util.JsonMapper;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.isis.viewer.restfulobjects.server.ResourceContext;
import org.apache.isis.viewer.restfulobjects.server.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.server.resources.DomainResourceHelper;
import org.apache.isis.viewer.restfulobjects.server.util.OidUtils;
import org.apache.isis.viewer.restfulobjects.server.util.UrlDecoderUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;

public abstract class ResourceAbstract {
    protected static final JsonMapper jsonMapper = JsonMapper.instance();
    public static final ActionType[] ACTION_TYPES = new ActionType[]{ActionType.USER, ActionType.DEBUG, ActionType.EXPLORATION};
    private static final String UTC_DATEFORMAT = "yyyy-MM-ddTHH:mm:ss.sss";
    @Context
    HttpHeaders httpHeaders;
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    @Context
    HttpServletRequest httpServletRequest;
    @Context
    HttpServletResponse httpServletResponse;
    @Context
    SecurityContext securityContext;
    private ResourceContext resourceContext;

    protected void init(Where where) {
        this.init(RepresentationType.GENERIC, where);
    }

    protected void init(RepresentationType representationType, Where where) {
        this.init(representationType, where, (String)null);
    }

    protected void init(RepresentationType representationType, Where where, InputStream arguments) {
        String queryString = DomainResourceHelper.asStringUtf8(arguments);
        this.init(representationType, where, queryString);
    }

    protected void init(RepresentationType representationType, Where where, String queryString) {
        if (!IsisContext.inSession()) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.UNAUTHORIZED);
        }
        if (this.getAuthenticationSession() == null) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.UNAUTHORIZED);
        }
        this.resourceContext = new ResourceContext(representationType, this.httpHeaders, this.uriInfo, this.request, where, queryString, this.httpServletRequest, this.httpServletResponse, this.securityContext, this.getLocalization(), this.getAuthenticationSession(), this.getPersistenceSession(), this.getAdapterManager(), (SpecificationLoader)this.getSpecificationLoader(), this.getConfiguration());
    }

    protected ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    protected static String jsonFor(Object object) {
        try {
            return jsonMapper.write(object);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ObjectSpecification getSpecification(String specFullName) {
        return this.getSpecificationLoader().loadSpecification(specFullName);
    }

    protected ObjectAdapter getObjectAdapterElseThrowNotFound(String domainType, String instanceId) {
        ObjectAdapter objectAdapter = this.getObjectAdapterElseNull(domainType, instanceId);
        if (objectAdapter == null) {
            String instanceIdUnencoded = UrlDecoderUtils.urlDecode(instanceId);
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.NOT_FOUND, "could not determine adapter for OID: '%s:%s'", domainType, instanceIdUnencoded);
        }
        return objectAdapter;
    }

    protected ObjectAdapter getObjectAdapterElseNull(String domainType, String instanceId) {
        return OidUtils.getObjectAdapterElseNull(this.resourceContext, domainType, instanceId);
    }

    protected ObjectAdapter getServiceAdapter(String serviceId) {
        List serviceAdapters = this.getPersistenceSession().getServices();
        for (ObjectAdapter serviceAdapter : serviceAdapters) {
            Object servicePojo = serviceAdapter.getObject();
            String id = ServiceUtil.id((Object)servicePojo);
            if (!serviceId.equals(id)) continue;
            return serviceAdapter;
        }
        throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.NOT_FOUND, "Could not locate service '%s'", serviceId);
    }

    public static Response.ResponseBuilder responseOfNoContent() {
        return ResourceAbstract.responseOf(RestfulResponse.HttpStatusCode.NO_CONTENT);
    }

    public static Response.ResponseBuilder responseOfOk(ReprRenderer<?, ?> renderer, Caching caching) {
        return ResourceAbstract.responseOfOk(renderer, caching, null);
    }

    public static Response.ResponseBuilder responseOfOk(ReprRenderer<?, ?> renderer, Caching caching, Version version) {
        MediaType mediaType = renderer.getMediaType();
        Response.ResponseBuilder response = ResourceAbstract.responseOf(RestfulResponse.HttpStatusCode.OK).type(mediaType).cacheControl(caching.getCacheControl()).entity((Object)ResourceAbstract.jsonFor(renderer.render()));
        return ResourceAbstract.addLastModifiedAndETagIfAvailable(response, version);
    }

    protected static Response.ResponseBuilder responseOf(RestfulResponse.HttpStatusCode httpStatusCode) {
        return Response.status((Response.StatusType)httpStatusCode.getJaxrsStatusType()).type(MediaType.APPLICATION_JSON_TYPE);
    }

    public static Response.ResponseBuilder addLastModifiedAndETagIfAvailable(Response.ResponseBuilder responseBuilder, Version version) {
        if (version != null && version.getTime() != null) {
            Date time = version.getTime();
            responseBuilder.lastModified(time);
            responseBuilder.tag(ResourceAbstract.asETag(time));
        }
        return responseBuilder;
    }

    private static EntityTag asETag(Date time) {
        SimpleDateFormat sdf = new SimpleDateFormat(UTC_DATEFORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String utcTime = sdf.format(time);
        return new EntityTag(utcTime, true);
    }

    protected IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    protected AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected Localization getLocalization() {
        return IsisContext.getLocalization();
    }

    protected OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }

    protected HttpServletRequest getServletRequest() {
        return this.getResourceContext().getHttpServletRequest();
    }

    public static enum Caching {
        ONE_DAY(86400),
        ONE_HOUR(3600),
        NONE(0);

        private final CacheControl cacheControl = new CacheControl();

        private Caching(int maxAge) {
            if (maxAge > 0) {
                this.cacheControl.setMaxAge(maxAge);
            } else {
                this.cacheControl.setNoCache(true);
            }
        }

        public CacheControl getCacheControl() {
            return this.cacheControl;
        }
    }
}

