/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import com.google.common.base.Strings;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.DomainTypeResource;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ActionDescriptionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ActionParameterDescriptionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.CollectionDescriptionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.DomainTypeReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndAction;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndActionParam;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndCollection;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndFeature;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.PropertyDescriptionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.TypeActionResultReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.TypeListReprRenderer;
import org.apache.isis.viewer.restfulobjects.server.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.server.resources.DomainResourceHelper;
import org.apache.isis.viewer.restfulobjects.server.resources.ResourceAbstract;
import org.apache.isis.viewer.restfulobjects.server.util.UrlParserUtils;

@Path(value="/domain-types")
public class DomainTypeResourceServerside
extends ResourceAbstract
implements DomainTypeResource {
    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/type-list"})
    public Response domainTypes() {
        RepresentationType representationType = RepresentationType.TYPE_LIST;
        this.init(representationType, Where.ANYWHERE);
        Collection allSpecifications = this.getSpecificationLoader().allSpecifications();
        TypeListReprRenderer renderer = new TypeListReprRenderer((RendererContext)this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.with(allSpecifications).includesSelf();
        return DomainTypeResourceServerside.responseOfOk(renderer, ResourceAbstract.Caching.ONE_DAY).build();
    }

    @GET
    @Path(value="/{domainType}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/domain-type"})
    public Response domainType(@PathParam(value="domainType") String domainType) {
        this.init(RepresentationType.DOMAIN_TYPE, Where.ANYWHERE);
        ObjectSpecification objectSpec = this.getSpecificationLoader().lookupBySpecId(ObjectSpecId.of((String)domainType));
        DomainTypeReprRenderer renderer = new DomainTypeReprRenderer((RendererContext)this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.with(objectSpec).includesSelf();
        return DomainTypeResourceServerside.responseOfOk(renderer, ResourceAbstract.Caching.ONE_DAY).build();
    }

    @GET
    @Path(value="/{domainType}/properties/{propertyId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/property-description"})
    public Response typeProperty(@PathParam(value="domainType") String domainType, @PathParam(value="propertyId") String propertyId) {
        RepresentationType representationType = RepresentationType.PROPERTY_DESCRIPTION;
        this.init(representationType, Where.ANYWHERE);
        ObjectSpecification parentSpec = this.getSpecificationLoader().lookupBySpecId(ObjectSpecId.of((String)domainType));
        if (parentSpec == null) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_FOUND);
        }
        ObjectAssociation objectMember = parentSpec.getAssociation(propertyId);
        if (objectMember == null || objectMember.isOneToManyAssociation()) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_FOUND);
        }
        OneToOneAssociation property = (OneToOneAssociation)objectMember;
        PropertyDescriptionReprRenderer renderer = new PropertyDescriptionReprRenderer((RendererContext)this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        ((PropertyDescriptionReprRenderer)renderer.with((ParentSpecAndFeature)new ParentSpecAndProperty(parentSpec, property))).includesSelf();
        return DomainTypeResourceServerside.responseOfOk(renderer, ResourceAbstract.Caching.ONE_DAY).build();
    }

    @GET
    @Path(value="/{domainType}/collections/{collectionId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/collection-description"})
    public Response typeCollection(@PathParam(value="domainType") String domainType, @PathParam(value="collectionId") String collectionId) {
        RepresentationType representationType = RepresentationType.COLLECTION_DESCRIPTION;
        this.init(representationType, Where.ANYWHERE);
        ObjectSpecification parentSpec = this.getSpecificationLoader().lookupBySpecId(ObjectSpecId.of((String)domainType));
        if (parentSpec == null) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_FOUND);
        }
        ObjectAssociation objectMember = parentSpec.getAssociation(collectionId);
        if (objectMember == null || objectMember.isOneToOneAssociation()) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_FOUND);
        }
        OneToManyAssociation collection = (OneToManyAssociation)objectMember;
        CollectionDescriptionReprRenderer renderer = new CollectionDescriptionReprRenderer((RendererContext)this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        ((CollectionDescriptionReprRenderer)renderer.with((ParentSpecAndFeature)new ParentSpecAndCollection(parentSpec, collection))).includesSelf();
        return DomainTypeResourceServerside.responseOfOk(renderer, ResourceAbstract.Caching.ONE_DAY).build();
    }

    @GET
    @Path(value="/{domainType}/actions/{actionId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-description"})
    public Response typeAction(@PathParam(value="domainType") String domainType, @PathParam(value="actionId") String actionId) {
        RepresentationType representationType = RepresentationType.ACTION_DESCRIPTION;
        this.init(representationType, Where.ANYWHERE);
        ObjectSpecification parentSpec = this.getSpecificationLoader().lookupBySpecId(ObjectSpecId.of((String)domainType));
        if (parentSpec == null) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_FOUND);
        }
        ObjectAction objectMember = parentSpec.getObjectAction(actionId);
        if (objectMember == null) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_FOUND);
        }
        ObjectAction action = objectMember;
        ActionDescriptionReprRenderer renderer = new ActionDescriptionReprRenderer((RendererContext)this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        ((ActionDescriptionReprRenderer)renderer.with((ParentSpecAndFeature)new ParentSpecAndAction(parentSpec, action))).includesSelf();
        return DomainTypeResourceServerside.responseOfOk(renderer, ResourceAbstract.Caching.ONE_DAY).build();
    }

    @GET
    @Path(value="/{domainType}/actions/{actionId}/params/{paramName}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-param-description"})
    public Response typeActionParam(@PathParam(value="domainType") String domainType, @PathParam(value="actionId") String actionId, @PathParam(value="paramName") String paramName) {
        RepresentationType representationType = RepresentationType.ACTION_PARAMETER_DESCRIPTION;
        this.init(representationType, Where.ANYWHERE);
        ObjectSpecification parentSpec = this.getSpecificationLoader().lookupBySpecId(ObjectSpecId.of((String)domainType));
        if (parentSpec == null) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_FOUND);
        }
        ObjectAction objectMember = parentSpec.getObjectAction(actionId);
        if (objectMember == null) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_FOUND);
        }
        ObjectAction parentAction = objectMember;
        ObjectActionParameter actionParam = parentAction.getParameterByName(paramName);
        ActionParameterDescriptionReprRenderer renderer = new ActionParameterDescriptionReprRenderer((RendererContext)this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.with((ParentSpecAndFeature)new ParentSpecAndActionParam(parentSpec, actionParam)).includesSelf();
        return DomainTypeResourceServerside.responseOfOk(renderer, ResourceAbstract.Caching.ONE_DAY).build();
    }

    @GET
    @Path(value="/{domainType}/type-actions/isSubtypeOf/invoke")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/type-action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response domainTypeIsSubtypeOf(@PathParam(value="domainType") String domainType, @QueryParam(value="supertype") String superTypeStr, @QueryParam(value="args") String args) {
        this.init(Where.ANYWHERE);
        String supertype = DomainTypeResourceServerside.domainTypeFor(superTypeStr, args, "supertype");
        ObjectSpecification domainTypeSpec = this.getSpecificationLoader().lookupBySpecId(ObjectSpecId.of((String)domainType));
        ObjectSpecification supertypeSpec = this.getSpecificationLoader().lookupBySpecId(ObjectSpecId.of((String)supertype));
        TypeActionResultReprRenderer renderer = new TypeActionResultReprRenderer((RendererContext)this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        String url = "domain-types/" + domainType + "/type-actions/isSubtypeOf/invoke";
        LinkBuilder linkBuilder = LinkBuilder.newBuilder((RendererContext)this.getResourceContext(), (String)Rel.SELF.getName(), (RepresentationType)RepresentationType.TYPE_ACTION_RESULT, (String)url, (Object[])new Object[0]);
        JsonRepresentation arguments = DomainTypeReprRenderer.argumentsTo((RendererContext)this.getResourceContext(), (String)"supertype", (ObjectSpecification)supertypeSpec);
        JsonRepresentation selfLink = linkBuilder.withArguments(arguments).build();
        boolean value = domainTypeSpec.isOfType(supertypeSpec);
        renderer.with(domainTypeSpec).withSelf(selfLink).withValue((Object)value);
        return DomainTypeResourceServerside.responseOfOk(renderer, ResourceAbstract.Caching.ONE_DAY).build();
    }

    @GET
    @Path(value="/{domainType}/type-actions/isSupertypeOf/invoke")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/type-action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response domainTypeIsSupertypeOf(@PathParam(value="domainType") String domainType, @QueryParam(value="subtype") String subTypeStr, @QueryParam(value="args") String args) {
        this.init(Where.ANYWHERE);
        String subtype = DomainTypeResourceServerside.domainTypeFor(subTypeStr, args, "subtype");
        ObjectSpecification domainTypeSpec = this.getSpecificationLoader().lookupBySpecId(ObjectSpecId.of((String)domainType));
        ObjectSpecification subtypeSpec = this.getSpecificationLoader().lookupBySpecId(ObjectSpecId.of((String)subtype));
        TypeActionResultReprRenderer renderer = new TypeActionResultReprRenderer((RendererContext)this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        String url = "domain-types/" + domainType + "/type-actions/isSupertypeOf/invoke";
        LinkBuilder linkBuilder = LinkBuilder.newBuilder((RendererContext)this.getResourceContext(), (String)Rel.SELF.getName(), (RepresentationType)RepresentationType.TYPE_ACTION_RESULT, (String)url, (Object[])new Object[0]);
        JsonRepresentation arguments = DomainTypeReprRenderer.argumentsTo((RendererContext)this.getResourceContext(), (String)"subtype", (ObjectSpecification)subtypeSpec);
        JsonRepresentation selfLink = linkBuilder.withArguments(arguments).build();
        boolean value = subtypeSpec.isOfType(domainTypeSpec);
        renderer.with(domainTypeSpec).withSelf(selfLink).withValue((Object)value);
        return DomainTypeResourceServerside.responseOfOk(renderer, ResourceAbstract.Caching.ONE_DAY).build();
    }

    private static String domainTypeFor(String domainTypeStr, String argumentsQueryString, String argsParamName) {
        if (!Strings.isNullOrEmpty((String)domainTypeStr)) {
            return domainTypeStr;
        }
        String href = DomainTypeResourceServerside.linkFromFormalArgs(argumentsQueryString, argsParamName);
        return UrlParserUtils.domainTypeFrom(href);
    }

    private static String linkFromFormalArgs(String argumentsQueryString, String paramName) {
        JsonRepresentation arguments = DomainResourceHelper.readQueryStringAsMap(argumentsQueryString);
        if (!arguments.isLink(paramName)) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "Args should contain a link '%s'", paramName);
        }
        return arguments.getLink(paramName).getHref();
    }
}

