/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.DomainServiceResource;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainServiceLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ListReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.server.resources.DomainResourceHelper;
import org.apache.isis.viewer.restfulobjects.server.resources.DomainServicesListReprRenderer;
import org.apache.isis.viewer.restfulobjects.server.resources.ResourceAbstract;

@Path(value="/services")
public class DomainServiceResourceServerside
extends ResourceAbstract
implements DomainServiceResource {
    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/list", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response services() {
        this.init(RepresentationType.LIST, Where.STANDALONE_TABLES);
        List<ObjectAdapter> serviceAdapters = this.getResourceContext().getServiceAdapters();
        DomainServicesListReprRenderer renderer = new DomainServicesListReprRenderer(this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        ((ListReprRenderer)renderer.usingLinkToBuilder((ObjectAdapterLinkTo)new DomainServiceLinkTo()).includesSelf()).with(serviceAdapters);
        return DomainServiceResourceServerside.responseOfOk(renderer, ResourceAbstract.Caching.ONE_DAY).build();
    }

    @GET
    @Path(value="/{serviceId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response service(@PathParam(value="serviceId") String serviceId) {
        this.init(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS);
        ObjectAdapter serviceAdapter = this.getServiceAdapter(serviceId);
        DomainObjectReprRenderer renderer = new DomainObjectReprRenderer((RendererContext)this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.usingLinkToBuilder((ObjectAdapterLinkTo)new DomainServiceLinkTo()).with(serviceAdapter).includesSelf();
        return DomainServiceResourceServerside.responseOfOk(renderer, ResourceAbstract.Caching.ONE_DAY).build();
    }

    @GET
    @Path(value="/{serviceId}/properties/{propertyId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-property", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response propertyDetails(@PathParam(value="serviceId") String serviceId, @PathParam(value="propertyId") String propertyId) {
        this.init(RepresentationType.OBJECT_PROPERTY, Where.OBJECT_FORMS);
        ObjectAdapter serviceAdapter = this.getServiceAdapter(serviceId);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), serviceAdapter).using((ObjectAdapterLinkTo)new DomainServiceLinkTo());
        return helper.propertyDetails(propertyId, DomainResourceHelper.MemberMode.NOT_MUTATING, ResourceAbstract.Caching.ONE_DAY, this.getResourceContext().getWhere());
    }

    @GET
    @Path(value="/{serviceId}/actions/{actionId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-action", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response actionPrompt(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId) {
        this.init(RepresentationType.OBJECT_ACTION, Where.OBJECT_FORMS);
        ObjectAdapter serviceAdapter = this.getServiceAdapter(serviceId);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), serviceAdapter).using((ObjectAdapterLinkTo)new DomainServiceLinkTo());
        return helper.actionPrompt(actionId, this.getResourceContext().getWhere());
    }

    @GET
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeActionQueryOnly(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId, @QueryParam(value="x-isis-querystring") String xIsisQueryString) {
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, xIsisQueryString);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter serviceAdapter = this.getServiceAdapter(serviceId);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), serviceAdapter).using((ObjectAdapterLinkTo)new DomainServiceLinkTo());
        return helper.invokeActionQueryOnly(actionId, arguments, this.getResourceContext().getWhere());
    }

    @PUT
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeActionIdempotent(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId, InputStream body) {
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, body);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter serviceAdapter = this.getServiceAdapter(serviceId);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), serviceAdapter).using((ObjectAdapterLinkTo)new DomainServiceLinkTo());
        return helper.invokeActionIdempotent(actionId, arguments, this.getResourceContext().getWhere());
    }

    @POST
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeAction(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId, InputStream body) {
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, body);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter serviceAdapter = this.getServiceAdapter(serviceId);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), serviceAdapter).using((ObjectAdapterLinkTo)new DomainServiceLinkTo());
        return helper.invokeAction(actionId, arguments, this.getResourceContext().getWhere());
    }
}

