/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociationFilters;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.util.JsonMapper;
import org.apache.isis.viewer.restfulobjects.applib.util.UrlEncodingUtils;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.AbstractObjectMemberReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ActionResultReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MemberType;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectActionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndAction;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndCollection;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndMember;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectCollectionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectPropertyReprRenderer;
import org.apache.isis.viewer.restfulobjects.server.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.server.resources.ResourceAbstract;
import org.apache.isis.viewer.restfulobjects.server.util.OidUtils;
import org.apache.isis.viewer.restfulobjects.server.util.UrlDecoderUtils;
import org.apache.isis.viewer.restfulobjects.server.util.UrlParserUtils;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;

public final class DomainResourceHelper {
    private static final DateFormat ETAG_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final RendererContext resourceContext;
    private ObjectAdapterLinkTo adapterLinkTo;
    private final ObjectAdapter objectAdapter;

    public DomainResourceHelper(RendererContext resourceContext, ObjectAdapter objectAdapter) {
        this.resourceContext = resourceContext;
        this.objectAdapter = objectAdapter;
        this.using((ObjectAdapterLinkTo)new DomainObjectLinkTo());
    }

    public DomainResourceHelper using(ObjectAdapterLinkTo linkTo) {
        this.adapterLinkTo = linkTo;
        this.adapterLinkTo.usingUrlBase(this.resourceContext).with(this.objectAdapter);
        return this;
    }

    static boolean copyOverProperties(RendererContext resourceContext, ObjectAdapter objectAdapter, JsonRepresentation propertiesList) {
        ObjectSpecification objectSpec = objectAdapter.getSpecification();
        List properties = objectSpec.getAssociations(ObjectAssociationFilters.PROPERTIES);
        boolean allOk = true;
        for (ObjectAssociation association : properties) {
            ObjectAdapter valueAdapter;
            OneToOneAssociation property = (OneToOneAssociation)association;
            ObjectSpecification propertySpec = property.getSpecification();
            String id = property.getId();
            JsonRepresentation propertyRepr = propertiesList.getRepresentation("[id=%s]", new Object[]{id});
            if (propertyRepr == null) {
                if (!property.isMandatory()) continue;
                throw new IllegalArgumentException(String.format("Mandatory field %s missing", property.getName()));
            }
            JsonRepresentation valueRepr = propertyRepr.getRepresentation("value", new Object[0]);
            Consent usable = property.isUsable(resourceContext.getAuthenticationSession(), objectAdapter, resourceContext.getWhere());
            if (usable.isVetoed()) {
                propertyRepr.mapPut("invalidReason", usable.getReason());
                allOk = false;
                continue;
            }
            try {
                valueAdapter = DomainResourceHelper.objectAdapterFor(resourceContext, propertySpec, valueRepr);
            }
            catch (IllegalArgumentException ex) {
                propertyRepr.mapPut("invalidReason", ex.getMessage());
                allOk = false;
                continue;
            }
            Consent consent = property.isAssociationValid(objectAdapter, valueAdapter);
            if (consent.isAllowed()) {
                try {
                    property.set(objectAdapter, valueAdapter);
                }
                catch (IllegalArgumentException ex) {
                    propertyRepr.mapPut("invalidReason", ex.getMessage());
                    allOk = false;
                }
                continue;
            }
            propertyRepr.mapPut("invalidReason", consent.getReason());
            allOk = false;
        }
        return allOk;
    }

    public Response objectRepresentation() {
        DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.with(this.objectAdapter).includesSelf();
        Response.ResponseBuilder respBuilder = ResourceAbstract.responseOfOk(renderer, ResourceAbstract.Caching.NONE);
        Version version = this.objectAdapter.getVersion();
        if (version != null && version.getTime() != null) {
            respBuilder.tag(ETAG_FORMAT.format(version.getTime()));
        }
        return respBuilder.build();
    }

    Response propertyDetails(String propertyId, MemberMode memberMode, ResourceAbstract.Caching caching, Where where) {
        OneToOneAssociation property = this.getPropertyThatIsVisibleForIntent(propertyId, Intent.ACCESS, where);
        ObjectPropertyReprRenderer renderer = new ObjectPropertyReprRenderer(this.resourceContext, null, null, JsonRepresentation.newMap((String[])new String[0]));
        ((ObjectPropertyReprRenderer)renderer.with((ObjectAndMember)new ObjectAndProperty(this.objectAdapter, property))).usingLinkTo(this.adapterLinkTo);
        memberMode.apply((AbstractObjectMemberReprRenderer<?, ?>)renderer);
        return ResourceAbstract.responseOfOk(renderer, caching).build();
    }

    Response collectionDetails(String collectionId, MemberMode memberMode, ResourceAbstract.Caching caching, Where where) {
        OneToManyAssociation collection = this.getCollectionThatIsVisibleForIntent(collectionId, Intent.ACCESS, where);
        ObjectCollectionReprRenderer renderer = new ObjectCollectionReprRenderer(this.resourceContext, null, null, JsonRepresentation.newMap((String[])new String[0]));
        ((ObjectCollectionReprRenderer)renderer.with((ObjectAndMember)new ObjectAndCollection(this.objectAdapter, collection))).usingLinkTo(this.adapterLinkTo);
        memberMode.apply((AbstractObjectMemberReprRenderer<?, ?>)renderer);
        return ResourceAbstract.responseOfOk(renderer, caching).build();
    }

    Response actionPrompt(String actionId, Where where) {
        ObjectAction action = this.getObjectActionThatIsVisibleForIntent(actionId, Intent.ACCESS, where);
        ObjectActionReprRenderer renderer = new ObjectActionReprRenderer(this.resourceContext, null, null, JsonRepresentation.newMap((String[])new String[0]));
        ((ObjectActionReprRenderer)((ObjectActionReprRenderer)renderer.with((ObjectAndMember)new ObjectAndAction(this.objectAdapter, action))).usingLinkTo(this.adapterLinkTo)).asStandalone();
        return ResourceAbstract.responseOfOk(renderer, ResourceAbstract.Caching.NONE).build();
    }

    Response invokeActionQueryOnly(String actionId, JsonRepresentation arguments, Where where) {
        ObjectAction action = this.getObjectActionThatIsVisibleForIntent(actionId, Intent.MUTATE, where);
        ActionSemantics.Of actionSemantics = action.getSemantics();
        if (actionSemantics != ActionSemantics.Of.SAFE) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, "Method not allowed; action '%s' is not query only", action.getId());
        }
        return this.invokeActionUsingAdapters(action, arguments, ActionResultReprRenderer.SelfLink.INCLUDED);
    }

    Response invokeActionIdempotent(String actionId, JsonRepresentation arguments, Where where) {
        ObjectAction action = this.getObjectActionThatIsVisibleForIntent(actionId, Intent.MUTATE, where);
        ActionSemantics.Of actionSemantics = action.getSemantics();
        if (!actionSemantics.isIdempotentInNature()) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, "Method not allowed; action '%s' is not idempotent", action.getId());
        }
        return this.invokeActionUsingAdapters(action, arguments, ActionResultReprRenderer.SelfLink.EXCLUDED);
    }

    Response invokeAction(String actionId, JsonRepresentation arguments, Where where) {
        ObjectAction action = this.getObjectActionThatIsVisibleForIntent(actionId, Intent.MUTATE, where);
        return this.invokeActionUsingAdapters(action, arguments, ActionResultReprRenderer.SelfLink.EXCLUDED);
    }

    private Response invokeActionUsingAdapters(ObjectAction action, JsonRepresentation arguments, ActionResultReprRenderer.SelfLink selfLink) {
        List<ObjectAdapter> argAdapters = this.parseAndValidateArguments(action, arguments);
        ObjectAdapter[] argArray2 = argAdapters.toArray(new ObjectAdapter[0]);
        ObjectAdapter returnedAdapter = action.execute(this.objectAdapter, argArray2);
        ActionResultReprRenderer renderer = new ActionResultReprRenderer(this.resourceContext, null, selfLink, JsonRepresentation.newMap((String[])new String[0]));
        renderer.with(new ObjectAndActionInvocation(this.objectAdapter, action, arguments, returnedAdapter)).using(this.adapterLinkTo);
        Response.ResponseBuilder respBuilder = ResourceAbstract.responseOfOk(renderer, ResourceAbstract.Caching.NONE);
        Version version = this.objectAdapter.getVersion();
        ResourceAbstract.addLastModifiedAndETagIfAvailable(respBuilder, version);
        return respBuilder.build();
    }

    private static ObjectAdapter objectAdapterFor(RendererContext resourceContext, ObjectSpecification objectSpec, JsonRepresentation argRepr) {
        if (argRepr == null) {
            return null;
        }
        if (objectSpec.isEncodeable()) {
            return JsonValueEncoder.asAdapter((ObjectSpecification)objectSpec, (JsonRepresentation)argRepr);
        }
        JsonRepresentation argValueRepr = argRepr.getRepresentation("value", new Object[0]);
        if (argValueRepr == null) {
            String reason = "No 'value' key";
            argRepr.mapPut("invalidReason", reason);
            throw new IllegalArgumentException(reason);
        }
        if (!argValueRepr.isLink()) {
            String reason = "Expected a link (because this object's type is not a value) but found no 'href'";
            argRepr.mapPut("invalidReason", "Expected a link (because this object's type is not a value) but found no 'href'");
            throw new IllegalArgumentException("Expected a link (because this object's type is not a value) but found no 'href'");
        }
        String oidFromHref = UrlParserUtils.encodedOidFromLink(argValueRepr);
        if (oidFromHref == null) {
            String reason = "Could not parse 'href' to identify the object's OID";
            argRepr.mapPut("invalidReason", "Could not parse 'href' to identify the object's OID");
            throw new IllegalArgumentException("Could not parse 'href' to identify the object's OID");
        }
        ObjectAdapter objectAdapter = OidUtils.getObjectAdapterElseNull(resourceContext, oidFromHref);
        if (objectAdapter == null) {
            String reason = "'href' does not reference a known entity";
            argRepr.mapPut("invalidReason", "'href' does not reference a known entity");
            throw new IllegalArgumentException("'href' does not reference a known entity");
        }
        return objectAdapter;
    }

    ObjectAdapter objectAdapterFor(ObjectSpecification spec, String urlEncodedJson) throws JsonParseException, JsonMappingException, IOException {
        String json = UrlDecoderUtils.urlDecode(urlEncodedJson);
        JsonRepresentation representation = JsonMapper.instance().read(json);
        return DomainResourceHelper.objectAdapterFor(this.resourceContext, spec, representation);
    }

    protected OneToOneAssociation getPropertyThatIsVisibleForIntent(String propertyId, Intent intent, Where where) {
        ObjectAssociation association;
        try {
            ObjectSpecification specification = this.objectAdapter.getSpecification();
            association = specification.getAssociation(propertyId);
        }
        catch (Exception ex) {
            DomainResourceHelper.throwNotFoundException(propertyId, MemberType.PROPERTY);
            return null;
        }
        if (association == null || !association.isOneToOneAssociation()) {
            DomainResourceHelper.throwNotFoundException(propertyId, MemberType.PROPERTY);
        }
        OneToOneAssociation property = (OneToOneAssociation)association;
        return this.memberThatIsVisibleForIntent(property, MemberType.PROPERTY, intent, where);
    }

    protected OneToManyAssociation getCollectionThatIsVisibleForIntent(String collectionId, Intent intent, Where where) {
        ObjectAssociation association;
        try {
            ObjectSpecification specification = this.objectAdapter.getSpecification();
            association = specification.getAssociation(collectionId);
        }
        catch (Exception ex) {
            DomainResourceHelper.throwNotFoundException(collectionId, MemberType.COLLECTION);
            return null;
        }
        if (association == null || !association.isOneToManyAssociation()) {
            DomainResourceHelper.throwNotFoundException(collectionId, MemberType.COLLECTION);
        }
        OneToManyAssociation collection = (OneToManyAssociation)association;
        return this.memberThatIsVisibleForIntent(collection, MemberType.COLLECTION, intent, where);
    }

    protected ObjectAction getObjectActionThatIsVisibleForIntent(String actionId, Intent intent, Where where) {
        ObjectAction action;
        try {
            ObjectSpecification specification = this.objectAdapter.getSpecification();
            action = specification.getObjectAction(actionId);
        }
        catch (Exception ex) {
            DomainResourceHelper.throwNotFoundException(actionId, MemberType.ACTION);
            return null;
        }
        if (action == null) {
            DomainResourceHelper.throwNotFoundException(actionId, MemberType.ACTION);
        }
        return this.memberThatIsVisibleForIntent(action, MemberType.ACTION, intent, where);
    }

    protected <T extends ObjectMember> T memberThatIsVisibleForIntent(T objectMember, MemberType memberType, Intent intent, Where where) {
        Consent usable;
        String memberId = objectMember.getId();
        AuthenticationSession authenticationSession = this.resourceContext.getAuthenticationSession();
        if (objectMember.isVisible(authenticationSession, this.objectAdapter, where).isVetoed()) {
            DomainResourceHelper.throwNotFoundException(memberId, memberType);
        }
        if (intent.isMutate() && (usable = objectMember.isUsable(authenticationSession, this.objectAdapter, where)).isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.FORBIDDEN, usable.getReason(), new Object[0]);
        }
        return objectMember;
    }

    protected static void throwNotFoundException(String memberId, MemberType memberType) {
        String memberTypeStr = memberType.name().toLowerCase();
        throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.NOT_FOUND, "%s '%s' either does not exist or is not visible", memberTypeStr, memberId);
    }

    ObjectAdapter parseAsMapWithSingleValue(ObjectSpecification objectSpec, String bodyAsString) {
        JsonRepresentation arguments = DomainResourceHelper.readAsMap(bodyAsString);
        return this.parseAsMapWithSingleValue(objectSpec, arguments);
    }

    ObjectAdapter parseAsMapWithSingleValue(ObjectSpecification objectSpec, JsonRepresentation arguments) {
        JsonRepresentation representation = arguments.getRepresentation("value", new Object[0]);
        if (arguments.size() != 1 || representation == null) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "Body should be a map with a single key 'value' whose value represents an instance of type '%s'", DomainResourceHelper.resourceFor(objectSpec));
        }
        return DomainResourceHelper.objectAdapterFor(this.resourceContext, objectSpec, representation);
    }

    private List<ObjectAdapter> parseAndValidateArguments(ObjectAction action, JsonRepresentation arguments) {
        List<JsonRepresentation> argList = DomainResourceHelper.argListFor(action, arguments);
        ArrayList argAdapters = Lists.newArrayList();
        List parameters = action.getParameters();
        boolean valid = true;
        for (int i = 0; i < argList.size(); ++i) {
            JsonRepresentation argRepr = argList.get(i);
            ObjectSpecification paramSpec = ((ObjectActionParameter)parameters.get(i)).getSpecification();
            try {
                ObjectAdapter argAdapter = DomainResourceHelper.objectAdapterFor(this.resourceContext, paramSpec, argRepr);
                argAdapters.add(argAdapter);
                ObjectActionParameter parameter = (ObjectActionParameter)parameters.get(i);
                Object argPojo = argAdapter != null ? argAdapter.getObject() : null;
                String reasonNotValid = parameter.isValid(this.objectAdapter, argPojo, null);
                if (reasonNotValid == null) continue;
                argRepr.mapPut("invalidReason", reasonNotValid);
                valid = false;
                continue;
            }
            catch (IllegalArgumentException e) {
                argAdapters.add(null);
                valid = false;
            }
        }
        ObjectAdapter[] argArray = argAdapters.toArray(new ObjectAdapter[0]);
        Consent consent = action.isProposedArgumentSetValid(this.objectAdapter, argArray);
        if (consent.isVetoed()) {
            arguments.mapPut("x-ro-invalidReason", consent.getReason());
            valid = false;
        }
        if (!valid) {
            throw RestfulObjectsApplicationException.createWithBody(RestfulResponse.HttpStatusCode.VALIDATION_FAILED, arguments, "Validation failed, see body for details", new Object[0]);
        }
        return argAdapters;
    }

    private static List<JsonRepresentation> argListFor(ObjectAction action, JsonRepresentation arguments) {
        ArrayList argList = Lists.newArrayList();
        for (Map.Entry arg : arguments.mapIterable()) {
            String argName = (String)arg.getKey();
            if (action.getParameterById(argName) != null) continue;
            String reason = String.format("Argument '%s' found but no such parameter", argName);
            arguments.mapPut("x-ro-invalidReason", reason);
            throw RestfulObjectsApplicationException.createWithBody(RestfulResponse.HttpStatusCode.BAD_REQUEST, arguments, reason, new Object[0]);
        }
        List parameters = action.getParameters();
        for (ObjectActionParameter param : parameters) {
            String paramId = param.getId();
            JsonRepresentation argRepr = arguments.getRepresentation(paramId, new Object[0]);
            if (argRepr == null && !param.isOptional()) {
                String reason = String.format("No argument found for (mandatory) parameter '%s'", paramId);
                arguments.mapPut("x-ro-invalidReason", reason);
                throw RestfulObjectsApplicationException.createWithBody(RestfulResponse.HttpStatusCode.BAD_REQUEST, arguments, reason, new Object[0]);
            }
            argList.add(argRepr);
        }
        return argList;
    }

    public static JsonRepresentation readParameterMapAsMap(Map<String, String[]> parameterMap) {
        JsonRepresentation map = JsonRepresentation.newMap((String[])new String[0]);
        for (Map.Entry<String, String[]> parameter : parameterMap.entrySet()) {
            map.mapPut(parameter.getKey(), parameter.getValue()[0]);
        }
        return map;
    }

    public static JsonRepresentation readQueryStringAsMap(String queryString) {
        String queryStringUrlDecoded;
        if (queryString == null) {
            return JsonRepresentation.newMap((String[])new String[0]);
        }
        String queryStringTrimmed = queryString.trim();
        if (queryStringTrimmed.isEmpty()) {
            return JsonRepresentation.newMap((String[])new String[0]);
        }
        try {
            queryStringUrlDecoded = UrlEncodingUtils.urlDecode((String)queryStringTrimmed);
        }
        catch (Exception ex) {
            queryStringUrlDecoded = queryStringTrimmed;
        }
        if (queryStringUrlDecoded.isEmpty()) {
            return JsonRepresentation.newMap((String[])new String[0]);
        }
        return DomainResourceHelper.read(queryStringUrlDecoded, "query string");
    }

    public static JsonRepresentation readAsMap(String body) {
        if (body == null) {
            return JsonRepresentation.newMap((String[])new String[0]);
        }
        String bodyTrimmed = body.trim();
        if (bodyTrimmed.isEmpty()) {
            return JsonRepresentation.newMap((String[])new String[0]);
        }
        return DomainResourceHelper.read(bodyTrimmed, "body");
    }

    private static JsonRepresentation read(String args, String argsNature) {
        try {
            JsonRepresentation jsonRepr = JsonMapper.instance().read(args);
            if (!jsonRepr.isMap()) {
                throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "could not read %s as a JSON map", argsNature);
            }
            return jsonRepr;
        }
        catch (JsonParseException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, (Exception)((Object)e), "could not parse %s", argsNature);
        }
        catch (JsonMappingException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, (Exception)((Object)e), "could not read %s as JSON", argsNature);
        }
        catch (IOException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, e, "could not parse %s", argsNature);
        }
    }

    public static String asStringUtf8(InputStream body) {
        try {
            byte[] byteArray = ByteStreams.toByteArray((InputStream)body);
            return new String(byteArray, Charsets.UTF_8);
        }
        catch (IOException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, e, "could not read body", new Object[0]);
        }
    }

    private static String resourceFor(ObjectSpecification objectSpec) {
        return objectSpec.getFullIdentifier();
    }

    static enum Intent {
        ACCESS,
        MUTATE;


        public boolean isMutate() {
            return this == MUTATE;
        }
    }

    public static enum MemberMode {
        NOT_MUTATING{

            @Override
            public void apply(AbstractObjectMemberReprRenderer<?, ?> renderer) {
                renderer.asStandalone();
            }
        }
        ,
        MUTATING{

            @Override
            public void apply(AbstractObjectMemberReprRenderer<?, ?> renderer) {
                renderer.asMutated();
            }
        };


        public abstract void apply(AbstractObjectMemberReprRenderer<?, ?> var1);
    }
}

