/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.DomainObjectResource;
import org.apache.isis.viewer.restfulobjects.server.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.server.resources.DomainResourceHelper;
import org.apache.isis.viewer.restfulobjects.server.resources.ResourceAbstract;
import org.jboss.resteasy.annotations.ClientResponseType;

@Path(value="/objects")
public class DomainObjectResourceServerside
extends ResourceAbstract
implements DomainObjectResource {
    @POST
    @Path(value="/{domainType}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    @ClientResponseType(entityType=String.class)
    public Response persist(@PathParam(value="domainType") String domainType, InputStream object) {
        this.init(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS);
        String objectStr = DomainResourceHelper.asStringUtf8(object);
        JsonRepresentation objectRepr = DomainResourceHelper.readAsMap(objectStr);
        if (!objectRepr.isMap()) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "Body is not a map; got %s", objectRepr);
        }
        ObjectSpecification domainTypeSpec = this.getSpecificationLoader().lookupBySpecId(ObjectSpecId.of((String)domainType));
        if (domainTypeSpec == null) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "Could not determine type of domain object to persist (no class with domainType Id of '%s')", domainType);
        }
        ObjectAdapter objectAdapter = this.getResourceContext().getPersistenceSession().createTransientInstance(domainTypeSpec);
        JsonRepresentation propertiesList = objectRepr.getArrayEnsured("members[memberType=property]");
        if (propertiesList == null) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "Could not find properties list (no members[memberType=property]); got %s", objectRepr);
        }
        if (!DomainResourceHelper.copyOverProperties(this.getResourceContext(), objectAdapter, propertiesList)) {
            throw RestfulObjectsApplicationException.createWithBody(RestfulResponse.HttpStatusCode.BAD_REQUEST, objectRepr, "Illegal property value", new Object[0]);
        }
        Consent validity = objectAdapter.getSpecification().isValid(objectAdapter);
        if (validity.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithBody(RestfulResponse.HttpStatusCode.BAD_REQUEST, objectRepr, validity.getReason(), new Object[0]);
        }
        this.getResourceContext().getPersistenceSession().makePersistent(objectAdapter);
        return new DomainResourceHelper(this.getResourceContext(), objectAdapter).objectRepresentation();
    }

    @GET
    @Path(value="/{domainType}/{instanceId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response object(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId) {
        this.init(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), objectAdapter);
        return helper.objectRepresentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{domainType}/{instanceId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response object(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String oidStr, InputStream object) {
        this.init(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS);
        String objectStr = DomainResourceHelper.asStringUtf8(object);
        JsonRepresentation objectRepr = DomainResourceHelper.readAsMap(objectStr);
        if (!objectRepr.isMap()) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "Body is not a map; got %s", objectRepr);
        }
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, oidStr);
        JsonRepresentation propertiesList = objectRepr.getArrayEnsured("members[memberType=property]");
        if (propertiesList == null) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "Could not find properties list (no members[memberType=property]); got %s", objectRepr);
        }
        IsisTransactionManager transactionManager = this.getResourceContext().getPersistenceSession().getTransactionManager();
        transactionManager.startTransaction();
        try {
            if (!DomainResourceHelper.copyOverProperties(this.getResourceContext(), objectAdapter, propertiesList)) {
                transactionManager.abortTransaction();
                throw RestfulObjectsApplicationException.createWithBody(RestfulResponse.HttpStatusCode.BAD_REQUEST, objectRepr, "Illegal property value", new Object[0]);
            }
            Consent validity = objectAdapter.getSpecification().isValid(objectAdapter);
            if (validity.isVetoed()) {
                transactionManager.abortTransaction();
                throw RestfulObjectsApplicationException.createWithBody(RestfulResponse.HttpStatusCode.BAD_REQUEST, objectRepr, validity.getReason(), new Object[0]);
            }
            transactionManager.endTransaction();
        }
        finally {
            if (!transactionManager.getTransaction().getState().isComplete()) {
                transactionManager.abortTransaction();
            }
        }
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), objectAdapter);
        return helper.objectRepresentation();
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-property", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response propertyDetails(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String oidStr, @PathParam(value="propertyId") String propertyId) {
        this.init(RepresentationType.OBJECT_PROPERTY, Where.OBJECT_FORMS);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, oidStr);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), objectAdapter);
        return helper.propertyDetails(propertyId, DomainResourceHelper.MemberMode.NOT_MUTATING, ResourceAbstract.Caching.NONE, this.getResourceContext().getWhere());
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response modifyProperty(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String oidStr, @PathParam(value="propertyId") String propertyId, InputStream body) {
        this.init(Where.OBJECT_FORMS);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, oidStr);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), objectAdapter);
        OneToOneAssociation property = helper.getPropertyThatIsVisibleForIntent(propertyId, DomainResourceHelper.Intent.MUTATE, this.getResourceContext().getWhere());
        ObjectSpecification propertySpec = property.getSpecification();
        String bodyAsString = DomainResourceHelper.asStringUtf8(body);
        ObjectAdapter argAdapter = helper.parseAsMapWithSingleValue(propertySpec, bodyAsString);
        Consent consent = property.isAssociationValid(objectAdapter, argAdapter);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.UNAUTHORIZED, consent.getReason(), new Object[0]);
        }
        property.set(objectAdapter, argAdapter);
        return helper.propertyDetails(propertyId, DomainResourceHelper.MemberMode.MUTATING, ResourceAbstract.Caching.NONE, this.getResourceContext().getWhere());
    }

    @DELETE
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response clearProperty(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String oidStr, @PathParam(value="propertyId") String propertyId) {
        this.init(Where.OBJECT_FORMS);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, oidStr);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), objectAdapter);
        OneToOneAssociation property = helper.getPropertyThatIsVisibleForIntent(propertyId, DomainResourceHelper.Intent.MUTATE, this.getResourceContext().getWhere());
        Consent consent = property.isAssociationValid(objectAdapter, null);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.UNAUTHORIZED, consent.getReason(), new Object[0]);
        }
        property.set(objectAdapter, null);
        return helper.propertyDetails(propertyId, DomainResourceHelper.MemberMode.MUTATING, ResourceAbstract.Caching.NONE, this.getResourceContext().getWhere());
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-collection", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response accessCollection(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String oidStr, @PathParam(value="collectionId") String collectionId) {
        this.init(RepresentationType.OBJECT_COLLECTION, Where.PARENTED_TABLES);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, oidStr);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), objectAdapter);
        return helper.collectionDetails(collectionId, DomainResourceHelper.MemberMode.NOT_MUTATING, ResourceAbstract.Caching.NONE, this.getResourceContext().getWhere());
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response addToSet(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String oidStr, @PathParam(value="collectionId") String collectionId, InputStream body) {
        String bodyAsString;
        this.init(Where.PARENTED_TABLES);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, oidStr);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), objectAdapter);
        OneToManyAssociation collection = helper.getCollectionThatIsVisibleForIntent(collectionId, DomainResourceHelper.Intent.MUTATE, this.getResourceContext().getWhere());
        if (!collection.getCollectionSemantics().isSet()) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "Collection '%s' does not have set semantics", collectionId);
        }
        ObjectSpecification collectionSpec = collection.getSpecification();
        ObjectAdapter argAdapter = helper.parseAsMapWithSingleValue(collectionSpec, bodyAsString = DomainResourceHelper.asStringUtf8(body));
        Consent consent = collection.isValidToAdd(objectAdapter, argAdapter);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.UNAUTHORIZED, consent.getReason(), new Object[0]);
        }
        collection.addElement(objectAdapter, argAdapter);
        return helper.collectionDetails(collectionId, DomainResourceHelper.MemberMode.MUTATING, ResourceAbstract.Caching.NONE, this.getResourceContext().getWhere());
    }

    @POST
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response addToList(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String oidStr, @PathParam(value="collectionId") String collectionId, InputStream body) {
        String bodyAsString;
        this.init(Where.PARENTED_TABLES);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, oidStr);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), objectAdapter);
        OneToManyAssociation collection = helper.getCollectionThatIsVisibleForIntent(collectionId, DomainResourceHelper.Intent.MUTATE, this.getResourceContext().getWhere());
        if (!collection.getCollectionSemantics().isListOrArray()) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, "Collection '%s' does not have list or array semantics", collectionId);
        }
        ObjectSpecification collectionSpec = collection.getSpecification();
        ObjectAdapter argAdapter = helper.parseAsMapWithSingleValue(collectionSpec, bodyAsString = DomainResourceHelper.asStringUtf8(body));
        Consent consent = collection.isValidToAdd(objectAdapter, argAdapter);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.UNAUTHORIZED, consent.getReason(), new Object[0]);
        }
        collection.addElement(objectAdapter, argAdapter);
        return helper.collectionDetails(collectionId, DomainResourceHelper.MemberMode.MUTATING, ResourceAbstract.Caching.NONE, this.getResourceContext().getWhere());
    }

    @DELETE
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response removeFromCollection(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String oidStr, @PathParam(value="collectionId") String collectionId) {
        this.init(Where.PARENTED_TABLES);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, oidStr);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), objectAdapter);
        OneToManyAssociation collection = helper.getCollectionThatIsVisibleForIntent(collectionId, DomainResourceHelper.Intent.MUTATE, this.getResourceContext().getWhere());
        ObjectSpecification collectionSpec = collection.getSpecification();
        ObjectAdapter argAdapter = helper.parseAsMapWithSingleValue(collectionSpec, this.getResourceContext().getQueryString());
        Consent consent = collection.isValidToRemove(objectAdapter, argAdapter);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.UNAUTHORIZED, consent.getReason(), new Object[0]);
        }
        collection.removeElement(objectAdapter, argAdapter);
        return helper.collectionDetails(collectionId, DomainResourceHelper.MemberMode.MUTATING, ResourceAbstract.Caching.NONE, this.getResourceContext().getWhere());
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-action", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response actionPrompt(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String oidStr, @PathParam(value="actionId") String actionId) {
        this.init(RepresentationType.OBJECT_ACTION, Where.OBJECT_FORMS);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, oidStr);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), objectAdapter);
        return helper.actionPrompt(actionId, this.getResourceContext().getWhere());
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeActionQueryOnly(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String oidStr, @PathParam(value="actionId") String actionId, @QueryParam(value="x-isis-querystring") String xIsisQueryString) {
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, xIsisQueryString);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, oidStr);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), objectAdapter);
        return helper.invokeActionQueryOnly(actionId, arguments, this.getResourceContext().getWhere());
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeActionIdempotent(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String oidStr, @PathParam(value="actionId") String actionId, InputStream body) {
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, body);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, oidStr);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), objectAdapter);
        return helper.invokeActionIdempotent(actionId, arguments, this.getResourceContext().getWhere());
    }

    @POST
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeAction(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String oidStr, @PathParam(value="actionId") String actionId, InputStream body) {
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, body);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, oidStr);
        DomainResourceHelper helper = new DomainResourceHelper(this.getResourceContext(), objectAdapter);
        return helper.invokeAction(actionId, arguments, this.getResourceContext().getWhere());
    }
}

