/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.authentication;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.runtime.authentication.standard.SimpleSession;
import org.apache.isis.core.webapp.auth.AuthenticationSessionStrategyAbstract;

public class AuthenticationSessionStrategyHeader
extends AuthenticationSessionStrategyAbstract {
    public AuthenticationSession lookupValid(ServletRequest servletRequest, ServletResponse servletResponse) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String user = httpServletRequest.getHeader("isis.user");
        List<String> roles = this.rolesFrom(httpServletRequest);
        if (Strings.isNullOrEmpty((String)user)) {
            return null;
        }
        return new SimpleSession(user, roles);
    }

    protected List<String> rolesFrom(HttpServletRequest httpServletRequest) {
        String rolesStr = httpServletRequest.getHeader("isis.roles");
        if (rolesStr == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)rolesStr));
    }
}

