/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.authentication;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.runtime.authentication.AuthenticationRequestPassword;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.webapp.auth.AuthenticationSessionStrategyAbstract;

public class AuthenticationSessionStrategyBasicAuth
extends AuthenticationSessionStrategyAbstract {
    private static Pattern USER_AND_PASSWORD_REGEX = Pattern.compile("^(.+):(.+)$");

    public AuthenticationSession lookupValid(ServletRequest servletRequest, ServletResponse servletResponse) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String authStr = httpServletRequest.getHeader("Authorization");
        if (authStr == null || !authStr.startsWith("Basic ")) {
            return null;
        }
        String digest = authStr.substring(6);
        String userAndPassword = new String(new Base64().decode(digest.getBytes()));
        Matcher matcher = USER_AND_PASSWORD_REGEX.matcher(userAndPassword);
        if (!matcher.matches()) {
            return null;
        }
        String user = matcher.group(1);
        String password = matcher.group(2);
        AuthenticationSession authSession = this.getAuthenticationManager().authenticate((AuthenticationRequest)new AuthenticationRequestPassword(user, password));
        return authSession;
    }

    protected AuthenticationManager getAuthenticationManager() {
        return IsisContext.getAuthenticationManager();
    }
}

